/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.api.GradleException;
import org.gradle.platform.Architecture;
import org.gradle.platform.BuildPlatform;
import org.gradle.platform.OperatingSystem;

public class DefaultBuildPlatform
implements BuildPlatform {
    private Supplier<Architecture> architecture = Suppliers.memoize(() -> DefaultBuildPlatform.getArchitecture(systemInfo));
    private Supplier<OperatingSystem> operatingSystem = Suppliers.memoize(() -> DefaultBuildPlatform.getOperatingSystem(operatingSystem));

    @Inject
    public DefaultBuildPlatform(SystemInfo systemInfo, org.gradle.internal.os.OperatingSystem operatingSystem) {
    }

    @Override
    public Architecture getArchitecture() {
        return (Architecture)((Object)this.architecture.get());
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return (OperatingSystem)((Object)this.operatingSystem.get());
    }

    private static Architecture getArchitecture(SystemInfo systemInfo) {
        SystemInfo.Architecture architecture = systemInfo.getArchitecture();
        switch (architecture) {
            case i386: {
                return Architecture.X86;
            }
            case amd64: {
                return Architecture.X86_64;
            }
            case aarch64: {
                return Architecture.AARCH64;
            }
        }
        throw new GradleException("Unhandled system architecture: " + architecture);
    }

    private static OperatingSystem getOperatingSystem(org.gradle.internal.os.OperatingSystem operatingSystem) {
        if (org.gradle.internal.os.OperatingSystem.LINUX == operatingSystem) {
            return OperatingSystem.LINUX;
        }
        if (org.gradle.internal.os.OperatingSystem.UNIX == operatingSystem) {
            return OperatingSystem.UNIX;
        }
        if (org.gradle.internal.os.OperatingSystem.WINDOWS == operatingSystem) {
            return OperatingSystem.WINDOWS;
        }
        if (org.gradle.internal.os.OperatingSystem.MAC_OS == operatingSystem) {
            return OperatingSystem.MAC_OS;
        }
        if (org.gradle.internal.os.OperatingSystem.SOLARIS == operatingSystem) {
            return OperatingSystem.SOLARIS;
        }
        if (org.gradle.internal.os.OperatingSystem.FREE_BSD == operatingSystem) {
            return OperatingSystem.FREE_BSD;
        }
        throw new GradleException("Unhandled operating system: " + operatingSystem.getName());
    }
}

