/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.io.FileWriter;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.configurations.ConfigurationReports;
import org.gradle.api.tasks.diagnostics.internal.configurations.ConfigurationReportsImpl;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ConfigurationReportModel;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ConfigurationReportModelFactory;
import org.gradle.api.tasks.diagnostics.internal.configurations.renderer.AbstractWritableConfigurationReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.configurations.renderer.ConsoleConfigurationReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.configurations.spec.AbstractConfigurationReportSpec;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.serialization.Cached;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Produces only non-cacheable console output")
public abstract class AbstractConfigurationReportTask
extends DefaultTask
implements Reporting<ConfigurationReports> {
    private final ConfigurationReports reports;
    private final Cached<ConfigurationReportModel> reportModel = Cached.of(this::createReportModel);

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract StyledTextOutputFactory getTextOutputFactory();

    @Inject
    protected abstract FileResolver getFileResolver();

    protected abstract AbstractConfigurationReportSpec buildReportSpec();

    public AbstractConfigurationReportTask() {
        this.reports = (ConfigurationReports)this.getObjectFactory().newInstance(ConfigurationReportsImpl.class, new Object[]{this});
    }

    @Nested
    public final ConfigurationReports getReports() {
        return this.reports;
    }

    public ConfigurationReports reports(@DelegatesTo(value=ConfigurationReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public ConfigurationReports reports(Action<? super ConfigurationReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    private ConfigurationReportModel createReportModel() {
        return this.buildReportModel(this.getProject());
    }

    @TaskAction
    public final void report() {
        AbstractConfigurationReportSpec reportSpec = this.buildReportSpec();
        ConfigurationReportModel model = (ConfigurationReportModel)this.reportModel.get();
        this.reportToConsole(reportSpec, model);
    }

    private void reportToFile(SingleFileReport report, AbstractConfigurationReportSpec reportSpec, ConfigurationReportModel reportModel) {
        File outputFile = ((RegularFile)report.getOutputLocation().get()).getAsFile();
        AbstractWritableConfigurationReportRenderer renderer = this.buildToFileRenderer(report, reportSpec);
        try (FileWriter fw = new FileWriter(outputFile);){
            renderer.render(reportModel, fw);
        }
        catch (Exception e) {
            throw new GradleException("Failed to write '" + report.getName() + "' report to " + outputFile, (Throwable)e);
        }
    }

    private void reportToConsole(AbstractConfigurationReportSpec reportSpec, ConfigurationReportModel reportModel) {
        ConsoleConfigurationReportRenderer renderer = new ConsoleConfigurationReportRenderer(reportSpec);
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        renderer.render(reportModel, output);
    }

    private AbstractWritableConfigurationReportRenderer buildToFileRenderer(SingleFileReport report, AbstractConfigurationReportSpec reportSpec) {
        switch (report.getName()) {
            default: 
        }
        throw new IllegalArgumentException("Unknown report type: " + report.getName());
    }

    private ConfigurationReportModel buildReportModel(Project project) {
        ConfigurationReportModelFactory factory = new ConfigurationReportModelFactory(this.getFileResolver());
        return factory.buildForProject(project);
    }
}

