/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public final class VFileCreateEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final ChildInfo[] myChildren;
    private final int myChildNameId;
    private VirtualFile myCreatedFile;

    @NotNull
    public String getChildName() {
        String string2 = VirtualFileManager.getInstance().getVFileName(this.myChildNameId).toString();
        if (string2 == null) {
            VFileCreateEvent.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile2 = this.myParent;
        if (virtualFile2 == null) {
            VFileCreateEvent.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    public boolean isEmptyDirectory() {
        return this.isDirectory() && this.myChildren != null && this.myChildren.length == 0;
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile createdFile = this.myCreatedFile;
        if (createdFile == null && this.myParent.isValid()) {
            this.myCreatedFile = createdFile = this.myParent.findChild(this.getChildName());
        }
        return createdFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            VFileCreateEvent.$$$reportNull$$$0(5);
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        return this.myDirectory == event.myDirectory && this.getChildName().equals(event.getChildName()) && this.myParent.equals(event.myParent);
    }

    public int hashCode() {
        int result2 = this.myParent.hashCode();
        result2 = 31 * result2 + (this.myDirectory ? 1 : 0);
        result2 = 31 * result2 + this.getChildName().hashCode();
        return result2;
    }

    public String toString() {
        String kind = this.myDirectory ? (this.isEmptyDirectory() ? "(empty) " : "") + "dir " : "file ";
        return "VfsEvent[create " + kind + "'" + this.myParent.getUrl() + "/" + this.getChildName() + "']" + (this.myChildren == null ? "" : " with " + this.myChildren.length + " children");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

