/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.ModifierAnnotationCategory;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandlerSupport;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;

public class InputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Input.class;
    }

    @Override
    public ImmutableSet<? extends AnnotationCategory> getAllowedModifiers() {
        return ImmutableSet.of((Object)((Object)ModifierAnnotationCategory.OPTIONAL));
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public boolean shouldVisit(PropertyVisitor visitor) {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor, BeanPropertyContext context) {
        visitor.visitInputProperty(propertyName, value, propertyMetadata.isAnnotationPresent(Optional.class));
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        PropertyAnnotationHandlerSupport.validateUnsupportedPropertyValueTypes(propertyMetadata, validationContext, this.getAnnotationType());
        Class<?> valueType = propertyMetadata.getGetterMethod().getReturnType();
        if (File.class.isAssignableFrom(valueType) || Path.class.isAssignableFrom(valueType) || FileCollection.class.isAssignableFrom(valueType)) {
            validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.INCORRECT_USE_OF_INPUT_ANNOTATION)).forProperty(propertyMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("has @Input annotation used on property of type '%s'", ModelType.of((Class)valueType).getDisplayName()))).happensBecause(() -> "A property of type '" + ModelType.of((Class)valueType).getDisplayName() + "' annotated with @Input cannot determine how to interpret the file")).addPossibleSolution("Annotate with @InputFile for regular files")).addPossibleSolution("Annotate with @InputDirectory for directories")).addPossibleSolution("If you want to track the path, return File.absolutePath as a String and keep @Input")).documentedAt("validation_problems", "incorrect_use_of_input_annotation"));
        }
        if (valueType.isPrimitive() && propertyMetadata.isAnnotationPresent(Optional.class)) {
            validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.CANNOT_USE_OPTIONAL_ON_PRIMITIVE_TYPE)).reportAs(Severity.ERROR)).forProperty(propertyMetadata.getPropertyName()).withDescription(() -> "of type " + valueType.getName() + " shouldn't be annotated with @Optional")).happensBecause("Properties of primitive type cannot be optional")).addPossibleSolution("Remove the @Optional annotation")).addPossibleSolution(() -> "Use the " + JavaReflectionUtil.getWrapperTypeForPrimitiveType((Class)valueType).getName() + " type instead")).documentedAt("validation_problems", "cannot_use_optional_on_primitive_types"));
        }
    }
}

