/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a,\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0003\"\b\b\u0000\u0010\u0017*\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a&\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u001f0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020\u0004\u001a\u0010\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020(\u001a\u001c\u0010)\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\u0010\u0010*\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020,\u001a\u0016\u0010-\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0\t*\u00020\u0010\u001a\u0010\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001d\u001a\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001d2\b\b\u0002\u0010\u0014\u001a\u00020\u0001\u00a8\u00062"}, d2={"appendArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "collectAccessors", "", "", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "fragments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "skipLabelsAndCatches", "collectDefinedNamesInAllScopes", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectLocalFunctions", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "collectNamedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "collectNamedFunctionsAndWrappers", "collectNamedFunctionsOrMetadata", "collectReferencedNames", "collectUsedNames", "extractFunction", "expression", "extractImportTag", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "extractImportTagImpl", "getImportTag", "jsVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "collectBreakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectFreeVariables", "collectLocalVariables", "js.translator"})
public final class CollectUtilsKt {
    @NotNull
    public static final Set<JsName> collectReferencedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set<JsName> $references;
            {
                this.$references = $references;
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null) {
                    Collection collection = this.$references;
                    boolean bl = false;
                    collection.add(name);
                }
            }
        }.accept(scope2);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set<JsName> $references;
            {
                this.$references = $references;
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    this.$references.add(name);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Collection collection = this.$references;
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                boolean bl = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        }.accept(scope2);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return CollectUtilsKt.collectDefinedNames(scope2, false);
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope2, boolean skipLabelsAndCatches) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2, skipLabelsAndCatches){
            final /* synthetic */ Set<JsName> $names;
            final /* synthetic */ boolean $skipLabelsAndCatches;
            {
                this.$names = $names;
                this.$skipLabelsAndCatches = $skipLabelsAndCatches;
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
                Collection collection = this.$names;
                JsName jsName = x.getName();
                boolean bl = false;
                collection.add(jsName);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsName name;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsFunction && (name = ((JsFunction)expression2).getName()) != null) {
                    Collection collection = this.$names;
                    JsName jsName = name;
                    boolean bl = false;
                    collection.add(jsName);
                }
                super.visitExpressionStatement(x);
            }

            public void visitLabel(@NotNull JsLabel x) {
                JsName jsName;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!this.$skipLabelsAndCatches && (jsName = x.getName()) != null) {
                    JsName jsName2 = jsName;
                    Set<JsName> set = this.$names;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsName it = jsName2;
                    boolean bl3 = false;
                    Collection collection = set;
                    boolean bl4 = false;
                    collection.add(it);
                }
                super.visitLabel(x);
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    Collection collection = this.$names;
                    JsName jsName = x.getParameter().getName();
                    boolean bl = false;
                    collection.add(jsName);
                }
                super.visitCatch(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
        }.accept(scope2);
        return names2;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNamesInAllScopes(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set<JsName> $names;
            {
                this.$names = $names;
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visit(x);
                Collection collection = this.$names;
                JsName jsName = x.getName();
                boolean bl = false;
                collection.add(jsName);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visitFunction(x);
                Object object = this.$names;
                Object object2 = x.getParameters();
                Intrinsics.checkNotNullExpressionValue(object2, (String)"x.parameters");
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"it.name");
                    JsName jsName2 = jsName;
                    collection.add(jsName2);
                }
                object2 = (List)destination$iv$iv;
                boolean bl = false;
                CollectionsKt.addAll((Collection)object, object2);
                object = x.getName();
                if (object != null) {
                    object2 = object;
                    Set<JsName> set = this.$names;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    Collection collection = set;
                    boolean bl5 = false;
                    collection.add(it);
                }
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName jsName = x.getName();
                if (jsName != null) {
                    JsName jsName2 = jsName;
                    Set<JsName> set = this.$names;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsName it = jsName2;
                    boolean bl3 = false;
                    Collection collection = set;
                    boolean bl4 = false;
                    collection.add(it);
                }
                super.visitLabel(x);
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Collection collection = this.$names;
                JsName jsName = x.getParameter().getName();
                boolean bl = false;
                collection.add(jsName);
                super.visitCatch(x);
            }
        }.accept(scope2);
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $this$collectFreeVariables) {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectFreeVariables, (String)"<this>");
        Object object = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"body");
        Set<JsName> set = CollectUtilsKt.collectUsedNames((JsNode)object);
        object = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"body");
        Set set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames((JsNode)object));
        object = $this$collectFreeVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters");
        object = (Iterable)object;
        Set set3 = set2;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"it.name");
            JsName jsName2 = jsName;
            collection.add(jsName2);
        }
        collection = (List)destination$iv$iv;
        return SetsKt.minus((Set)set3, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $this$collectLocalVariables, boolean skipLabelsAndCatches) {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectLocalVariables, (String)"<this>");
        Object object = $this$collectLocalVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"body");
        Set<JsName> set = CollectUtilsKt.collectDefinedNames((JsNode)object, skipLabelsAndCatches);
        object = $this$collectLocalVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters");
        object = (Iterable)object;
        Set<JsName> set2 = set;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"it.name");
            JsName jsName2 = jsName;
            collection.add(jsName2);
        }
        collection = (List)destination$iv$iv;
        return SetsKt.plus(set2, (Iterable)collection);
    }

    public static /* synthetic */ Set collectLocalVariables$default(JsFunction jsFunction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CollectUtilsKt.collectLocalVariables(jsFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope2);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            JsFunction jsFunction = ((FunctionWithWrapper)((Pair)it.getValue()).getFirst()).getFunction();
            map3.put(k2, jsFunction);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsExpression> collectNamedFunctionsOrMetadata(@NotNull JsNode scope2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope2);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            JsExpression jsExpression = (JsExpression)((Pair)it.getValue()).getSecond();
            map3.put(k2, jsExpression);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            Map map = result2;
            Map<JsName, JsFunction> map2 = CollectUtilsKt.collectNamedFunctions(fragment.getDeclarationBlock());
            boolean bl2 = false;
            map.putAll(map2);
            map = result2;
            map2 = CollectUtilsKt.collectNamedFunctions(fragment.getInitializerBlock());
            bl2 = false;
            map.putAll(map2);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, FunctionWithWrapper> collectNamedFunctionsAndWrappers(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            FunctionWithWrapper functionWithWrapper;
            Map.Entry it;
            Map map;
            Object k;
            Object k2;
            Map.Entry it$iv$iv;
            boolean bl2;
            Map map2;
            Map $this$mapValuesTo$iv$iv;
            Map map3 = result2;
            Map $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(fragment.getDeclarationBlock());
            boolean $i$f$mapValues = false;
            Map map4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl2 = false;
                k2 = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map2;
                boolean bl3 = false;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map.put(k, functionWithWrapper);
            }
            $this$mapValues$iv = destination$iv$iv;
            $i$f$mapValues = false;
            map3.putAll($this$mapValues$iv);
            map3 = result2;
            $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(fragment.getInitializerBlock());
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl2 = false;
                k2 = it$iv$iv.getKey();
                it = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map2;
                boolean bl4 = false;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map.put(k, functionWithWrapper);
            }
            Map map5 = destination$iv$iv;
            boolean bl5 = false;
            map3.putAll(map5);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, Pair<FunctionWithWrapper, JsExpression>> collectNamedFunctionsAndMetadata(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Map namedFunctions = new LinkedHashMap();
        scope2.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $namedFunctions;
            {
                this.$namedFunctions = $namedFunctions;
            }

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x);
                if (assignment != null) {
                    JsName name;
                    Pair<JsExpression, JsExpression> pair = assignment;
                    JsExpression left = (JsExpression)pair.component1();
                    JsExpression right = (JsExpression)pair.component2();
                    if (left instanceof JsNameRef && (name = ((JsNameRef)left).getName()) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                        FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(right);
                        if (functionWithWrapper != null) {
                            FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                            Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                            boolean bl = false;
                            boolean bl2 = false;
                            FunctionWithWrapper $dstr$function$wrapper = functionWithWrapper2;
                            boolean bl3 = false;
                            JsFunction function2 = $dstr$function$wrapper.component1();
                            JsBlock wrapper = $dstr$function$wrapper.component2();
                            Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = map;
                            Pair pair2 = new Pair((Object)new FunctionWithWrapper(function2, wrapper), (Object)right);
                            boolean bl4 = false;
                            map2.put(name, (Pair<FunctionWithWrapper, JsExpression>)pair2);
                        }
                    }
                }
                super.visitBinaryExpression(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                FunctionWithWrapper functionWithWrapper;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                JsName name = x.getName();
                if (initializer2 != null && name != null && (functionWithWrapper = CollectUtilsKt.extractFunction(initializer2)) != null) {
                    FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                    Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                    boolean bl = false;
                    boolean bl2 = false;
                    FunctionWithWrapper function2 = functionWithWrapper2;
                    boolean bl3 = false;
                    Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = map;
                    JsName jsName = name;
                    Pair pair = new Pair((Object)function2, (Object)initializer2);
                    boolean bl4 = false;
                    map2.put(jsName, (Pair<FunctionWithWrapper, JsExpression>)pair);
                }
                super.visit(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName name = x.getName();
                if (name != null) {
                    Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                    JsName jsName = name;
                    Pair pair = new Pair((Object)new FunctionWithWrapper(x, null), (Object)x);
                    boolean bl = false;
                    map.put(jsName, (Pair<FunctionWithWrapper, JsExpression>)pair);
                }
                super.visitFunction(x);
            }
        });
        return namedFunctions;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        HashMap<String, FunctionWithWrapper> accessors = new HashMap<String, FunctionWithWrapper>();
        scope2.accept(new RecursiveJsVisitor(accessors){
            final /* synthetic */ HashMap<String, FunctionWithWrapper> $accessors;
            {
                this.$accessors = $accessors;
            }

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(invocation);
                if (inlineMetadata != null) {
                    InlineMetadata inlineMetadata2 = inlineMetadata;
                    HashMap<String, FunctionWithWrapper> hashMap = this.$accessors;
                    boolean bl = false;
                    boolean bl2 = false;
                    InlineMetadata it = inlineMetadata2;
                    boolean bl3 = false;
                    Map map = hashMap;
                    String string2 = it.getTag().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.tag.value");
                    FunctionWithWrapper functionWithWrapper = it.getFunction();
                    boolean bl4 = false;
                    map.put(string2, functionWithWrapper);
                }
                super.visitInvocation(invocation);
            }
        });
        return accessors;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull Iterable<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            Map map = result2;
            Map<String, FunctionWithWrapper> map2 = CollectUtilsKt.collectAccessors(fragment.getDeclarationBlock());
            boolean bl2 = false;
            map.putAll(map2);
        }
        return result2;
    }

    @NotNull
    public static final Map<CallableDescriptor, FunctionWithWrapper> collectLocalFunctions(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        HashMap<CallableDescriptor, FunctionWithWrapper> localFunctions = new HashMap<CallableDescriptor, FunctionWithWrapper>();
        scope2.accept(new RecursiveJsVisitor(localFunctions){
            final /* synthetic */ HashMap<CallableDescriptor, FunctionWithWrapper> $localFunctions;
            {
                this.$localFunctions = $localFunctions;
            }

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(invocation);
                if (functionWithWrapper != null) {
                    FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                    HashMap<CallableDescriptor, FunctionWithWrapper> hashMap = this.$localFunctions;
                    boolean bl = false;
                    boolean bl2 = false;
                    FunctionWithWrapper it = functionWithWrapper2;
                    boolean bl3 = false;
                    FunctionDescriptor functionDescriptor = MetadataProperties.getFunctionDescriptor(it.getFunction());
                    if (functionDescriptor != null) {
                        FunctionDescriptor functionDescriptor2 = functionDescriptor;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        FunctionDescriptor fd = functionDescriptor2;
                        boolean bl6 = false;
                        Map map = hashMap;
                        boolean bl7 = false;
                        map.put(fd, it);
                    }
                }
                super.visitInvocation(invocation);
            }
        });
        return localFunctions;
    }

    @NotNull
    public static final Map<CallableDescriptor, FunctionWithWrapper> collectLocalFunctions(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            Map map = result2;
            Map<CallableDescriptor, FunctionWithWrapper> map2 = CollectUtilsKt.collectLocalFunctions(fragment.getDeclarationBlock());
            boolean bl2 = false;
            map.putAll(map2);
        }
        return result2;
    }

    @Nullable
    public static final FunctionWithWrapper extractFunction(@NotNull JsExpression expression2) {
        FunctionWithWrapper functionWithWrapper;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            functionWithWrapper = new FunctionWithWrapper((JsFunction)expression2, null);
        } else {
            InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(expression2);
            FunctionWithWrapper functionWithWrapper2 = inlineMetadata == null ? null : inlineMetadata.getFunction();
            functionWithWrapper = functionWithWrapper2 == null ? InlineMetadata.Companion.tryExtractFunction(expression2) : functionWithWrapper2;
        }
        return functionWithWrapper;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        InstanceCollector<JsNode> instanceCollector = new InstanceCollector<JsNode>(klass, false);
        boolean bl = false;
        boolean bl2 = false;
        InstanceCollector<JsNode> $this$collectInstances_u24lambda_u2d6 = instanceCollector;
        boolean bl3 = false;
        $this$collectInstances_u24lambda_u2d6.accept(scope2);
        return $this$collectInstances_u24lambda_u2d6.getCollected();
    }

    @NotNull
    public static final Map<JsContinue, JsStatement> collectBreakContinueTargets(@NotNull JsNode $this$collectBreakContinueTargets) {
        Intrinsics.checkNotNullParameter((Object)$this$collectBreakContinueTargets, (String)"<this>");
        boolean bl = false;
        Map targets = new LinkedHashMap();
        $this$collectBreakContinueTargets.accept(new RecursiveJsVisitor(targets){
            @Nullable
            private JsStatement defaultBreakTarget;
            @NotNull
            private Map<JsName, JsStatement> breakTargets;
            @Nullable
            private JsStatement defaultContinueTarget;
            @NotNull
            private Map<JsName, JsStatement> continueTargets;
            final /* synthetic */ Map<JsContinue, JsStatement> $targets;
            {
                this.$targets = $targets;
                boolean bl = false;
                this.breakTargets = new LinkedHashMap<K, V>();
                bl = false;
                this.continueTargets = new LinkedHashMap<K, V>();
            }

            @Nullable
            public final JsStatement getDefaultBreakTarget() {
                return this.defaultBreakTarget;
            }

            public final void setDefaultBreakTarget(@Nullable JsStatement jsStatement) {
                this.defaultBreakTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getBreakTargets() {
                return this.breakTargets;
            }

            public final void setBreakTargets(@NotNull Map<JsName, JsStatement> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.breakTargets = map;
            }

            @Nullable
            public final JsStatement getDefaultContinueTarget() {
                return this.defaultContinueTarget;
            }

            public final void setDefaultContinueTarget(@Nullable JsStatement jsStatement) {
                this.defaultContinueTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getContinueTargets() {
                return this.continueTargets;
            }

            public final void setContinueTargets(@NotNull Map<JsName, JsStatement> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.continueTargets = map;
            }

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement inner;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = inner = x.getStatement();
                if (jsStatement instanceof JsDoWhile) {
                    Intrinsics.checkNotNullExpressionValue((Object)inner, (String)"inner");
                    JsStatement jsStatement2 = ((JsDoWhile)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"inner.body");
                    this.handleLoop(inner, jsStatement2, x.getName());
                } else if (jsStatement instanceof JsWhile) {
                    Intrinsics.checkNotNullExpressionValue((Object)inner, (String)"inner");
                    JsStatement jsStatement3 = ((JsWhile)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"inner.body");
                    this.handleLoop(inner, jsStatement3, x.getName());
                } else if (jsStatement instanceof JsFor) {
                    Intrinsics.checkNotNullExpressionValue((Object)inner, (String)"inner");
                    JsStatement jsStatement4 = ((JsFor)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement4, (String)"inner.body");
                    this.handleLoop(inner, jsStatement4, x.getName());
                } else if (jsStatement instanceof JsSwitch) {
                    Intrinsics.checkNotNullExpressionValue((Object)inner, (String)"inner");
                    this.handleSwitch((JsSwitch)inner, x.getName());
                } else {
                    JsName jsName = x.getName();
                    JsStatement jsStatement5 = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement5, (String)"x.statement");
                    this.withBreakAndContinue(jsName, jsStatement5, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, inner){
                        final /* synthetic */ collectBreakContinueTargets.1 this$0;
                        final /* synthetic */ JsStatement $inner;
                        {
                            this.this$0 = $receiver;
                            this.$inner = $inner;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.accept((JsNode)this.$inner);
                        }
                    }));
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.handleSwitch(x, null);
            }

            private final void handleSwitch(JsSwitch statement2, JsName label) {
                collectBreakContinueTargets.1.withBreakAndContinue$default(this, label, statement2, null, (Function0)new Function0<Unit>(statement2, this){
                    final /* synthetic */ JsSwitch $statement;
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    {
                        this.$statement = $statement;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        Iterable<JsSwitchMember> iterable = this.$statement.getCases();
                        Intrinsics.checkNotNullExpressionValue(iterable, (String)"statement.cases");
                        iterable = iterable;
                        collectBreakContinueTargets.1 var2_2 = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsSwitchMember it = (JsSwitchMember)element$iv;
                            boolean bl = false;
                            var2_2.accept((JsNode)it);
                        }
                    }
                }, 4, null);
            }

            private final void handleLoop(JsStatement loop2, JsStatement body2, JsName label) {
                this.withBreakAndContinue(label, loop2, loop2, (Function0<Unit>)((Function0)new Function0<Unit>(body2, this){
                    final /* synthetic */ JsStatement $body;
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    {
                        this.$body = $body;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$body.accept(this.this$0);
                    }
                }));
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement jsStatement;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Object object = x.getLabel();
                JsName targetLabel = object == null ? null : ((JsNameRef)object).getName();
                object = this.$targets;
                if (targetLabel == null) {
                    JsStatement jsStatement2 = this.defaultBreakTarget;
                    jsStatement = jsStatement2;
                    Intrinsics.checkNotNull((Object)jsStatement2);
                } else {
                    JsStatement jsStatement3 = this.breakTargets.get(targetLabel);
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    jsStatement = jsStatement3;
                }
                JsStatement jsStatement4 = jsStatement;
                boolean bl = false;
                object.put(x, jsStatement4);
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement jsStatement;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Object object = x.getLabel();
                JsName targetLabel = object == null ? null : ((JsNameRef)object).getName();
                object = this.$targets;
                if (targetLabel == null) {
                    JsStatement jsStatement2 = this.defaultContinueTarget;
                    jsStatement = jsStatement2;
                    Intrinsics.checkNotNull((Object)jsStatement2);
                } else {
                    JsStatement jsStatement3 = this.continueTargets.get(targetLabel);
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    jsStatement = jsStatement3;
                }
                JsStatement jsStatement4 = jsStatement;
                boolean bl = false;
                object.put(x, jsStatement4);
            }

            private final void withBreakAndContinue(JsName label, JsStatement breakTargetStatement, JsStatement continueTargetStatement, Function0<Unit> action) {
                boolean bl;
                Map<JsName, JsStatement> map;
                JsStatement oldDefaultBreakTarget = this.defaultBreakTarget;
                JsStatement oldDefaultContinueTarget = this.defaultContinueTarget;
                Pair pair = label != null ? new Pair((Object)this.breakTargets.get(label), (Object)this.continueTargets.get(label)) : new Pair(null, null);
                JsStatement oldBreakTarget = (JsStatement)pair.component1();
                JsStatement oldContinueTarget = (JsStatement)pair.component2();
                this.defaultBreakTarget = breakTargetStatement;
                if (label != null) {
                    map = this.breakTargets;
                    bl = false;
                    map.put(label, breakTargetStatement);
                    map = this.continueTargets;
                    bl = false;
                    map.put(label, continueTargetStatement);
                }
                if (continueTargetStatement != null) {
                    this.defaultContinueTarget = continueTargetStatement;
                }
                action.invoke();
                this.defaultBreakTarget = oldDefaultBreakTarget;
                this.defaultContinueTarget = oldDefaultContinueTarget;
                if (label != null) {
                    map = this.breakTargets;
                    bl = false;
                    map.put(label, oldBreakTarget);
                    map = this.continueTargets;
                    bl = false;
                    map.put(label, oldContinueTarget);
                }
            }

            static /* synthetic */ void withBreakAndContinue$default(collectBreakContinueTargets.1 var0, JsName jsName, JsStatement jsStatement, JsStatement jsStatement2, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    jsStatement2 = null;
                }
                var0.withBreakAndContinue(jsName, jsStatement, jsStatement2, (Function0<Unit>)function0);
            }
        });
        return targets;
    }

    @Nullable
    public static final String getImportTag(@NotNull JsVars jsVars) {
        Intrinsics.checkNotNullParameter((Object)jsVars, (String)"jsVars");
        if (jsVars.getVars().size() == 1) {
            JsVars.JsVar jsVar = jsVars.getVars().get(0);
            JsName jsName = jsVar.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"jsVar.name");
            if (MetadataProperties.getImported(jsName)) {
                Intrinsics.checkNotNullExpressionValue((Object)jsVar, (String)"jsVar");
                return CollectUtilsKt.extractImportTag(jsVar);
            }
        }
        return null;
    }

    @Nullable
    public static final String extractImportTag(@NotNull JsVars.JsVar jsVar) {
        Intrinsics.checkNotNullParameter((Object)jsVar, (String)"jsVar");
        JsExpression jsExpression = jsVar.getInitExpression();
        if (jsExpression == null) {
            return null;
        }
        JsExpression initExpression = jsExpression;
        StringBuilder sb = new StringBuilder();
        if (initExpression instanceof JsInvocation || initExpression instanceof JsNew) {
            sb.append(jsVar.getName().toString()).append(":");
        }
        return CollectUtilsKt.extractImportTagImpl(initExpression, sb) ? sb.toString() : null;
    }

    private static final boolean extractImportTagImpl(JsExpression expression2, StringBuilder sb) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsNameRef) {
            JsExpression nameRef = expression2;
            if (((JsNameRef)nameRef).getQualifier() != null) {
                JsExpression jsExpression2 = ((JsNameRef)nameRef).getQualifier();
                Intrinsics.checkNotNull((Object)jsExpression2);
                JsExpression jsExpression3 = jsExpression2;
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"nameRef.qualifier!!");
                if (!CollectUtilsKt.extractImportTagImpl(jsExpression3, sb)) {
                    return false;
                }
                sb.append('.');
            }
            sb.append(JsToStringGenerationVisitor.javaScriptString(((JsNameRef)nameRef).getIdent()));
            return true;
        }
        if (jsExpression instanceof JsArrayAccess) {
            JsStringLiteral jsStringLiteral;
            JsExpression arrayAccess = expression2;
            JsExpression jsExpression4 = ((JsArrayAccess)arrayAccess).getArrayExpression();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"arrayAccess.arrayExpression");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression4, sb)) {
                return false;
            }
            sb.append(".");
            JsExpression jsExpression5 = ((JsArrayAccess)arrayAccess).getIndexExpression();
            JsStringLiteral jsStringLiteral2 = jsStringLiteral = jsExpression5 instanceof JsStringLiteral ? (JsStringLiteral)jsExpression5 : null;
            if (jsStringLiteral == null) {
                return false;
            }
            JsStringLiteral stringLiteral = jsStringLiteral;
            sb.append(JsToStringGenerationVisitor.javaScriptString(stringLiteral.getValue()));
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression invocation = expression2;
            Object object = ((JsInvocation)invocation).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invocation.qualifier");
            if (!CollectUtilsKt.extractImportTagImpl((JsExpression)object, sb)) {
                return false;
            }
            object = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invocation.arguments");
            return CollectUtilsKt.appendArguments((List<? extends JsExpression>)object, sb);
        }
        if (jsExpression instanceof JsNew) {
            JsExpression newExpr = expression2;
            Object object = ((JsNew)newExpr).getConstructorExpression();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newExpr.constructorExpression");
            if (!CollectUtilsKt.extractImportTagImpl((JsExpression)object, sb)) {
                return false;
            }
            object = ((JsNew)newExpr).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newExpr.arguments");
            return CollectUtilsKt.appendArguments((List<? extends JsExpression>)object, sb);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean appendArguments(List<? extends JsExpression> arguments2, StringBuilder sb) {
        Iterable $this$forEachIndexed$iv = arguments2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void arg;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsExpression jsExpression = (JsExpression)item$iv;
            int index2 = n;
            boolean bl2 = false;
            if (!(arg instanceof JsIntLiteral)) {
                return false;
            }
            sb.append(index2 == 0 ? "(" : ",");
            sb.append(((JsIntLiteral)arg).value);
        }
        sb.append(")");
        return true;
    }
}

