/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import java.io.File;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.reporting.dependencies.internal.JsonProjectDependencyRenderer;
import org.gradle.api.reporting.dependencies.internal.ProjectPageRenderer;
import org.gradle.api.reporting.dependencies.internal.ProjectsPageRenderer;
import org.gradle.reporting.HtmlReportBuilder;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.internal.GFileUtils;

public class HtmlDependencyReporter
extends ReportRenderer<Set<Project>, File> {
    private File outputDirectory;
    private final JsonProjectDependencyRenderer renderer;

    public HtmlDependencyReporter(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.renderer = new JsonProjectDependencyRenderer(versionSelectorScheme, versionComparator, versionParser);
    }

    public void render(final Set<Project> projects, File outputDirectory) {
        this.outputDirectory = outputDirectory;
        HtmlReportRenderer renderer = new HtmlReportRenderer();
        renderer.render(projects, (ReportRenderer)new ReportRenderer<Set<Project>, HtmlReportBuilder>(){

            public void render(Set<Project> model, HtmlReportBuilder builder) {
                Transformer htmlPageScheme = HtmlDependencyReporter.this.projectNamingScheme("html");
                Transformer jsScheme = HtmlDependencyReporter.this.projectNamingScheme("js");
                ProjectPageRenderer projectPageRenderer = new ProjectPageRenderer((Transformer<String, Project>)jsScheme);
                builder.renderRawHtmlPage("index.html", (Object)projects, (ReportRenderer)new ProjectsPageRenderer((Transformer<String, Project>)htmlPageScheme));
                for (Project project : projects) {
                    String jsFileName = (String)jsScheme.transform((Object)project);
                    HtmlDependencyReporter.this.generateJsFile(project, jsFileName);
                    String htmlFileName = (String)htmlPageScheme.transform((Object)project);
                    builder.renderRawHtmlPage(htmlFileName, (Object)project, (ReportRenderer)projectPageRenderer);
                }
            }
        }, outputDirectory);
    }

    private void generateJsFile(Project project, String fileName) {
        String json = this.renderer.render(project);
        String content = "var projectDependencyReport = " + json + ";";
        GFileUtils.writeFile((String)content, (File)new File(this.outputDirectory, fileName), (String)"utf-8");
    }

    private Transformer<String, Project> projectNamingScheme(String extension) {
        return project -> this.toFileName((Project)project, "." + extension);
    }

    private String toFileName(Project project, String extension) {
        String name = project.getPath();
        if (name.equals(":")) {
            return "root" + extension;
        }
        return "root" + name.replace(":", ".") + extension;
    }
}

