/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.Collection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelAction;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class DefaultBuildTreeModelCreator
implements BuildTreeModelCreator {
    private final BuildLifecycleController buildController;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectLeaseRegistry projectLeaseRegistry;
    private final boolean parallelActions;
    private final Object treeMutableStateLock = new Object();

    public DefaultBuildTreeModelCreator(BuildModelParameters buildModelParameters, BuildLifecycleController buildLifecycleController, BuildOperationExecutor buildOperationExecutor, ProjectLeaseRegistry projectLeaseRegistry) {
        this.buildController = buildLifecycleController;
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectLeaseRegistry = projectLeaseRegistry;
        this.parallelActions = buildModelParameters.isParallelToolingApiActions();
    }

    @Override
    public <T> void beforeTasks(BuildToolingModelAction<? extends T> action) {
        action.beforeTasks(new DefaultBuildToolingModelController());
    }

    @Override
    public <T> T fromBuildModel(BuildToolingModelAction<? extends T> action) {
        return action.fromBuildModel(new DefaultBuildToolingModelController());
    }

    private class DefaultBuildToolingModelController
    implements BuildToolingModelController {
        private DefaultBuildToolingModelController() {
        }

        @Override
        public GradleInternal getConfiguredModel() {
            return DefaultBuildTreeModelCreator.this.buildController.getConfiguredBuild();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolingModelBuilderLookup.Builder locateBuilderForDefaultTarget(String modelName, boolean param) {
            Object object = DefaultBuildTreeModelCreator.this.treeMutableStateLock;
            synchronized (object) {
                ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)DefaultBuildTreeModelCreator.this.buildController.getGradle().getServices().get(ToolingModelBuilderLookup.class);
                ToolingModelBuilderLookup.Builder builder = lookup.maybeLocateForBuildScope(modelName, param, DefaultBuildTreeModelCreator.this.buildController.getGradle().getOwner());
                if (builder != null) {
                    return builder;
                }
                return this.locateBuilderForTarget(DefaultBuildTreeModelCreator.this.buildController.getGradle().getOwner(), modelName, param);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolingModelBuilderLookup.Builder locateBuilderForTarget(BuildState target, String modelName, boolean param) throws UnknownModelException {
            Object object = DefaultBuildTreeModelCreator.this.treeMutableStateLock;
            synchronized (object) {
                DefaultBuildTreeModelCreator.this.buildController.getGradle().getOwner().ensureProjectsConfigured();
                target.ensureProjectsConfigured();
            }
            ProjectInternal targetProject = target.getMutableModel().getDefaultProject();
            return this.doLocate(targetProject.getOwner(), modelName, param);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolingModelBuilderLookup.Builder locateBuilderForTarget(ProjectState target, String modelName, boolean param) throws UnknownModelException {
            Object object = DefaultBuildTreeModelCreator.this.treeMutableStateLock;
            synchronized (object) {
                DefaultBuildTreeModelCreator.this.buildController.getGradle().getOwner().ensureProjectsConfigured();
                target.getOwner().ensureProjectsConfigured();
            }
            return this.doLocate(target, modelName, param);
        }

        private ToolingModelBuilderLookup.Builder doLocate(ProjectState target, String modelName, boolean param) {
            target.ensureConfigured();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)target.getMutableModel().getServices().get(ToolingModelBuilderLookup.class);
            return lookup.locateForClientOperation(modelName, param, target);
        }

        @Override
        public boolean queryModelActionsRunInParallel() {
            return DefaultBuildTreeModelCreator.this.projectLeaseRegistry.getAllowsParallelExecution() && DefaultBuildTreeModelCreator.this.parallelActions;
        }

        @Override
        public void runQueryModelActions(Collection<? extends RunnableBuildOperation> actions) {
            if (this.queryModelActionsRunInParallel()) {
                DefaultBuildTreeModelCreator.this.buildOperationExecutor.runAllWithAccessToProjectState(buildOperationQueue -> {
                    for (RunnableBuildOperation action : actions) {
                        buildOperationQueue.add((BuildOperation)action);
                    }
                });
            } else {
                for (RunnableBuildOperation runnableBuildOperation : actions) {
                    try {
                        runnableBuildOperation.run(null);
                    }
                    catch (Exception e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            }
        }
    }
}

