/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupStaleOutputsExecuter
implements TaskExecuter {
    public static final String CLEAN_STALE_OUTPUTS_DISPLAY_NAME = "Clean stale outputs";
    private final Logger logger = LoggerFactory.getLogger(CleanupStaleOutputsExecuter.class);
    private final BuildOperationExecutor buildOperationExecutor;
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final TaskExecuter executer;
    private final OutputFilesRepository outputFilesRepository;
    private final BuildOutputCleanupRegistry cleanupRegistry;

    public CleanupStaleOutputsExecuter(BuildOperationExecutor buildOperationExecutor, BuildOutputCleanupRegistry cleanupRegistry, Deleter deleter, OutputChangeListener outputChangeListener, OutputFilesRepository outputFilesRepository, TaskExecuter executer) {
        this.cleanupRegistry = cleanupRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.executer = executer;
        this.outputFilesRepository = outputFilesRepository;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        if (!task.getReasonNotToTrackState().isPresent()) {
            this.cleanupStaleOutputs(context);
        }
        return this.executer.execute(task, state, context);
    }

    private void cleanupStaleOutputs(TaskExecutionContext context) {
        final HashSet<File> filesToDelete = new HashSet<File>();
        TaskProperties properties = context.getTaskProperties();
        for (FilePropertySpec outputFileSpec : properties.getOutputFileProperties()) {
            FileCollectionInternal files = outputFileSpec.getPropertyFiles();
            for (File file : files) {
                if (!this.cleanupRegistry.isOutputOwnedByBuild(file) || this.outputFilesRepository.isGeneratedByGradle(file) || !file.exists()) continue;
                filesToDelete.add(file);
            }
        }
        if (!filesToDelete.isEmpty()) {
            this.outputChangeListener.beforeOutputChange((Iterable)filesToDelete.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) throws IOException {
                    for (File file : filesToDelete) {
                        if (!file.exists()) continue;
                        CleanupStaleOutputsExecuter.this.logger.info("Deleting stale output file: {}", (Object)file.getAbsolutePath());
                        CleanupStaleOutputsExecuter.this.deleter.deleteRecursively(file);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)CleanupStaleOutputsExecuter.CLEAN_STALE_OUTPUTS_DISPLAY_NAME).progressDisplayName("Cleaning stale outputs");
                }
            });
        }
    }
}

