/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonExtensible;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.CopySpecWrapper;
import org.gradle.api.internal.file.copy.MatchingCopyAction;
import org.gradle.api.internal.file.copy.PathNotationConverter;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.file.copy.SingleParentCopySpec;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;

@NonExtensible
public class DefaultCopySpec
implements CopySpecInternal {
    private static final NotationParser<Object, String> PATH_NOTATION_PARSER = PathNotationConverter.parser();
    protected final Factory<PatternSet> patternSetFactory;
    protected final FileCollectionFactory fileCollectionFactory;
    protected final Instantiator instantiator;
    private final ConfigurableFileCollection sourcePaths;
    private Object destDir;
    private final PatternSet patternSet;
    private final List<CopySpecInternal> childSpecs = new LinkedList<CopySpecInternal>();
    private final List<CopySpecInternal> childSpecsInAdditionOrder = new LinkedList<CopySpecInternal>();
    private final List<Action<? super FileCopyDetails>> copyActions = new LinkedList<Action<? super FileCopyDetails>>();
    private boolean hasCustomActions;
    private Integer dirMode;
    private Integer fileMode;
    private Boolean caseSensitive;
    private Boolean includeEmptyDirs;
    private DuplicatesStrategy duplicatesStrategy = DuplicatesStrategy.INHERIT;
    private String filteringCharset;
    private final List<CopySpecInternal.CopySpecListener> listeners = Lists.newLinkedList();

    @Inject
    public DefaultCopySpec(FileCollectionFactory fileCollectionFactory, Instantiator instantiator, Factory<PatternSet> patternSetFactory) {
        this(fileCollectionFactory, instantiator, patternSetFactory, (PatternSet)patternSetFactory.create());
    }

    public DefaultCopySpec(FileCollectionFactory fileCollectionFactory, Instantiator instantiator, Factory<PatternSet> patternSetFactory, PatternSet patternSet) {
        this.sourcePaths = fileCollectionFactory.configurableFiles();
        this.fileCollectionFactory = fileCollectionFactory;
        this.instantiator = instantiator;
        this.patternSetFactory = patternSetFactory;
        this.patternSet = patternSet;
    }

    public DefaultCopySpec(FileCollectionFactory fileCollectionFactory, Instantiator instantiator, Factory<PatternSet> patternSetFactory, @Nullable String destPath, FileCollection source, PatternSet patternSet, Collection<? extends Action<? super FileCopyDetails>> copyActions, Collection<CopySpecInternal> children) {
        this(fileCollectionFactory, instantiator, patternSetFactory, patternSet);
        this.sourcePaths.from(new Object[]{source});
        this.destDir = destPath;
        this.copyActions.addAll(copyActions);
        for (CopySpecInternal child : children) {
            this.addChildSpec(child);
        }
    }

    @Override
    public boolean hasCustomActions() {
        if (this.hasCustomActions) {
            return true;
        }
        for (CopySpecInternal childSpec : this.childSpecs) {
            if (!childSpec.hasCustomActions()) continue;
            return true;
        }
        return false;
    }

    public List<Action<? super FileCopyDetails>> getCopyActions() {
        return this.copyActions;
    }

    public CopySpec with(CopySpec ... copySpecs) {
        for (CopySpec copySpec : copySpecs) {
            CopySpecInternal copySpecInternal;
            if (copySpec instanceof CopySpecSource) {
                CopySpecSource copySpecSource = (CopySpecSource)copySpec;
                copySpecInternal = copySpecSource.getRootSpec();
            } else {
                copySpecInternal = (CopySpecInternal)copySpec;
            }
            this.addChildSpec(copySpecInternal);
        }
        return this;
    }

    public CopySpec from(Object ... sourcePaths) {
        this.sourcePaths.from(sourcePaths);
        return this;
    }

    public CopySpec from(Object sourcePath, Closure c) {
        return this.from(sourcePath, (Action<? super CopySpec>)new ClosureBackedAction(c));
    }

    public CopySpec from(Object sourcePath, Action<? super CopySpec> configureAction) {
        Preconditions.checkNotNull(configureAction, (Object)"Gradle does not allow passing null for the configuration action for CopySpec.from().");
        CopySpecInternal child = this.addChild();
        child.from(new Object[]{sourcePath});
        CopySpecWrapper wrapper = (CopySpecWrapper)this.instantiator.newInstance(CopySpecWrapper.class, new Object[]{child});
        configureAction.execute((Object)wrapper);
        return wrapper;
    }

    @Override
    public CopySpecInternal addFirst() {
        return this.addChildAtPosition(0);
    }

    protected CopySpecInternal addChildAtPosition(int position) {
        DefaultCopySpec child = (DefaultCopySpec)this.instantiator.newInstance(SingleParentCopySpec.class, new Object[]{this.fileCollectionFactory, this.instantiator, this.patternSetFactory, this.buildRootResolver()});
        this.addChildSpec(position, child);
        return child;
    }

    @Override
    public CopySpecInternal addChild() {
        SingleParentCopySpec child = new SingleParentCopySpec(this.fileCollectionFactory, this.instantiator, this.patternSetFactory, this.buildRootResolver());
        this.addChildSpec(child);
        return child;
    }

    @Override
    public CopySpecInternal addChildBeforeSpec(CopySpecInternal childSpec) {
        int position = this.childSpecs.indexOf(childSpec);
        return position != -1 ? this.addChildAtPosition(position) : this.addChild();
    }

    protected void addChildSpec(CopySpecInternal childSpec) {
        this.addChildSpec(this.childSpecs.size(), childSpec);
    }

    protected void addChildSpec(int index, CopySpecInternal childSpec) {
        this.childSpecs.add(index, childSpec);
        int additionIndex = this.childSpecsInAdditionOrder.size();
        this.childSpecsInAdditionOrder.add(childSpec);
        childSpec.addChildSpecListener((path, spec) -> {
            DefaultCopySpecAddress childPath = new DefaultCopySpecAddress(null, this, additionIndex).append(path);
            this.fireChildSpecListeners(childPath, spec);
        });
        childSpec.visit(new DefaultCopySpecAddress(null, this, additionIndex), this::fireChildSpecListeners);
    }

    private void fireChildSpecListeners(CopySpecInternal.CopySpecAddress path, CopySpecInternal spec) {
        for (CopySpecInternal.CopySpecListener listener : this.listeners) {
            listener.childSpecAdded(path, spec);
        }
    }

    @Override
    public void visit(CopySpecInternal.CopySpecAddress parentPath, CopySpecInternal.CopySpecVisitor visitor) {
        visitor.visit(parentPath, this);
        int childIndex = 0;
        for (CopySpecInternal childSpec : this.childSpecsInAdditionOrder) {
            CopySpecInternal.CopySpecAddress childPath = parentPath.append(this, childIndex);
            childSpec.visit(childPath, visitor);
            ++childIndex;
        }
    }

    @Override
    public void addChildSpecListener(CopySpecInternal.CopySpecListener copySpecListener) {
        this.listeners.add(copySpecListener);
    }

    @VisibleForTesting
    public Set<Object> getSourcePaths() {
        return this.sourcePaths.getFrom();
    }

    @Nullable
    public String getDestPath() {
        return this.destDir == null ? null : (String)PATH_NOTATION_PARSER.parseNotation(this.destDir);
    }

    public CopySpec into(Object destDir) {
        this.destDir = destDir;
        return this;
    }

    public CopySpec into(Object destPath, Closure configureClosure) {
        return this.into(destPath, (Action<? super CopySpec>)new ClosureBackedAction(configureClosure));
    }

    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        Preconditions.checkNotNull(copySpec, (Object)"Gradle does not allow passing null for the configuration action for CopySpec.into().");
        CopySpecInternal child = this.addChild();
        child.into(destPath);
        CopySpecWrapper wrapper = (CopySpecWrapper)this.instantiator.newInstance(CopySpecWrapper.class, new Object[]{child});
        copySpec.execute((Object)wrapper);
        return wrapper;
    }

    public boolean isCaseSensitive() {
        return this.buildRootResolver().isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean getIncludeEmptyDirs() {
        return this.buildRootResolver().getIncludeEmptyDirs();
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public DuplicatesStrategy getDuplicatesStrategyForThisSpec() {
        return this.duplicatesStrategy;
    }

    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.buildRootResolver().getDuplicatesStrategy();
    }

    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
    }

    public CopySpec filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher((boolean)true, (boolean)this.isCaseSensitive(), (String)pattern);
        return this.eachFile(new MatchingCopyAction(matcher, action));
    }

    public CopySpec filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        if (!patterns.iterator().hasNext()) {
            throw new InvalidUserDataException("must provide at least one pattern to match");
        }
        PatternMatcher matcher = PatternMatcherFactory.getPatternsMatcher((boolean)true, (boolean)this.isCaseSensitive(), patterns);
        return this.eachFile(new MatchingCopyAction(matcher, action));
    }

    public CopySpec filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher((boolean)true, (boolean)this.isCaseSensitive(), (String)pattern);
        return this.eachFile(new MatchingCopyAction(matcher.negate(), action));
    }

    public CopySpec filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        if (!patterns.iterator().hasNext()) {
            throw new InvalidUserDataException("must provide at least one pattern to not match");
        }
        PatternMatcher matcher = PatternMatcherFactory.getPatternsMatcher((boolean)true, (boolean)this.isCaseSensitive(), patterns);
        return this.eachFile(new MatchingCopyAction(matcher.negate(), action));
    }

    public PatternSet getPatterns() {
        return this.patternSet;
    }

    public CopySpec include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    public CopySpec include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public CopySpec include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public CopySpec setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    public CopySpec exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public CopySpec exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public CopySpec exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public CopySpec setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }

    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.appendCopyAction(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    public CopySpec rename(Pattern sourceRegEx, String replaceWith) {
        this.appendCopyAction(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    public CopySpec filter(Class<? extends FilterReader> filterType) {
        this.appendCopyAction(new TypeBackedFilterAction(filterType));
        return this;
    }

    public CopySpec filter(Closure closure) {
        return this.filter(new ClosureBackedTransformer(closure));
    }

    public CopySpec filter(Transformer<String, String> transformer) {
        this.appendCopyAction(new TransformerBackedFilterAction(transformer));
        return this;
    }

    public CopySpec filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.appendCopyAction(new MapTypeBackedFilterAction(properties, filterType));
        return this;
    }

    public CopySpec expand(Map<String, ?> properties) {
        this.appendCopyAction(new MapBackedExpandAction(properties, (Action<? super ExpandDetails>)Actions.doNothing()));
        return this;
    }

    public CopySpec expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
        this.appendCopyAction(new MapBackedExpandAction(properties, action));
        return this;
    }

    public CopySpec rename(Closure closure) {
        return this.rename(new ClosureBackedTransformer(closure));
    }

    public CopySpec rename(Transformer<String, String> renamer) {
        this.appendCopyAction(new RenamingCopyAction(renamer));
        return this;
    }

    public Integer getDirMode() {
        return this.buildRootResolver().getDirMode();
    }

    public Integer getFileMode() {
        return this.buildRootResolver().getFileMode();
    }

    public CopyProcessingSpec setDirMode(@Nullable Integer mode) {
        this.dirMode = mode;
        return this;
    }

    public CopyProcessingSpec setFileMode(@Nullable Integer mode) {
        this.fileMode = mode;
        return this;
    }

    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.appendCopyAction(action);
        return this;
    }

    private void appendCopyAction(Action<? super FileCopyDetails> action) {
        this.hasCustomActions = true;
        this.copyActions.add(action);
    }

    @Override
    public void appendCachingSafeCopyAction(Action<? super FileCopyDetails> action) {
        this.copyActions.add(action);
    }

    public CopySpec eachFile(Closure closure) {
        this.appendCopyAction((Action<? super FileCopyDetails>)ConfigureUtil.configureUsing((Closure)closure));
        return this;
    }

    public Collection<CopySpecInternal> getChildren() {
        return this.childSpecs;
    }

    @Override
    public void walk(Action<? super CopySpecResolver> action) {
        this.buildRootResolver().walk(action);
    }

    @Override
    public CopySpecResolver buildResolverRelativeToParent(CopySpecResolver parent) {
        return new DefaultCopySpecResolver(parent);
    }

    @Override
    public CopySpecResolver buildRootResolver() {
        return new DefaultCopySpecResolver(null);
    }

    public FileCollection getSourceRootsForThisSpec() {
        return this.sourcePaths;
    }

    public String getFilteringCharset() {
        return this.buildRootResolver().getFilteringCharset();
    }

    public void setFilteringCharset(String charset) {
        Preconditions.checkNotNull((Object)charset, (Object)"filteringCharset must not be null");
        if (!Charset.isSupported(charset)) {
            throw new InvalidUserDataException(String.format("filteringCharset %s is not supported by your JVM", charset));
        }
        this.filteringCharset = charset;
    }

    private static class DefaultCopySpecAddress
    implements CopySpecInternal.CopySpecAddress {
        private final DefaultCopySpecAddress parent;
        private final CopySpecInternal spec;
        private final int additionIndex;

        public DefaultCopySpecAddress(@Nullable DefaultCopySpecAddress parent, CopySpecInternal spec, int additionIndex) {
            this.parent = parent;
            this.spec = spec;
            this.additionIndex = additionIndex;
        }

        @Override
        public CopySpecInternal.CopySpecAddress getParent() {
            return this.parent;
        }

        @Override
        public CopySpecInternal getSpec() {
            return this.spec;
        }

        @Override
        public int getAdditionIndex() {
            return this.additionIndex;
        }

        @Override
        public DefaultCopySpecAddress append(CopySpecInternal spec, int additionIndex) {
            return new DefaultCopySpecAddress(this, spec, additionIndex);
        }

        @Override
        public DefaultCopySpecAddress append(CopySpecInternal.CopySpecAddress relativeAddress) {
            CopySpecInternal.CopySpecAddress parent = relativeAddress.getParent();
            DefaultCopySpecAddress newParent = parent == null ? this : this.append(parent);
            return new DefaultCopySpecAddress(newParent, relativeAddress.getSpec(), relativeAddress.getAdditionIndex());
        }

        @Override
        public CopySpecResolver unroll(StringBuilder path) {
            CopySpecResolver resolver = this.parent != null ? this.spec.buildResolverRelativeToParent(this.parent.unroll(path)) : this.spec.buildRootResolver();
            path.append("$").append(this.additionIndex + 1);
            return resolver;
        }

        public String toString() {
            String parentPath = this.parent == null ? "" : this.parent.toString();
            return parentPath + "$" + (this.additionIndex + 1);
        }
    }

    public class DefaultCopySpecResolver
    implements CopySpecResolver {
        @Nullable
        private final CopySpecResolver parentResolver;

        private DefaultCopySpecResolver(CopySpecResolver parent) {
            this.parentResolver = parent;
        }

        @Override
        public RelativePath getDestPath() {
            RelativePath parentPath = this.parentResolver == null ? new RelativePath(false, new String[0]) : this.parentResolver.getDestPath();
            String path = DefaultCopySpec.this.getDestPath();
            if (path == null) {
                return parentPath;
            }
            if (path.startsWith("/") || path.startsWith(File.separator)) {
                return RelativePath.parse((boolean)false, (String)path);
            }
            return RelativePath.parse((boolean)false, (RelativePath)parentPath, (String)path);
        }

        @Override
        public FileTree getSource() {
            return DefaultCopySpec.this.getSourceRootsForThisSpec().getAsFileTree().matching((PatternFilterable)this.getPatternSet());
        }

        @Override
        public FileTree getAllSource() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.walk((Action<? super CopySpecResolver>)((Action)copySpecResolver -> builder.add((Object)((FileTreeInternal)Cast.uncheckedCast((Object)copySpecResolver.getSource())))));
            return DefaultCopySpec.this.fileCollectionFactory.treeOf((List)builder.build());
        }

        @Override
        public Collection<? extends Action<? super FileCopyDetails>> getAllCopyActions() {
            if (this.parentResolver == null) {
                return DefaultCopySpec.this.copyActions;
            }
            ArrayList<? extends Action<? super FileCopyDetails>> allActions = new ArrayList<Action<? super FileCopyDetails>>();
            allActions.addAll(this.parentResolver.getAllCopyActions());
            allActions.addAll(DefaultCopySpec.this.copyActions);
            return allActions;
        }

        @Override
        public List<String> getAllIncludes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllIncludes());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getIncludes());
            return result;
        }

        @Override
        public List<String> getAllExcludes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllExcludes());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getExcludes());
            return result;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllExcludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllExcludeSpecs());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getExcludeSpecs());
            return result;
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            if (DefaultCopySpec.this.duplicatesStrategy != DuplicatesStrategy.INHERIT) {
                return DefaultCopySpec.this.duplicatesStrategy;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDuplicatesStrategy();
            }
            return DuplicatesStrategy.INCLUDE;
        }

        @Override
        public boolean isDefaultDuplicateStrategy() {
            if (DefaultCopySpec.this.duplicatesStrategy != DuplicatesStrategy.INHERIT) {
                return false;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.isDefaultDuplicateStrategy();
            }
            return true;
        }

        @Override
        public boolean isCaseSensitive() {
            if (DefaultCopySpec.this.caseSensitive != null) {
                return DefaultCopySpec.this.caseSensitive;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.isCaseSensitive();
            }
            return true;
        }

        @Override
        public Integer getFileMode() {
            if (DefaultCopySpec.this.fileMode != null) {
                return DefaultCopySpec.this.fileMode;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getFileMode();
            }
            return null;
        }

        @Override
        public Integer getDirMode() {
            if (DefaultCopySpec.this.dirMode != null) {
                return DefaultCopySpec.this.dirMode;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDirMode();
            }
            return null;
        }

        @Override
        public boolean getIncludeEmptyDirs() {
            if (DefaultCopySpec.this.includeEmptyDirs != null) {
                return DefaultCopySpec.this.includeEmptyDirs;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getIncludeEmptyDirs();
            }
            return true;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllIncludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllIncludeSpecs());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getIncludeSpecs());
            return result;
        }

        public PatternSet getPatternSet() {
            PatternSet patterns = (PatternSet)DefaultCopySpec.this.patternSetFactory.create();
            assert (patterns != null);
            patterns.setCaseSensitive(this.isCaseSensitive());
            patterns.include(this.getAllIncludes());
            patterns.includeSpecs(this.getAllIncludeSpecs());
            patterns.exclude(this.getAllExcludes());
            patterns.excludeSpecs(this.getAllExcludeSpecs());
            return patterns;
        }

        @Override
        public void walk(Action<? super CopySpecResolver> action) {
            action.execute((Object)this);
            for (CopySpecInternal child : DefaultCopySpec.this.getChildren()) {
                child.buildResolverRelativeToParent(this).walk(action);
            }
        }

        @Override
        public String getFilteringCharset() {
            if (DefaultCopySpec.this.filteringCharset != null) {
                return DefaultCopySpec.this.filteringCharset;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getFilteringCharset();
            }
            return Charset.defaultCharset().name();
        }
    }

    private static class MapTypeBackedFilterAction
    implements Action<FileCopyDetails> {
        private final Map<String, ?> properties;
        private final Class<? extends FilterReader> filterType;

        public MapTypeBackedFilterAction(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            this.properties = properties;
            this.filterType = filterType;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.filter(this.properties, this.filterType);
        }
    }

    private static class TransformerBackedFilterAction
    implements Action<FileCopyDetails> {
        private final Transformer<String, String> transformer;

        public TransformerBackedFilterAction(Transformer<String, String> transformer) {
            this.transformer = transformer;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.filter(this.transformer);
        }
    }

    private static class TypeBackedFilterAction
    implements Action<FileCopyDetails> {
        private final Class<? extends FilterReader> filterType;

        public TypeBackedFilterAction(Class<? extends FilterReader> filterType) {
            this.filterType = filterType;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.filter(this.filterType);
        }
    }

    private static class MapBackedExpandAction
    implements Action<FileCopyDetails> {
        private final Map<String, ?> properties;
        private final Action<? super ExpandDetails> action;

        public MapBackedExpandAction(Map<String, ?> properties, Action<? super ExpandDetails> action) {
            this.properties = properties;
            this.action = action;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.expand(this.properties, this.action);
        }
    }
}

