/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.composite.internal.IncludedBuildDependencyMetadataBuilder;
import org.gradle.internal.Describables;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public class LocalComponentInAnotherBuildProvider
implements LocalComponentProvider {
    private final ProjectStateRegistry projectRegistry;
    private final IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Map<ProjectComponentIdentifier, CalculatedValueContainer<LocalComponentMetadata, ?>> projectMetadata = new ConcurrentHashMap();

    public LocalComponentInAnotherBuildProvider(ProjectStateRegistry projectRegistry, IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.projectRegistry = projectRegistry;
        this.dependencyMetadataBuilder = dependencyMetadataBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public LocalComponentMetadata getComponent(ProjectComponentIdentifier projectId) {
        CalculatedValueContainer valueContainer = this.projectMetadata.computeIfAbsent(projectId, projectComponentIdentifier -> {
            ProjectState projectState = this.projectRegistry.stateFor(projectId);
            return this.calculatedValueContainerFactory.create(Describables.of((Object)"metadata for", (Object)projectId), (ValueCalculator)new MetadataSupplier(projectState));
        });
        valueContainer.finalizeIfNotAlready();
        return (LocalComponentMetadata)valueContainer.get();
    }

    private class MetadataSupplier
    implements ValueCalculator<LocalComponentMetadata> {
        private final ProjectState projectState;

        public MetadataSupplier(ProjectState projectState) {
            this.projectState = projectState;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        public boolean usesMutableProjectState() {
            return true;
        }

        public ProjectInternal getOwningProject() {
            return this.projectState.getMutableModel();
        }

        public LocalComponentMetadata calculateValue(NodeExecutionContext context) {
            CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)this.projectState.getOwner();
            if (buildState instanceof IncludedBuildState) {
                ((IncludedBuildState)buildState).getConfiguredBuild();
            }
            return (LocalComponentMetadata)this.projectState.fromMutableState(p -> LocalComponentInAnotherBuildProvider.this.dependencyMetadataBuilder.build(buildState, this.projectState.getComponentIdentifier()));
        }
    }
}

