/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.ManyLambdaExpressionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ForbiddenNamedArgumentsTarget;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001:\u0001CB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000fH\u0002J\u0010\u00103\u001a\u0002012\u0006\u00104\u001a\u00020)H\u0002J\b\u00105\u001a\u000201H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u001c2\u0006\u00104\u001a\u000207H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0014\u0010:\u001a\u0002012\f\u0010;\u001a\b\u0012\u0004\u0012\u00020)0\u001eJ\u0006\u0010<\u001a\u000201J\u0014\u0010=\u001a\u0002012\f\u0010>\u001a\b\u0012\u0004\u0012\u00020)0\u001eJ\u000e\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020)J\u0010\u0010A\u001a\u0002012\u0006\u00104\u001a\u000207H\u0002J\u0010\u0010B\u001a\u00020.2\u0006\u00104\u001a\u00020)H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R-\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\"0!j\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\"`#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u0004\u0018\u00010\u001b*\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0018\u0010-\u001a\u00020.*\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010/\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor;", "", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "currentPositionedParameterIndex", "", "<set-?>", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "forbiddenNamedArgumentsTarget", "Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "getForbiddenNamedArgumentsTarget", "()Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget$delegate", "Lkotlin/Lazy;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "parameters", "", "getParameters", "result", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "varargArguments", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argumentName", "getArgumentName", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/name/Name;", "isSpread", "", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "getParameterByName", "name", "processArgumentsInParenthesis", "arguments", "processDefaultsAndRunChecks", "processExcessLambdaArguments", "excessLambdaArguments", "processExternalArgument", "externalArgument", "processNamedArgument", "processPositionArgument", "State", "resolve"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final FirFunction<?> function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<FirExpression> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> result;
    @NotNull
    private final Lazy forbiddenNamedArgumentsTarget$delegate;

    public FirCallArgumentsProcessor(@NotNull FirSession useSiteSession, @NotNull FirFunction<?> function2, @NotNull BodyResolveComponents bodyResolveComponents, @Nullable FirScope originScope) {
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.useSiteSession = useSiteSession;
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents;
        this.originScope = originScope;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
        this.forbiddenNamedArgumentsTarget$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ForbiddenNamedArgumentsTarget>(this){
            final /* synthetic */ FirCallArgumentsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ForbiddenNamedArgumentsTarget invoke() {
                return ResolveUtilsKt.getAsForbiddenNamedArgumentsTarget(FirCallArgumentsProcessor.access$getFunction$p(this.this$0), FirCallArgumentsProcessor.access$getUseSiteSession$p(this.this$0));
            }
        }));
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getResult() {
        return this.result;
    }

    @Nullable
    public final ForbiddenNamedArgumentsTarget getForbiddenNamedArgumentsTarget() {
        Lazy lazy = this.forbiddenNamedArgumentsTarget$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (ForbiddenNamedArgumentsTarget)((Object)lazy.getValue());
    }

    public final void processArgumentsInParenthesis(@NotNull List<? extends FirExpression> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        for (FirExpression firExpression2 : arguments2) {
            if (!(firExpression2 instanceof FirNamedArgumentExpression)) {
                if (!this.processPositionArgument(firExpression2)) continue;
                this.state = State.VARARG_POSITION;
                continue;
            }
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument((FirNamedArgumentExpression)firExpression2);
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final boolean processPositionArgument(FirExpression argument2) {
        boolean bl;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument2));
            return false;
        }
        FirValueParameter parameter = (FirValueParameter)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
        if (parameter == null) {
            this.addDiagnostic(new TooManyArguments(argument2, this.function));
            return false;
        }
        if (!parameter.isVararg()) {
            Object object = this;
            int n = ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex;
            ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex = n + 1;
            object = this.result;
            ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(argument2);
            boolean bl2 = false;
            object.put(parameter, simpleArgument);
            bl = false;
        } else {
            this.addVarargArgument(argument2);
            bl = true;
        }
        return bl;
    }

    private final void processNamedArgument(FirNamedArgumentExpression argument2) {
        ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget2 = this.getForbiddenNamedArgumentsTarget();
        if (forbiddenNamedArgumentsTarget2 != null) {
            ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget3 = forbiddenNamedArgumentsTarget2;
            boolean bl = false;
            boolean bl2 = false;
            ForbiddenNamedArgumentsTarget it = forbiddenNamedArgumentsTarget3;
            boolean bl3 = false;
            this.addDiagnostic(new NamedArgumentNotAllowed(argument2, this.function, it));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        Object object = this.findParameterByName(argument2);
        if (object == null) {
            return;
        }
        Object parameter = object;
        if ((object = this.result.get(parameter)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument2, (FirValueParameter)parameter, (ResolvedCallArgument)it));
            return;
        }
        object = this.result;
        ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(argument2);
        boolean bl = false;
        object.put(parameter, simpleArgument);
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex), (Object)parameter)) {
            this.state = State.POSITION_ARGUMENTS;
            object = this;
            int n = ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex;
            ((FirCallArgumentsProcessor)object).currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull FirExpression externalArgument) {
        Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
        FirValueParameter lastParameter = (FirValueParameter)CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        if (lastParameter.isVararg()) {
            this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
            return;
        }
        ResolvedCallArgument previousOccurrence = this.result.get(lastParameter);
        if (previousOccurrence != null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        Map map = this.result;
        ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(externalArgument);
        boolean bl = false;
        map.put(lastParameter, simpleArgument);
    }

    public final void processExcessLambdaArguments(@NotNull List<? extends FirExpression> excessLambdaArguments) {
        Intrinsics.checkNotNullParameter(excessLambdaArguments, (String)"excessLambdaArguments");
        Iterable $this$forEach$iv = excessLambdaArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirExpression arg = (FirExpression)element$iv;
            boolean bl = false;
            this.addDiagnostic(new ManyLambdaExpressionArguments(arg));
        }
    }

    public final void processDefaultsAndRunChecks() {
        Object object;
        Object object2 = this.result;
        boolean bl = false;
        Iterator<Object> iterator2 = object2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object3 = object2 = iterator2.next();
            boolean bl2 = false;
            FirValueParameter parameter = (FirValueParameter)object3.getKey();
            object = object2;
            boolean bl3 = false;
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)object.getValue();
            if (parameter.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                object = "Incorrect resolved argument for parameter " + parameter + " :" + resolvedArgument;
                bl3 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            if (!this.isSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument())) continue;
            this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
        }
        iterator2 = this.getParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            boolean bl4;
            ResolvedCallArgument resolvedCallArgument;
            int index2 = n++;
            FirValueParameter parameter = (FirValueParameter)iterator2.next();
            if (this.result.containsKey(parameter)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(parameter, this.function, this.originScope, index2)) {
                object = this.result;
                resolvedCallArgument = ResolvedCallArgument.DefaultArgument.INSTANCE;
                bl4 = false;
                object.put(parameter, resolvedCallArgument);
                continue;
            }
            if (parameter.isVararg()) {
                object = this.result;
                resolvedCallArgument = new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList());
                bl4 = false;
                object.put(parameter, resolvedCallArgument);
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl = this.state == State.VARARG_POSITION;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Incorrect state: ", (Object)((Object)this.state));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        FirValueParameter parameter = this.getParameters().get(this.currentPositionedParameterIndex);
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        this.result.put(parameter, new ResolvedCallArgument.VarargArgument(list2));
    }

    private final void addVarargArgument(FirExpression argument2) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        list2.add(argument2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name) {
        if (this.nameToParameter == null) {
            Map map;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable iterable = this.getParameters();
            FirCallArgumentsProcessor firCallArgumentsProcessor = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var5_6 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                Name name2 = it.getName();
                map.put(name2, element$iv$iv);
            }
            firCallArgumentsProcessor.nameToParameter = map = destination$iv$iv;
        }
        Map<Name, ? extends FirValueParameter> map = this.nameToParameter;
        Intrinsics.checkNotNull(map);
        return map.get(name);
    }

    private final FirValueParameter findParameterByName(FirNamedArgumentExpression argument2) {
        FirValueParameter parameter = this.getParameterByName(argument2.getName());
        if (parameter == null) {
            this.addDiagnostic(new NameNotFound(argument2, this.function));
        }
        return parameter;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            boolean bl = false;
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list2 = this.diagnostics;
        Intrinsics.checkNotNull(list2);
        list2.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirSpreadArgumentExpression && ((FirSpreadArgumentExpression)$this$isSpread).isSpread();
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    public static final /* synthetic */ FirFunction access$getFunction$p(FirCallArgumentsProcessor $this) {
        return $this.function;
    }

    public static final /* synthetic */ FirSession access$getUseSiteSession$p(FirCallArgumentsProcessor $this) {
        return $this.useSiteSession;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
        }
    }
}

