/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lightTree.converter.ConverterUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J=\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "", "isVar", "", "entries", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "(ZLjava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSourceElement;)V", "getEntries", "()Ljava/util/List;", "getInitializer", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "()Z", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toFirDestructingDeclaration", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "toString", "", "light-tree2fir"})
public final class DestructuringDeclaration {
    private final boolean isVar;
    @NotNull
    private final List<FirVariable<?>> entries;
    @NotNull
    private final FirExpression initializer;
    @NotNull
    private final FirSourceElement source;

    public DestructuringDeclaration(boolean isVar, @NotNull List<? extends FirVariable<?>> entries, @NotNull FirExpression initializer2, @NotNull FirSourceElement source) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.isVar = isVar;
        this.entries = entries;
        this.initializer = initializer2;
        this.source = source;
    }

    public final boolean isVar() {
        return this.isVar;
    }

    @NotNull
    public final List<FirVariable<?>> getEntries() {
        return this.entries;
    }

    @NotNull
    public final FirExpression getInitializer() {
        return this.initializer;
    }

    @NotNull
    public final FirSourceElement getSource() {
        return this.source;
    }

    @NotNull
    public final FirExpression toFirDestructingDeclaration(@NotNull FirModuleData moduleData) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        FirVariable<?> baseVariable = ConversionUtilsKt.generateTemporaryVariable(moduleData, this.source, "destruct", this.initializer);
        return ConverterUtilKt.generateDestructuringBlock(moduleData, this, baseVariable, true);
    }

    public final boolean component1() {
        return this.isVar;
    }

    @NotNull
    public final List<FirVariable<?>> component2() {
        return this.entries;
    }

    @NotNull
    public final FirExpression component3() {
        return this.initializer;
    }

    @NotNull
    public final FirSourceElement component4() {
        return this.source;
    }

    @NotNull
    public final DestructuringDeclaration copy(boolean isVar, @NotNull List<? extends FirVariable<?>> entries, @NotNull FirExpression initializer2, @NotNull FirSourceElement source) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new DestructuringDeclaration(isVar, entries, initializer2, source);
    }

    public static /* synthetic */ DestructuringDeclaration copy$default(DestructuringDeclaration destructuringDeclaration, boolean bl, List list2, FirExpression firExpression2, FirSourceElement firSourceElement, int n, Object object) {
        if ((n & 1) != 0) {
            bl = destructuringDeclaration.isVar;
        }
        if ((n & 2) != 0) {
            list2 = destructuringDeclaration.entries;
        }
        if ((n & 4) != 0) {
            firExpression2 = destructuringDeclaration.initializer;
        }
        if ((n & 8) != 0) {
            firSourceElement = destructuringDeclaration.source;
        }
        return destructuringDeclaration.copy(bl, list2, firExpression2, firSourceElement);
    }

    @NotNull
    public String toString() {
        return "DestructuringDeclaration(isVar=" + this.isVar + ", entries=" + this.entries + ", initializer=" + this.initializer + ", source=" + this.source + ')';
    }

    public int hashCode() {
        int n = this.isVar ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + ((Object)this.entries).hashCode();
        result2 = result2 * 31 + this.initializer.hashCode();
        result2 = result2 * 31 + this.source.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DestructuringDeclaration)) {
            return false;
        }
        DestructuringDeclaration destructuringDeclaration = (DestructuringDeclaration)other;
        if (this.isVar != destructuringDeclaration.isVar) {
            return false;
        }
        if (!Intrinsics.areEqual(this.entries, destructuringDeclaration.entries)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.initializer, (Object)destructuringDeclaration.initializer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.source, (Object)destructuringDeclaration.source);
    }
}

