/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.DefaultJvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.base.TestingExtension;

@Incubating
public class JvmTestSuitePlugin
implements Plugin<Project> {
    public static final String DEFAULT_TEST_SUITE_NAME = "test";

    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.test-suite-base");
        project.getPluginManager().apply("org.gradle.java-base");
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
        testSuites.registerBinding(JvmTestSuite.class, DefaultJvmTestSuite.class);
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.getConventionMapping().map("testClassesDirs", () -> ((SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().findByName(DEFAULT_TEST_SUITE_NAME)).getOutput().getClassesDirs());
            test.getConventionMapping().map("classpath", () -> ((SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().findByName(DEFAULT_TEST_SUITE_NAME)).getRuntimeClasspath());
            test.getModularity().getInferModulePath().convention((Provider)java.getModularity().getInferModulePath());
        });
        testSuites.withType(JvmTestSuite.class).all(testSuite -> testSuite.getTargets().all(target -> target.getTestTask().configure(test -> {
            test.getConventionMapping().map("testClassesDirs", () -> testSuite.getSources().getOutput().getClassesDirs());
            test.getConventionMapping().map("classpath", () -> testSuite.getSources().getRuntimeClasspath());
        })));
    }
}

