/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.RootConfigurationMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.locking.DefaultDependencyLockingState;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.LibraryBinaryDependencySpec;
import org.gradle.platform.base.ModuleDependencySpec;
import org.gradle.platform.base.ProjectDependencySpec;
import org.gradle.platform.base.internal.DefaultModuleDependencySpec;

public class DefaultLibraryLocalComponentMetadata
extends DefaultLocalComponentMetadata {
    private static final String VERSION = "<local component>";
    private static final List<ExcludeMetadata> EXCLUDE_RULES = Collections.emptyList();
    private static final String CONFIGURATION_COMPILE = "compile";

    public static DefaultLibraryLocalComponentMetadata newResolvedLibraryMetadata(LibraryBinaryIdentifier componentId, Map<String, Iterable<DependencySpec>> dependencies, String defaultProject) {
        DefaultLibraryLocalComponentMetadata metadata = DefaultLibraryLocalComponentMetadata.newDefaultLibraryLocalComponentMetadata(componentId, dependencies.keySet());
        DefaultLibraryLocalComponentMetadata.addDependenciesToMetaData(dependencies, metadata, defaultProject);
        return metadata;
    }

    private static void addDependenciesToMetaData(Map<String, Iterable<DependencySpec>> dependencies, DefaultLibraryLocalComponentMetadata metadata, String defaultProject) {
        for (Map.Entry<String, Iterable<DependencySpec>> entry : dependencies.entrySet()) {
            DefaultLibraryLocalComponentMetadata.addDependenciesToMetadata(metadata, defaultProject, entry.getValue(), entry.getKey());
        }
    }

    public static DefaultLibraryLocalComponentMetadata newResolvingLocalComponentMetadata(LibraryBinaryIdentifier componentId, String usage, Iterable<DependencySpec> dependencies) {
        DefaultLibraryLocalComponentMetadata metadata = DefaultLibraryLocalComponentMetadata.newDefaultLibraryLocalComponentMetadata(componentId, Collections.singleton(usage));
        DefaultLibraryLocalComponentMetadata.addDependenciesToMetadata(metadata, componentId.getProjectPath(), dependencies, usage);
        return metadata;
    }

    private static DefaultLibraryLocalComponentMetadata newDefaultLibraryLocalComponentMetadata(LibraryBinaryIdentifier componentId, Set<String> usages) {
        DefaultLibraryLocalComponentMetadata metaData = new DefaultLibraryLocalComponentMetadata(DefaultLibraryLocalComponentMetadata.localModuleVersionIdentifierFor(componentId), (ComponentIdentifier)componentId);
        for (String usage : usages) {
            metaData.addConfiguration(usage, String.format("Request metadata: %s", componentId.getDisplayName()), Collections.emptySet(), (ImmutableSet<String>)ImmutableSet.of((Object)usage), true, true, ImmutableAttributes.EMPTY, true, null, false, ImmutableCapabilities.EMPTY, Collections::emptyList);
        }
        return metaData;
    }

    private static void addDependenciesToMetadata(DefaultLibraryLocalComponentMetadata metadata, String defaultProject, Iterable<DependencySpec> value, String configuration) {
        metadata.addDependencies(value, defaultProject, configuration);
    }

    private static ModuleVersionIdentifier localModuleVersionIdentifierFor(LibraryBinaryIdentifier componentId) {
        return DefaultModuleVersionIdentifier.newId((String)componentId.getProjectPath(), (String)componentId.getLibraryName(), (String)VERSION);
    }

    private DefaultLibraryLocalComponentMetadata(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        super(id, componentIdentifier, "release", (AttributesSchemaInternal)EmptySchema.INSTANCE);
    }

    private void addDependencies(Iterable<DependencySpec> dependencies, String projectPath, String usageConfigurationName) {
        for (DependencySpec dependency : dependencies) {
            this.addDependency(dependency, projectPath, usageConfigurationName);
        }
    }

    private void addDependency(DependencySpec dependency, String defaultProject, String usageConfigurationName) {
        LocalOriginDependencyMetadata metadata = dependency instanceof ModuleDependencySpec ? this.moduleDependencyMetadata((ModuleDependencySpec)dependency, usageConfigurationName) : (dependency instanceof ProjectDependencySpec ? this.projectDependencyMetadata((ProjectDependencySpec)dependency, defaultProject, usageConfigurationName) : this.binaryDependencyMetadata((LibraryBinaryDependencySpec)dependency, usageConfigurationName));
        this.getConfiguration(usageConfigurationName).addDependency(metadata);
    }

    private LocalOriginDependencyMetadata moduleDependencyMetadata(ModuleDependencySpec moduleDependency, String usageConfigurationName) {
        ModuleComponentSelector selector = this.moduleComponentSelectorFrom(moduleDependency);
        return this.dependencyMetadataFor((ComponentSelector)selector, usageConfigurationName, CONFIGURATION_COMPILE);
    }

    private LocalOriginDependencyMetadata projectDependencyMetadata(ProjectDependencySpec projectDependency, String defaultProject, String usageConfigurationName) {
        String projectPath = projectDependency.getProjectPath();
        if (Strings.isNullOrEmpty((String)projectPath)) {
            projectPath = defaultProject;
        }
        String libraryName = projectDependency.getLibraryName();
        DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName);
        return this.dependencyMetadataFor((ComponentSelector)selector, usageConfigurationName, usageConfigurationName);
    }

    private LocalOriginDependencyMetadata binaryDependencyMetadata(LibraryBinaryDependencySpec binarySpec, String usageConfigurationName) {
        String projectPath = binarySpec.getProjectPath();
        String libraryName = binarySpec.getLibraryName();
        DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName, binarySpec.getVariant());
        return this.dependencyMetadataFor((ComponentSelector)selector, usageConfigurationName, usageConfigurationName);
    }

    private ModuleComponentSelector moduleComponentSelectorFrom(ModuleDependencySpec module) {
        return DefaultModuleComponentSelector.newSelector((ModuleIdentifier)DefaultModuleIdentifier.newId((String)module.getGroup(), (String)module.getName()), (String)DefaultModuleDependencySpec.effectiveVersionFor(module.getVersion()));
    }

    private LocalOriginDependencyMetadata dependencyMetadataFor(ComponentSelector selector, String usageConfigurationName, String mappedUsageConfiguration) {
        return new LocalComponentDependencyMetadata(() -> "TODO", selector, usageConfigurationName, null, (AttributeContainer)ImmutableAttributes.EMPTY, mappedUsageConfiguration, (List)ImmutableList.of(), EXCLUDE_RULES, false, false, true, false, false, null);
    }

    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, ImmutableSet<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, Supplier<List<DependencyConstraint>> consistentResolutionConstraints) {
        assert (hierarchy.contains((Object)name));
        LibraryLocalConfigurationMetadata conf = new LibraryLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities);
        this.addToConfigurations(name, conf);
        return conf;
    }

    class LibraryLocalConfigurationMetadata
    extends DefaultLocalComponentMetadata.DefaultLocalConfigurationMetadata
    implements RootConfigurationMetadata {
        LibraryLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities) {
            super((DefaultLocalComponentMetadata)DefaultLibraryLocalComponentMetadata.this, name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities);
        }

        public DependencyLockingState getDependencyLockingState() {
            return DefaultDependencyLockingState.EMPTY_LOCK_CONSTRAINT;
        }
    }
}

