/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a<\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0018\u0010!\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0018\u0010\"\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a-\u0010#\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010%H\u0082\b\u001a\u001e\u0010&\u001a\u00020\u0001*\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u001e\u0010'\u001a\u00020\u0001*\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\f\u0010(\u001a\u00020\u0001*\u00020\u001cH\u0000\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u001c\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006)"}, d2={"canHaveOpenMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getHasAccessorImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "isEnumEntryInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isExtensionMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;)Z", "isLocalMember", "checkExpectDeclarationVisibilityAndBody", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkPropertyInitializer", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "property", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "isInitialized", "isInsideExpectClass", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyExpect", "isEffectivelyExternal", "isInlineOrValueClass", "checkers"})
public final class FirDeclarationCheckerUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirRegularClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirRegularClass klass = containingClass;
        boolean bl2 = false;
        FirMemberDeclaration $this$isExpect$iv = klass;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl3 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirRegularClass)it$iv;
                bl2 = false;
                $this$isExpect$iv = klass;
                $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirRegularClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirRegularClass klass = containingClass;
        boolean bl2 = false;
        FirMemberDeclaration $this$isExternal$iv = klass;
        boolean $i$f$isExternal = false;
        if ($this$isExternal$iv.getStatus().isExternal()) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl3 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirRegularClass)it$iv;
                bl2 = false;
                $this$isExternal$iv = klass;
                $i$f$isExternal = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirRegularClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExpect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && FirDeclarationCheckerUtilsKt.isInsideExpectClass(containingClass, context2);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirRegularClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
        boolean $i$f$isExternal = false;
        if ($this$isExternal$iv.getStatus().isExternal()) {
            return true;
        }
        return containingClass != null && FirDeclarationCheckerUtilsKt.isInsideExternalClass(containingClass, context2);
    }

    public static final void checkExpectDeclarationVisibilityAndBody(@NotNull FirMemberDeclaration declaration2, @NotNull FirSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            FirMemberDeclaration $this$visibility$iv = declaration2;
            boolean $i$f$getVisibility = false;
            if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), context2);
            }
            if (declaration2 instanceof FirSimpleFunction) {
                FirFunction $this$hasBody$iv = (FirFunction)((Object)declaration2);
                boolean $i$f$getHasBody = false;
                if ($this$hasBody$iv.getBody() != null) {
                    DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), context2);
                }
            }
        }
    }

    public static final void checkPropertyInitializer(@Nullable FirRegularClass containingClass, @NotNull FirProperty property2, @Nullable FirModifierList modifierList2, boolean isInitialized, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        boolean bl;
        Object object;
        FirSourceElement $i$f$isAbstract22;
        boolean isAbstract;
        Object $this$isInterface$iv;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirRegularClass firRegularClass = containingClass;
        if (firRegularClass == null) {
            bl2 = null;
        } else {
            $this$isInterface$iv = firRegularClass;
            boolean $i$f$isInterface = false;
            bl2 = ((FirRegularClass)$this$isInterface$iv).getClassKind() == ClassKind.INTERFACE;
        }
        boolean inInterface = Intrinsics.areEqual(bl2, (Object)true);
        $this$isInterface$iv = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isInterface$iv, (String)"ABSTRACT_KEYWORD");
        boolean hasAbstractModifier = FirModifierUtilsKt.contains(modifierList2, (KtModifierKeywordToken)$this$isInterface$iv);
        Object $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract22 = false;
        boolean bl3 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT || hasAbstractModifier;
        if (isAbstract) {
            if (property2.getInitializer() == null && property2.getDelegate() == null && property2.getReturnTypeRef() instanceof FirImplicitTypeRef && ($this$isAbstract$iv = property2.getSource()) != null) {
                Object $i$f$isAbstract22 = $this$isAbstract$iv;
                boolean bl4 = false;
                boolean bl5 = false;
                Object it = $i$f$isAbstract22;
                boolean bl6 = false;
                DiagnosticReporterKt.reportOn(reporter, (FirSourceElement)it, FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), context2);
            }
            return;
        }
        boolean backingFieldRequired = FirDeclarationUtilKt.getHasBackingField(property2);
        if (inInterface && backingFieldRequired && FirDeclarationCheckerUtilsKt.getHasAccessorImplementation(property2) && ($i$f$isAbstract22 = property2.getSource()) != null) {
            object = $i$f$isAbstract22;
            boolean bl7 = false;
            boolean it = false;
            Object it2 = object;
            boolean bl8 = false;
            DiagnosticReporterKt.reportOn(reporter, (FirSourceElement)it2, FirErrors.INSTANCE.getBACKING_FIELD_IN_INTERFACE(), context2);
        }
        boolean isExpect = FirDeclarationCheckerUtilsKt.isEffectivelyExpect(property2, containingClass, context2);
        if (property2.getInitializer() != null) {
            FirSourceElement firSourceElement;
            object = property2.getInitializer();
            if (object != null && (firSourceElement = ((FirExpression)object).getSource()) != null) {
                FirSourceElement it = firSourceElement;
                boolean it2 = false;
                bl = false;
                FirSourceElement it3 = it;
                boolean bl9 = false;
                if (inInterface) {
                    DiagnosticReporterKt.reportOn(reporter, it3, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_IN_INTERFACE(), context2);
                } else if (isExpect) {
                    DiagnosticReporterKt.reportOn(reporter, it3, FirErrors.INSTANCE.getEXPECTED_PROPERTY_INITIALIZER(), context2);
                } else if (!backingFieldRequired) {
                    DiagnosticReporterKt.reportOn(reporter, it3, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_NO_BACKING_FIELD(), context2);
                } else if (property2.getReceiverTypeRef() != null) {
                    DiagnosticReporterKt.reportOn(reporter, it3, FirErrors.INSTANCE.getEXTENSION_PROPERTY_WITH_BACKING_FIELD(), context2);
                }
            }
        } else if (property2.getDelegate() != null) {
            FirSourceElement firSourceElement;
            object = property2.getDelegate();
            if (object != null && (firSourceElement = ((FirExpression)object).getSource()) != null) {
                FirSourceElement it = firSourceElement;
                boolean it2 = false;
                bl = false;
                FirSourceElement it4 = it;
                boolean bl10 = false;
                if (inInterface) {
                    DiagnosticReporterKt.reportOn(reporter, it4, FirErrors.INSTANCE.getDELEGATED_PROPERTY_IN_INTERFACE(), context2);
                } else if (isExpect) {
                    DiagnosticReporterKt.reportOn(reporter, it4, FirErrors.INSTANCE.getEXPECTED_DELEGATED_PROPERTY(), context2);
                }
            }
        } else {
            FirSourceElement firSourceElement = property2.getSource();
            if (firSourceElement == null) {
                return;
            }
            FirSourceElement propertySource = firSourceElement;
            boolean isExternal = FirDeclarationCheckerUtilsKt.isEffectivelyExternal(property2, containingClass, context2);
            if (backingFieldRequired && !inInterface) {
                FirMemberDeclaration $this$isLateInit$iv = property2;
                boolean $i$f$isLateInit = false;
                if (!($this$isLateInit$iv.getStatus().isLateInit() || isExpect || isInitialized || isExternal)) {
                    if (property2.getReceiverTypeRef() != null && !FirDeclarationCheckerUtilsKt.getHasAccessorImplementation(property2)) {
                        DiagnosticReporterKt.reportOn(reporter, propertySource, FirErrors.INSTANCE.getEXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT(), context2);
                    } else if (containingClass == null || FirDeclarationCheckerUtilsKt.getHasAccessorImplementation(property2)) {
                        DiagnosticReporterKt.reportOn(reporter, propertySource, FirErrors.INSTANCE.getMUST_BE_INITIALIZED(), context2);
                    } else {
                        DiagnosticReporterKt.reportOn(reporter, propertySource, FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT(), context2);
                    }
                }
            }
            FirMemberDeclaration $this$isLateInit$iv = property2;
            boolean $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                if (isExpect) {
                    DiagnosticReporterKt.reportOn(reporter, propertySource, FirErrors.INSTANCE.getEXPECTED_LATEINIT_PROPERTY(), context2);
                }
                if (backingFieldRequired && !inInterface && isInitialized) {
                    DiagnosticReporterKt.reportOn(reporter, propertySource, FirErrors.INSTANCE.getUNNECESSARY_LATEINIT(), context2);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasAccessorImplementation(FirProperty $this$hasAccessorImplementation) {
        Boolean bl;
        boolean $i$f$getHasBody;
        FirPropertyAccessor $this$hasBody$iv;
        FirPropertyAccessor firPropertyAccessor;
        if (!($this$hasAccessorImplementation.getGetter() instanceof FirDefaultPropertyAccessor)) {
            Boolean bl2;
            firPropertyAccessor = $this$hasAccessorImplementation.getGetter();
            if (firPropertyAccessor == null) {
                bl2 = null;
            } else {
                $this$hasBody$iv = firPropertyAccessor;
                $i$f$getHasBody = false;
                bl2 = $this$hasBody$iv.getBody() != null;
            }
            if (Intrinsics.areEqual(bl2, (Object)true)) return true;
        }
        if ($this$hasAccessorImplementation.getSetter() instanceof FirDefaultPropertyAccessor) return false;
        firPropertyAccessor = $this$hasAccessorImplementation.getSetter();
        if (firPropertyAccessor == null) {
            bl = null;
        } else {
            $this$hasBody$iv = firPropertyAccessor;
            $i$f$getHasBody = false;
            bl = $this$hasBody$iv.getBody() != null;
        }
        if (!Intrinsics.areEqual(bl, (Object)true)) return false;
        return true;
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass<?> $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter($this$canHaveOpenMembers, (String)"<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOrValueClass(@NotNull FirRegularClass $this$isInlineOrValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOrValueClass, (String)"<this>");
        if ($this$isInlineOrValueClass.getClassKind() != ClassKind.CLASS) {
            return false;
        }
        FirRegularClass $this$isInline$iv = $this$isInlineOrValueClass;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv.getStatus().isInline()) return true;
        FirElement firElement = $this$isInlineOrValueClass;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.VALUE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"VALUE_KEYWORD");
        if (!FirModifierUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) return false;
        return true;
    }

    public static final boolean isEnumEntryInitializer(@NotNull FirDeclaration $this$isEnumEntryInitializer) {
        FirClassSymbol<?> firClassSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$isEnumEntryInitializer, (String)"<this>");
        if (!($this$isEnumEntryInitializer instanceof FirConstructor) || !((FirConstructor)$this$isEnumEntryInitializer).isPrimary()) {
            return false;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassAttr((FirCallableDeclaration)$this$isEnumEntryInitializer);
        Object object = coneClassLikeLookupTag instanceof ConeClassLookupTagWithFixedSymbol ? (ConeClassLookupTagWithFixedSymbol)coneClassLikeLookupTag : null;
        FirClassSymbol<?> firClassSymbol2 = firClassSymbol = object == null ? null : ((ConeClassLookupTagWithFixedSymbol)object).getSymbol();
        return (firClassSymbol == null ? null : ((object = (FirClass)firClassSymbol.getFir()) == null ? null : object.getClassKind())) == ClassKind.ENUM_ENTRY;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocalMember, (String)"<this>");
        FirDeclaration firDeclaration = $this$isLocalMember;
        if (firDeclaration instanceof FirProperty) {
            bl = ((FirProperty)$this$isLocalMember).isLocal();
        } else if (firDeclaration instanceof FirRegularClass) {
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getSymbol().getClassId().isLocal();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableMemberDeclaration<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, (String)"<this>");
        return $this$isExtensionMember.getReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }
}

