/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.FileDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromKlib;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.ModuleDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.Actual;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"H\u0016J\u0011\u0010+\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\"H\u0096\u0002J(\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u000bH\u0002J\u0018\u00103\u001a\u0002042\u0006\u0010*\u001a\u00020\"2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020\u0001H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\"H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\"H\u0016J\f\u0010?\u001a\u00020)*\u00020@H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "containsErrorCode", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;Z)V", "fileToDeserializerMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/List;", "moduleDependencies$delegate", "Lkotlin/Lazy;", "moduleDeserializationState", "Lorg/jetbrains/kotlin/backend/common/serialization/ModuleDeserializationState;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleReversedFileIndex", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "getModuleReversedFileIndex$ir_serialization_common", "()Ljava/util/Map;", "getStrategy", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "addModuleReachableTopLevel", "", "idSig", "contains", "deserializeIrFile", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "fileIndex", "", "moduleDeserializer", "allowErrorNodes", "deserializeIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "init", "delegate", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "deserializeExpectActualMapping", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "ir.serialization.common"})
public abstract class BasicIrModuleDeserializer
extends IrModuleDeserializer {
    @NotNull
    private final KotlinIrLinker linker;
    @NotNull
    private final IrLibrary klib;
    @NotNull
    private final DeserializationStrategy strategy;
    private final boolean containsErrorCode;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrFileDeserializer> fileToDeserializerMap;
    @NotNull
    private final ModuleDeserializationState moduleDeserializationState;
    @NotNull
    private final Map<IdSignature, FileDeserializationState> moduleReversedFileIndex;
    @NotNull
    private final Lazy moduleDependencies$delegate;
    @NotNull
    private final IrModuleFragment moduleFragment;

    public BasicIrModuleDeserializer(@NotNull KotlinIrLinker linker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, @NotNull DeserializationStrategy strategy, boolean containsErrorCode) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        super(moduleDescriptor);
        this.linker = linker;
        this.klib = klib;
        this.strategy = strategy;
        this.containsErrorCode = containsErrorCode;
        boolean bl = false;
        this.fileToDeserializerMap = new LinkedHashMap();
        this.moduleDeserializationState = new ModuleDeserializationState(this.linker, this);
        bl = false;
        this.moduleReversedFileIndex = new LinkedHashMap();
        this.moduleDependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends IrModuleDeserializer>>(moduleDescriptor, this){
            final /* synthetic */ ModuleDescriptor $moduleDescriptor;
            final /* synthetic */ BasicIrModuleDeserializer this$0;
            {
                this.$moduleDescriptor = $moduleDescriptor;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<IrModuleDeserializer> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ModuleDescriptor it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = this.$moduleDescriptor.getAllDependencyModules();
                Object object = this.$moduleDescriptor;
                boolean $i$f$filter = false;
                void var4_4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ModuleDescriptor)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)object))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                object = this.this$0;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ModuleDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrModuleDeserializer irModuleDeserializer = ((BasicIrModuleDeserializer)object).getLinker().resolveModuleDeserializer(it, null);
                    collection.add(irModuleDeserializer);
                }
                return (List)destination$iv$iv;
            }
        }));
        this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor, this.linker.getBuiltIns(), CollectionsKt.emptyList());
    }

    public /* synthetic */ BasicIrModuleDeserializer(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, IrLibrary irLibrary, DeserializationStrategy deserializationStrategy, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(kotlinIrLinker, moduleDescriptor, irLibrary, deserializationStrategy, bl);
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.klib;
    }

    @Override
    @NotNull
    public DeserializationStrategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final Map<IdSignature, FileDeserializationState> getModuleReversedFileIndex$ir_serialization_common() {
        return this.moduleReversedFileIndex;
    }

    @NotNull
    public List<IrModuleDeserializer> getModuleDependencies() {
        Lazy lazy = this.moduleDependencies$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Override
    public void init(@NotNull IrModuleDeserializer delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        int fileCount = this.getKlib().fileCount();
        ArrayList<org.jetbrains.kotlin.ir.declarations.IrFile> files2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrFile>(fileCount);
        int n = 0;
        if (n < fileCount) {
            do {
                int i = n++;
                CodedInputStream fileStream = BasicIrModuleDeserializerKt.getCodedInputStream(this.getKlib().file(i));
                IrFile fileProto = IrFile.parseFrom(fileStream, ExtensionRegistryLite.newInstance());
                Intrinsics.checkNotNullExpressionValue((Object)fileProto, (String)"fileProto");
                files2.add(this.deserializeIrFile(fileProto, i, delegate2, this.containsErrorCode));
            } while (n < fileCount);
        }
        this.getModuleFragment().getFiles().addAll((Collection<org.jetbrains.kotlin.ir.declarations.IrFile>)files2);
        Iterable $this$forEach$iv = this.fileToDeserializerMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFileDeserializer it = (IrFileDeserializer)element$iv;
            boolean bl = false;
            this.deserializeExpectActualMapping(it.getSymbolDeserializer());
        }
    }

    private final void deserializeExpectActualMapping(IrSymbolDeserializer $this$deserializeExpectActualMapping) {
        Iterable $this$forEach$iv = $this$deserializeExpectActualMapping.getActuals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Actual it = (Actual)element$iv;
            boolean bl = false;
            long expectSymbol = $this$deserializeExpectActualMapping.parseSymbolData-9x8F8T0(it.getExpectSymbol());
            long actualSymbol = $this$deserializeExpectActualMapping.parseSymbolData-9x8F8T0(it.getActualSymbol());
            IdSignature expect = $this$deserializeExpectActualMapping.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(expectSymbol));
            IdSignature actual = $this$deserializeExpectActualMapping.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(actualSymbol));
            boolean bl2 = this.getLinker().getExpectUniqIdToActualUniqId$ir_serialization_common().get(expect) == null;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = "Expect signature " + expect + " is already actualized by " + this.getLinker().getExpectUniqIdToActualUniqId$ir_serialization_common().get(expect) + ", while we try to record " + actual;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            Object object = this.getLinker().getExpectUniqIdToActualUniqId$ir_serialization_common();
            bl3 = false;
            object.put((IdSignature)expect, (IdSignature)actual);
            object = BasicIrModuleDeserializerKt.findModuleDeserializerForTopLevelId(this, actual);
            if (object == null) continue;
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Object md = object2;
            boolean bl7 = false;
            Map<IdSignature, IrModuleDeserializer> map = this.getLinker().getTopLevelActualUniqItToDeserializer$ir_serialization_common();
            boolean bl8 = false;
            map.put(actual, (IrModuleDeserializer)md);
        }
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IdSignature idSignature) {
        IrSymbolDeserializer irSymbolDeserializer;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        Object object = this.fileToDeserializerMap.get(file2);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = object == null ? null : (irSimpleFunctionSymbol = (irSymbolDeserializer = ((IrFileDeserializer)object).getSymbolDeserializer()) == null ? null : irSymbolDeserializer.referenceSimpleFunctionByLocalSignature(idSignature));
        if (irSimpleFunctionSymbol == null) {
            object = "No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return irSimpleFunctionSymbol;
    }

    @Override
    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IdSignature idSignature) {
        IrSymbolDeserializer irSymbolDeserializer;
        IrPropertySymbol irPropertySymbol;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        Object object = this.fileToDeserializerMap.get(file2);
        IrPropertySymbol irPropertySymbol2 = object == null ? null : (irPropertySymbol = (irSymbolDeserializer = ((IrFileDeserializer)object).getSymbolDeserializer()) == null ? null : irSymbolDeserializer.referencePropertyByLocalSignature(idSignature));
        if (irPropertySymbol == null) {
            object = "No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return irPropertySymbol;
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Map<IdSignature, FileDeserializationState> map = this.moduleReversedFileIndex;
        boolean bl = false;
        Map<IdSignature, FileDeserializationState> map2 = map;
        boolean bl2 = false;
        return map2.containsKey(idSig);
    }

    @Override
    @NotNull
    public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
        boolean bl = idSig.isPublic();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        IdSignature topLevelSignature = idSig.topLevelSignature();
        Object object = this.moduleReversedFileIndex.get(topLevelSignature);
        if (object == null) {
            String string3 = "No file for " + topLevelSignature + " (@ " + idSig + ") in module " + this.getModuleDescriptor();
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        FileDeserializationState fileLocalDeserializationState = object;
        fileLocalDeserializationState.addIdSignature(topLevelSignature);
        this.moduleDeserializationState.enqueueFile(fileLocalDeserializationState);
        object = fileLocalDeserializationState.getFileDeserializer().getSymbolDeserializer().deserializeIrSymbol(idSig, symbolKind);
        boolean bl6 = false;
        boolean bl7 = false;
        Object it = object;
        boolean bl8 = false;
        this.getLinker().getDeserializedSymbols$ir_serialization_common().add((IrSymbol)it);
        return object;
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.moduleFragment;
    }

    private final org.jetbrains.kotlin.ir.declarations.IrFile deserializeIrFile(IrFile fileProto, int fileIndex, IrModuleDeserializer moduleDeserializer, boolean allowErrorNodes) {
        IrLibraryFileFromKlib fileReader = new IrLibraryFileFromKlib(moduleDeserializer.getKlib(), fileIndex);
        org.jetbrains.kotlin.ir.declarations.IrFile file2 = IrFileDeserializerKt.createFile(fileReader, this.getModuleFragment(), fileProto);
        FileDeserializationState fileDeserializationState2 = new FileDeserializationState(this.linker, file2, fileReader, fileProto, this.getStrategy().getNeedBodies(), allowErrorNodes, this.getStrategy().getInlineBodies(), moduleDeserializer, (Function3<? super IdSignature, ? super ModuleDescriptor, ? super Collection<? extends IrModuleDeserializer>, ? extends IrModuleDeserializer>)((Function3)new Function3<IdSignature, ModuleDescriptor, Collection<? extends IrModuleDeserializer>, IrModuleDeserializer>(this.linker){

            @NotNull
            public final IrModuleDeserializer invoke(@NotNull IdSignature p0, @NotNull ModuleDescriptor p1, @NotNull Collection<? extends IrModuleDeserializer> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                return ((KotlinIrLinker)this.receiver).handleNoModuleDeserializerFound(p0, p1, p2);
            }

            @NotNull
            public final String getSignature() {
                return "handleNoModuleDeserializerFound(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/Collection;)Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;";
            }

            @NotNull
            public final String getName() {
                return "handleNoModuleDeserializerFound";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinIrLinker.class);
            }
        }));
        Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrFileDeserializer> map = this.fileToDeserializerMap;
        IrFileDeserializer irFileDeserializer = fileDeserializationState2.getFileDeserializer();
        boolean bl = false;
        map.put(file2, irFileDeserializer);
        Set<IdSignature> topLevelDeclarations = fileDeserializationState2.getFileDeserializer().getReversedSignatureIndex().keySet();
        Iterable $this$forEach$iv = topLevelDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdSignature it = (IdSignature)element$iv;
            boolean bl2 = false;
            this.getModuleReversedFileIndex$ir_serialization_common().putIfAbsent(it, fileDeserializationState2);
        }
        if (this.getStrategy().getTheWholeWorld()) {
            fileDeserializationState2.enqueueAllDeclarations();
        }
        if (this.getStrategy().getTheWholeWorld() || this.getStrategy().getExplicitlyExported()) {
            this.moduleDeserializationState.enqueueFile(fileDeserializationState2);
        }
        return file2;
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        this.moduleDeserializationState.addIdSignature(idSig);
    }
}

