/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.language.ComponentDependencies;

public class DefaultComponentDependencies
implements ComponentDependencies {
    private final Configuration implementation;

    @Inject
    public DefaultComponentDependencies(ConfigurationContainer configurations, String implementationName) {
        this.implementation = (Configuration)configurations.create(implementationName);
        this.implementation.setCanBeConsumed(false);
        this.implementation.setCanBeResolved(false);
    }

    public Configuration getImplementationDependencies() {
        return this.implementation;
    }

    @Inject
    protected DependencyHandler getDependencyHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void implementation(Object notation) {
        this.implementation.getDependencies().add((Object)this.getDependencyHandler().create(notation));
    }

    @Override
    public void implementation(Object notation, Action<? super ExternalModuleDependency> action) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getDependencyHandler().create(notation);
        action.execute((Object)dependency);
        this.implementation.getDependencies().add((Object)dependency);
    }
}

