/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.internal.tasks.testing.DefaultNestedTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnitPlatformTestExecutionListener
implements TestExecutionListener {
    private final ConcurrentMap<String, TestDescriptorInternal> descriptorsByUniqueId = new ConcurrentHashMap<String, TestDescriptorInternal>();
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final IdGenerator<?> idGenerator;
    private TestPlan currentTestPlan;

    public JUnitPlatformTestExecutionListener(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.currentTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.currentTestPlan = null;
        this.descriptorsByUniqueId.clear();
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionSkipped(testIdentifier);
    }

    private void executionSkipped(TestIdentifier testIdentifier) {
        this.executionStarted(testIdentifier);
        this.reportSkipped(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.getParentId().isPresent()) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            this.reportSkipped(testIdentifier);
            return;
        }
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
            Throwable failure = testExecutionResult.getThrowable().orElseGet(() -> new AssertionError((Object)"test failed but did not report an exception"));
            if (testIdentifier.isTest()) {
                this.resultProcessor.failure(this.getId(testIdentifier), failure);
            } else {
                TestDescriptorInternal syntheticTestDescriptor = this.createSyntheticTestDescriptorForContainer(testIdentifier);
                this.resultProcessor.started(syntheticTestDescriptor, this.startEvent(this.getId(testIdentifier)));
                this.resultProcessor.failure(syntheticTestDescriptor.getId(), failure);
                this.resultProcessor.completed(syntheticTestDescriptor.getId(), this.completeEvent());
            }
        }
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private void reportStartedUnlessAlreadyStarted(TestIdentifier testIdentifier) {
        boolean wasNotAlreadyStarted = this.createDescriptorIfAbsent(testIdentifier);
        if (wasNotAlreadyStarted) {
            TestDescriptorInternal descriptor = (TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId());
            this.resultProcessor.started(descriptor, this.startEvent(testIdentifier));
        }
    }

    private void reportSkipped(TestIdentifier testIdentifier) {
        this.currentTestPlan.getChildren(testIdentifier).stream().filter(child -> !this.wasStarted((TestIdentifier)child)).forEach(this::executionSkipped);
        if (testIdentifier.isTest()) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent(TestResult.ResultType.SKIPPED));
        } else if (JUnitPlatformTestExecutionListener.hasClassSource(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private TestStartEvent startEvent(TestIdentifier testIdentifier) {
        Object idOfClosestStartedAncestor = this.getAncestors(testIdentifier).stream().map(TestIdentifier::getUniqueId).filter(this.descriptorsByUniqueId::containsKey).findFirst().map(this.descriptorsByUniqueId::get).map(TestDescriptorInternal::getId).orElse(null);
        return this.startEvent((Object)idOfClosestStartedAncestor);
    }

    private TestStartEvent startEvent(Object parentId) {
        return new TestStartEvent(this.clock.getCurrentTime(), parentId);
    }

    private TestCompleteEvent completeEvent() {
        return this.completeEvent(null);
    }

    private TestCompleteEvent completeEvent(TestResult.ResultType resultType) {
        return new TestCompleteEvent(this.clock.getCurrentTime(), resultType);
    }

    private boolean wasStarted(TestIdentifier testIdentifier) {
        return this.descriptorsByUniqueId.containsKey(testIdentifier.getUniqueId());
    }

    private boolean createDescriptorIfAbsent(TestIdentifier node) {
        MutableBoolean wasCreated = new MutableBoolean(false);
        this.descriptorsByUniqueId.computeIfAbsent(node.getUniqueId(), uniqueId -> {
            wasCreated.set(true);
            boolean isTestClassId = this.isTestClassIdentifier(node);
            if (node.getType().isContainer() || isTestClassId) {
                Object candidateId;
                if (isTestClassId) {
                    return this.createTestClassDescriptor(node);
                }
                String displayName = node.getDisplayName();
                Optional<TestDescriptorInternal> parentId = node.getParentId().map(this.descriptorsByUniqueId::get);
                if (parentId.isPresent() && (candidateId = parentId.get().getId()) instanceof CompositeIdGenerator.CompositeId) {
                    return this.createNestedTestSuite(node, displayName, (CompositeIdGenerator.CompositeId)candidateId);
                }
            }
            return this.createTestDescriptor(node, node.getLegacyReportingName(), node.getDisplayName());
        });
        return wasCreated.get();
    }

    private DefaultNestedTestSuiteDescriptor createNestedTestSuite(TestIdentifier node, String displayName, CompositeIdGenerator.CompositeId candidateId) {
        return new DefaultNestedTestSuiteDescriptor(this.idGenerator.generateId(), node.getLegacyReportingName(), displayName, candidateId);
    }

    private DefaultTestClassDescriptor createTestClassDescriptor(TestIdentifier node) {
        TestIdentifier classIdentifier = this.findTestClassIdentifier(node);
        String className = this.className(classIdentifier);
        String classDisplayName = node.getDisplayName();
        return new DefaultTestClassDescriptor(this.idGenerator.generateId(), className, classDisplayName);
    }

    private TestDescriptorInternal createSyntheticTestDescriptorForContainer(TestIdentifier node) {
        boolean testsStarted = this.currentTestPlan.getDescendants(node).stream().anyMatch(this::wasStarted);
        String name = testsStarted ? "executionError" : "initializationError";
        return this.createTestDescriptor(node, name, name);
    }

    private TestDescriptorInternal createTestDescriptor(TestIdentifier test, String name, String displayName) {
        TestIdentifier classIdentifier = this.findTestClassIdentifier(test);
        String className = this.className(classIdentifier);
        String classDisplayName = this.classDisplayName(classIdentifier);
        return new DefaultTestDescriptor(this.idGenerator.generateId(), className, name, classDisplayName, displayName);
    }

    private Object getId(TestIdentifier testIdentifier) {
        return ((TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId())).getId();
    }

    private Set<TestIdentifier> getAncestors(TestIdentifier testIdentifier) {
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>();
        Optional parentId = testIdentifier.getParentId();
        while (parentId.isPresent()) {
            TestIdentifier parent = this.currentTestPlan.getTestIdentifier((String)parentId.get());
            result.add(parent);
            parentId = parent.getParentId();
        }
        return result;
    }

    private TestIdentifier findTestClassIdentifier(TestIdentifier testIdentifier) {
        TestIdentifier current = testIdentifier;
        while (current != null) {
            if (this.isTestClassIdentifier(current)) {
                return current;
            }
            current = current.getParentId().map(arg_0 -> ((TestPlan)this.currentTestPlan).getTestIdentifier(arg_0)).orElse(null);
        }
        return null;
    }

    private boolean isTestClassIdentifier(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.hasClassSource(testIdentifier) && this.hasDifferentSourceThanAncestor(testIdentifier);
    }

    private String className(TestIdentifier testClassIdentifier) {
        Optional<ClassSource> classSource;
        if (testClassIdentifier != null && (classSource = JUnitPlatformTestExecutionListener.getClassSource(testClassIdentifier)).isPresent()) {
            return classSource.get().getClassName();
        }
        return "UnknownClass";
    }

    private String classDisplayName(TestIdentifier testClassIdentifier) {
        if (testClassIdentifier != null) {
            return testClassIdentifier.getDisplayName();
        }
        return "UnknownClass";
    }

    private static boolean hasClassSource(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.getClassSource(testIdentifier).isPresent();
    }

    private static Optional<ClassSource> getClassSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof ClassSource).map(source -> (ClassSource)source);
    }

    private boolean hasDifferentSourceThanAncestor(TestIdentifier testIdentifier) {
        Optional parent = this.currentTestPlan.getParent(testIdentifier);
        while (parent.isPresent()) {
            if (Objects.equals(((TestIdentifier)parent.get()).getSource(), testIdentifier.getSource())) {
                return false;
            }
            parent = this.currentTestPlan.getParent((TestIdentifier)parent.get());
        }
        return true;
    }
}

