/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.configurationcache.ConfigurationCacheAction;
import org.gradle.configurationcache.ConfigurationCacheKey;
import org.gradle.configurationcache.ConfigurationCacheProblemsException;
import org.gradle.configurationcache.TooManyConfigurationCacheProblemsException;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems$WhenMappings;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummary;
import org.gradle.configurationcache.problems.ConfigurationCacheReport;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.buildtree.ProblemReporter;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00014B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0006\u0010\u001d\u001a\u00020\u0011J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u0011J+\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001f2\u0014\b\u0002\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%H\u0002\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J \u0010\u0006\u001a\u00020\u00112\u0006\u0010-\u001a\u00020+2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u0002000/H\u0016J\u0014\u00101\u001a\u00020\u00112\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u00103\u001a\u00020\u001f*\u0004\u0018\u00010\u000eH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "Lorg/gradle/problems/buildtree/ProblemReporter;", "Ljava/lang/AutoCloseable;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "report", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;", "cacheKey", "Lorg/gradle/configurationcache/ConfigurationCacheKey;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;Lorg/gradle/configurationcache/ConfigurationCacheKey;Lorg/gradle/internal/event/ListenerManager;)V", "cacheAction", "Lorg/gradle/configurationcache/ConfigurationCacheAction;", "invalidateStoredState", "Lkotlin/Function0;", "", "isFailOnProblems", "", "isFailingBuildDueToSerializationError", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "postBuildHandler", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "summary", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblemsSummary;", "close", "failingBuildDueToSerializationError", "getId", "", "loading", "log", "msg", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "onProblem", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "outputDirectoryFor", "Ljava/io/File;", "buildDir", "reportDir", "validationFailures", "Ljava/util/function/Consumer;", "", "storing", "invalidateState", "summaryText", "PostBuildProblemsHandler", "configuration-cache"})
public final class ConfigurationCacheProblems
implements ProblemsListener,
ProblemReporter,
AutoCloseable {
    private final ConfigurationCacheProblemsSummary summary;
    private final PostBuildProblemsHandler postBuildHandler;
    private boolean isFailOnProblems;
    private boolean isFailingBuildDueToSerializationError;
    private ConfigurationCacheAction cacheAction;
    private Function0<Unit> invalidateStoredState;
    private final Logger logger;
    private final ConfigurationCacheStartParameter startParameter;
    private final ConfigurationCacheReport report;
    private final ConfigurationCacheKey cacheKey;
    private final ListenerManager listenerManager;

    @Override
    public void close() {
        this.listenerManager.removeListener((Object)this.postBuildHandler);
    }

    public final void storing(@NotNull Function0<Unit> invalidateState) {
        Intrinsics.checkNotNullParameter(invalidateState, (String)"invalidateState");
        this.cacheAction = ConfigurationCacheAction.STORE;
        this.invalidateStoredState = invalidateState;
    }

    public final void loading() {
        this.cacheAction = ConfigurationCacheAction.LOAD;
    }

    public final void failingBuildDueToSerializationError() {
        this.isFailingBuildDueToSerializationError = true;
        this.isFailOnProblems = false;
    }

    @Override
    public void onProblem(@NotNull PropertyProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (this.summary.onProblem(problem)) {
            this.report.onProblem(problem);
        }
    }

    @NotNull
    public String getId() {
        return "configuration-cache";
    }

    public void report(@NotNull File reportDir, @NotNull Consumer<? super Throwable> validationFailures) {
        boolean hasTooManyProblems;
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        Intrinsics.checkNotNullParameter(validationFailures, (String)"validationFailures");
        int problemCount = this.summary.getProblemCount();
        if (problemCount == 0) {
            return;
        }
        boolean bl = hasTooManyProblems = problemCount > this.startParameter.getMaxProblems();
        if (this.cacheAction == ConfigurationCacheAction.STORE && (this.isFailOnProblems || hasTooManyProblems)) {
            Function0<Unit> function0 = this.invalidateStoredState;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (function0 == null) {
                boolean bl5 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            function0.invoke();
        }
        String cacheActionText = this.summaryText(this.cacheAction);
        File outputDirectory = this.outputDirectoryFor(reportDir);
        File htmlReportFile = this.report.writeReportFileTo$configuration_cache(outputDirectory, cacheActionText, problemCount);
        if (this.isFailOnProblems) {
            validationFailures.accept((Throwable)((Object)new ConfigurationCacheProblemsException(this.summary.getCauses(), (Function0<String>)((Function0)new Function0<String>(this, cacheActionText, htmlReportFile){
                final /* synthetic */ ConfigurationCacheProblems this$0;
                final /* synthetic */ String $cacheActionText;
                final /* synthetic */ File $htmlReportFile;

                @NotNull
                public final String invoke() {
                    return ConfigurationCacheProblems.access$getSummary$p(this.this$0).textForConsole(this.$cacheActionText, this.$htmlReportFile);
                }
                {
                    this.this$0 = configurationCacheProblems;
                    this.$cacheActionText = string2;
                    this.$htmlReportFile = file;
                    super(0);
                }
            }))));
        } else if (hasTooManyProblems) {
            validationFailures.accept((Throwable)((Object)new TooManyConfigurationCacheProblemsException(this.summary.getCauses(), (Function0<String>)((Function0)new Function0<String>(this, cacheActionText, htmlReportFile){
                final /* synthetic */ ConfigurationCacheProblems this$0;
                final /* synthetic */ String $cacheActionText;
                final /* synthetic */ File $htmlReportFile;

                @NotNull
                public final String invoke() {
                    return ConfigurationCacheProblems.access$getSummary$p(this.this$0).textForConsole(this.$cacheActionText, this.$htmlReportFile);
                }
                {
                    this.this$0 = configurationCacheProblems;
                    this.$cacheActionText = string2;
                    this.$htmlReportFile = file;
                    super(0);
                }
            }))));
        } else {
            this.logger.warn(this.summary.textForConsole(cacheActionText, htmlReportFile));
        }
    }

    private final String summaryText(ConfigurationCacheAction $this$summaryText) {
        String string2;
        ConfigurationCacheAction configurationCacheAction = $this$summaryText;
        if (configurationCacheAction == null) {
            string2 = "storing";
        } else {
            switch (ConfigurationCacheProblems$WhenMappings.$EnumSwitchMapping$0[configurationCacheAction.ordinal()]) {
                case 1: {
                    string2 = "reusing";
                    break;
                }
                case 2: {
                    string2 = "storing";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string2;
    }

    private final File outputDirectoryFor(File buildDir) {
        return FilesKt.resolve((File)buildDir, (String)("reports/configuration-cache/" + this.cacheKey));
    }

    private final void log(String msg, Object ... args) {
        this.logger.warn(msg, Arrays.copyOf(args, args.length));
    }

    static /* synthetic */ void log$default(ConfigurationCacheProblems configurationCacheProblems, String string2, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            objectArray = new Object[]{};
        }
        configurationCacheProblems.log(string2, objectArray);
    }

    public ConfigurationCacheProblems(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull ConfigurationCacheReport report2, @NotNull ConfigurationCacheKey cacheKey, @NotNull ListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.startParameter = startParameter;
        this.report = report2;
        this.cacheKey = cacheKey;
        this.listenerManager = listenerManager;
        this.summary = new ConfigurationCacheProblemsSummary();
        this.postBuildHandler = new PostBuildProblemsHandler();
        this.isFailOnProblems = this.startParameter.getFailOnProblems();
        this.listenerManager.addListener((Object)this.postBuildHandler);
        this.logger = Logging.getLogger(ConfigurationCacheProblems.class);
    }

    public static final /* synthetic */ void access$setFailingBuildDueToSerializationError$p(ConfigurationCacheProblems $this, boolean bl) {
        $this.isFailingBuildDueToSerializationError = bl;
    }

    public static final /* synthetic */ void access$setCacheAction$p(ConfigurationCacheProblems $this, ConfigurationCacheAction configurationCacheAction) {
        $this.cacheAction = configurationCacheAction;
    }

    public static final /* synthetic */ void access$setFailOnProblems$p(ConfigurationCacheProblems $this, boolean bl) {
        $this.isFailOnProblems = bl;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "Lorg/gradle/initialization/RootBuildLifecycleListener;", "(Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;)V", "afterStart", "", "beforeComplete", "configuration-cache"})
    private final class PostBuildProblemsHandler
    implements RootBuildLifecycleListener {
        public void afterStart() {
        }

        public void beforeComplete() {
            block1: {
                String problemCountString;
                boolean hasProblems;
                block9: {
                    boolean hasTooManyProblems;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block3: {
                                            block2: {
                                                block0: {
                                                    int problemCount = ConfigurationCacheProblems.this.summary.getProblemCount();
                                                    hasProblems = problemCount > 0;
                                                    hasTooManyProblems = problemCount > ConfigurationCacheProblems.this.startParameter.getMaxProblems();
                                                    problemCountString = problemCount == 1 ? "1 problem" : problemCount + " problems";
                                                    if (!ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError || hasProblems) break block0;
                                                    ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry discarded.", null, 2, null);
                                                    break block1;
                                                }
                                                if (!ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError) break block2;
                                                ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", problemCountString);
                                                break block1;
                                            }
                                            if (ConfigurationCacheProblems.this.cacheAction != ConfigurationCacheAction.STORE || !ConfigurationCacheProblems.this.isFailOnProblems || !hasProblems) break block3;
                                            ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", problemCountString);
                                            break block1;
                                        }
                                        if (ConfigurationCacheProblems.this.cacheAction != ConfigurationCacheAction.STORE || !hasTooManyProblems) break block4;
                                        ConfigurationCacheProblems.this.log("Configuration cache entry discarded with too many problems ({}).", problemCountString);
                                        break block1;
                                    }
                                    if (ConfigurationCacheProblems.this.cacheAction != ConfigurationCacheAction.STORE || hasProblems) break block5;
                                    ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry stored.", null, 2, null);
                                    break block1;
                                }
                                if (ConfigurationCacheProblems.this.cacheAction != ConfigurationCacheAction.STORE) break block6;
                                ConfigurationCacheProblems.this.log("Configuration cache entry stored with {}.", problemCountString);
                                break block1;
                            }
                            if (ConfigurationCacheProblems.this.cacheAction != ConfigurationCacheAction.LOAD || hasProblems) break block7;
                            ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry reused.", null, 2, null);
                            break block1;
                        }
                        if (ConfigurationCacheProblems.this.cacheAction != ConfigurationCacheAction.LOAD) break block8;
                        ConfigurationCacheProblems.this.log("Configuration cache entry reused with {}.", problemCountString);
                        break block1;
                    }
                    if (!hasTooManyProblems) break block9;
                    ConfigurationCacheProblems.this.log("Too many configuration cache problems found ({}).", problemCountString);
                    break block1;
                }
                if (!hasProblems) break block1;
                ConfigurationCacheProblems.this.log("Configuration cache problems found ({}).", problemCountString);
            }
        }
    }
}

