/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass2, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass2 == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass2.getManager();
        return manager.areElementsEquivalent(baseClass, aClass2) || aClass2.isInheritor(baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass2, boolean includeSelf, @NotNull Processor<? super PsiClass> superProcessor) {
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(0);
        }
        if (aClass2 == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass2)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass2, superProcessor, (Set<? super PsiClass>)new THashSet());
    }

    private static boolean processSupers(@NotNull PsiClass aClass2, @NotNull Processor<? super PsiClass> superProcessor, @NotNull Set<? super PsiClass> visited2) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(1);
        }
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(2);
        }
        if (visited2 == null) {
            InheritanceUtil.$$$reportNull$$$0(3);
        }
        if (!visited2.add(aClass2)) {
            return true;
        }
        for (PsiClass intf : aClass2.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited2)) continue;
            return false;
        }
        PsiClass superClass2 = aClass2.getSuperClass();
        return superClass2 == null || superProcessor.process(superClass2) && InheritanceUtil.processSupers(superClass2, superProcessor, visited2);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiType type2, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type2).resolve(), baseClassName);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (!InheritanceUtil.isInheritor(conjunct, baseClassName)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(5);
        }
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(@NotNull PsiClass aClass2, @NotNull Set<? super PsiClass> results, boolean includeNonProject) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(7);
        }
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(8);
        }
        InheritanceUtil.getSuperClassesOfList(aClass2.getSuperTypes(), results, includeNonProject, (Set<? super PsiClass>)new THashSet(), aClass2.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(9);
        }
        LinkedHashSet<PsiClass> result2 = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass2, result2, true);
        return result2;
    }

    private static void getSuperClassesOfList(PsiClassType @NotNull [] types2, @NotNull Set<? super PsiClass> results, boolean includeNonProject, @NotNull Set<? super PsiClass> visited2, @NotNull PsiManager manager) {
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(10);
        }
        if (visited2 == null) {
            InheritanceUtil.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            InheritanceUtil.$$$reportNull$$$0(12);
        }
        if (types2 == null) {
            InheritanceUtil.$$$reportNull$$$0(13);
        }
        for (PsiClassType type2 : types2) {
            PsiClass resolved = type2.resolve();
            if (resolved == null || !visited2.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited2, manager);
        }
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass aClass2, PsiElement scope2, boolean isSuperClassAccepted, boolean isTypeParamsAccepted) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(14);
        }
        return InheritanceUtil.hasEnclosingInstanceInScope(aClass2, scope2, psiClass -> isSuperClassAccepted, isTypeParamsAccepted);
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass aClass2, PsiElement scope2, Condition<? super PsiClass> isSuperClassAccepted, boolean isTypeParamsAccepted) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(15);
        }
        return InheritanceUtil.findEnclosingInstanceInScope(aClass2, scope2, isSuperClassAccepted, isTypeParamsAccepted) != null;
    }

    @Nullable
    public static PsiClass findEnclosingInstanceInScope(@NotNull PsiClass aClass2, PsiElement scope2, Condition<? super PsiClass> isSuperClassAccepted, boolean isTypeParamsAccepted) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(16);
        }
        PsiManager manager = aClass2.getManager();
        for (PsiElement place = scope2; place != null && !(place instanceof PsiFile); place = place.getParent()) {
            PsiModifierList modifierList2;
            if (place instanceof PsiClass) {
                if (isSuperClassAccepted.value((PsiClass)place)) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)place, aClass2, true)) {
                        return (PsiClass)place;
                    }
                } else if (manager.areElementsEquivalent(place, aClass2)) {
                    return aClass2;
                }
                if (isTypeParamsAccepted && place instanceof PsiTypeParameter) {
                    return (PsiClass)place;
                }
            }
            if (!(place instanceof PsiModifierListOwner) || (modifierList2 = ((PsiModifierListOwner)place).getModifierList()) == null || !modifierList2.hasModifierProperty("static")) continue;
            return null;
        }
        return null;
    }

    public static boolean processSuperTypes(@NotNull PsiType type2, boolean includeSelf, @NotNull Processor<? super PsiType> processor2) {
        if (type2 == null) {
            InheritanceUtil.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            InheritanceUtil.$$$reportNull$$$0(18);
        }
        if (includeSelf && !processor2.process(type2)) {
            return false;
        }
        return InheritanceUtil.processSuperTypes(type2, processor2, new HashSet());
    }

    private static boolean processSuperTypes(PsiType type2, Processor<? super PsiType> processor2, Set<? super PsiType> visited2) {
        if (!visited2.add(type2)) {
            return true;
        }
        for (PsiType superType : type2.getSuperTypes()) {
            if (!processor2.process(superType)) {
                return false;
            }
            InheritanceUtil.processSuperTypes(superType, processor2, visited2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PsiClass getCircularClass(@NotNull PsiClass aClass2, @NotNull Collection<? super PsiClass> usedClasses) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(19);
        }
        if (usedClasses == null) {
            InheritanceUtil.$$$reportNull$$$0(20);
        }
        if (usedClasses.contains(aClass2)) {
            return aClass2;
        }
        try {
            PsiClass[] superTypes2;
            usedClasses.add(aClass2);
            for (PsiElement superType : superTypes2 = aClass2.getSupers()) {
                while (superType instanceof PsiClass) {
                    PsiClass circularClass;
                    if (!"java.lang.Object".equals(superType.getQualifiedName()) && (circularClass = InheritanceUtil.getCircularClass(superType, usedClasses)) != null) {
                        PsiClass psiClass = circularClass;
                        return psiClass;
                    }
                    superType = superType.getParent();
                }
            }
        }
        finally {
            usedClasses.remove(aClass2);
        }
        return null;
    }

    @Nullable
    public static PsiClass getCircularClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(21);
        }
        return InheritanceUtil.getCircularClass(aClass2, new HashSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superProcessor";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedClasses";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processSupers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClasses";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClassesOfList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEnclosingInstanceInScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingInstanceInScope";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperTypes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getCircularClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

