/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.presentation.java;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.navigation.ColoredItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.editor.colors.CodeInsightColors;
import org.jetbrains.kotlin.com.intellij.openapi.editor.colors.TextAttributesKey;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class JavaPresentationUtil {
    private JavaPresentationUtil() {
    }

    @NotNull
    public static ColoredItemPresentation getMethodPresentation(final @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JavaPresentationUtil.$$$reportNull$$$0(0);
        }
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 257, 2);
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiMethod.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiMethod);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiMethod.getIcon(1);
            }
        };
    }

    @NotNull
    public static ItemPresentation getFieldPresentation(final @NotNull PsiField psiField) {
        if (psiField == null) {
            JavaPresentationUtil.$$$reportNull$$$0(1);
        }
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return psiField.getName();
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiField.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiField);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiField.getIcon(1);
            }
        };
    }

    @Nullable
    private static String getJavaSymbolContainerText(@NotNull PsiElement element) {
        String qName;
        Object container2;
        if (element == null) {
            JavaPresentationUtil.$$$reportNull$$$0(2);
        }
        String result2 = (container2 = PsiTreeUtil.getParentOfType(element, PsiMember.class, PsiFile.class)) instanceof PsiClass ? ((qName = ((PsiClass)container2).getQualifiedName()) != null ? qName : ((PsiClass)container2).getName()) : (container2 instanceof PsiJavaFile ? ((PsiJavaFile)container2).getPackageName() : null);
        if (result2 != null) {
            return JavaPsiBundle.message("aux.context.display", result2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaPresentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getJavaSymbolContainerText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

