/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.plugin.management.PluginManagementSpec;
import org.gradle.plugin.management.internal.PluginManagementSpecInternal;
import org.gradle.vcs.SourceControl;

public abstract class DefaultSettings
extends AbstractPluginAware
implements SettingsInternal {
    private ScriptSource settingsScript;
    private StartParameter startParameter;
    private File settingsDir;
    private DefaultProjectDescriptor rootProjectDescriptor;
    private DefaultProjectDescriptor defaultProjectDescriptor;
    private final GradleInternal gradle;
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private final ScriptHandler scriptHandler;
    private final ServiceRegistry services;
    private final List<IncludedBuildSpec> includedBuildSpecs = new ArrayList<IncludedBuildSpec>();
    private final DependencyResolutionManagementInternal dependencyResolutionManagement;

    public DefaultSettings(ServiceRegistryFactory serviceRegistryFactory, GradleInternal gradle, ClassLoaderScope classLoaderScope, ClassLoaderScope baseClassLoaderScope, ScriptHandler settingsScriptHandler, File settingsDir, ScriptSource settingsScript, StartParameter startParameter) {
        this.gradle = gradle;
        this.classLoaderScope = classLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        this.scriptHandler = settingsScriptHandler;
        this.settingsDir = settingsDir;
        this.settingsScript = settingsScript;
        this.startParameter = startParameter;
        this.services = serviceRegistryFactory.createFor(this);
        this.rootProjectDescriptor = this.createProjectDescriptor(null, settingsDir.getName(), settingsDir);
        this.dependencyResolutionManagement = (DependencyResolutionManagementInternal)this.services.get(DependencyResolutionManagementInternal.class);
    }

    public String toString() {
        return "settings '" + this.rootProjectDescriptor.getName() + "'";
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public List<IncludedBuildSpec> getIncludedBuilds() {
        return this.includedBuildSpecs;
    }

    public Settings getSettings() {
        return this;
    }

    public ScriptHandler getBuildscript() {
        return this.scriptHandler;
    }

    public DefaultProjectDescriptor createProjectDescriptor(DefaultProjectDescriptor parent, String name, File dir) {
        return new DefaultProjectDescriptor(parent, name, dir, this.getProjectDescriptorRegistry(), (PathToFileResolver)this.getFileResolver());
    }

    public DefaultProjectDescriptor findProject(String path) {
        return (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(path);
    }

    public DefaultProjectDescriptor findProject(File projectDir) {
        return (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(projectDir);
    }

    public DefaultProjectDescriptor project(String path) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(path);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", path));
        }
        return projectDescriptor;
    }

    public DefaultProjectDescriptor project(File projectDir) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(projectDir);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", projectDir));
        }
        return projectDescriptor;
    }

    public void include(String ... projectPaths) {
        for (String projectPath : projectPaths) {
            String subPath = "";
            String[] pathElements = this.removeTrailingColon(projectPath).split(":");
            DefaultProjectDescriptor parentProjectDescriptor = this.rootProjectDescriptor;
            for (String pathElement : pathElements) {
                subPath = subPath + ":" + pathElement;
                DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(subPath);
                parentProjectDescriptor = projectDescriptor == null ? this.createProjectDescriptor(parentProjectDescriptor, pathElement, new File(parentProjectDescriptor.getProjectDir(), pathElement)) : projectDescriptor;
            }
        }
    }

    @Deprecated
    public void includeFlat(String ... projectNames) {
        for (String projectName : projectNames) {
            this.createProjectDescriptor(this.rootProjectDescriptor, projectName, new File(this.rootProjectDescriptor.getProjectDir().getParentFile(), projectName));
        }
    }

    private String removeTrailingColon(String projectPath) {
        if (projectPath.startsWith(":")) {
            return projectPath.substring(1);
        }
        return projectPath;
    }

    public ProjectDescriptor getRootProject() {
        return this.rootProjectDescriptor;
    }

    public void setRootProjectDescriptor(DefaultProjectDescriptor rootProjectDescriptor) {
        this.rootProjectDescriptor = rootProjectDescriptor;
    }

    @Override
    public DefaultProjectDescriptor getDefaultProject() {
        return this.defaultProjectDescriptor;
    }

    @Override
    public void setDefaultProject(DefaultProjectDescriptor defaultProjectDescriptor) {
        this.defaultProjectDescriptor = defaultProjectDescriptor;
    }

    public File getRootDir() {
        return this.rootProjectDescriptor.getProjectDir();
    }

    @Override
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    public File getSettingsDir() {
        return this.settingsDir;
    }

    public void setSettingsDir(File settingsDir) {
        this.settingsDir = settingsDir;
    }

    @Override
    public ScriptSource getSettingsScript() {
        return this.settingsScript;
    }

    public void setSettingsScript(ScriptSource settingsScript) {
        this.settingsScript = settingsScript;
    }

    @Inject
    public ProviderFactory getProviders() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public ProjectDescriptorRegistry getProjectDescriptorRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public TextUriResourceLoader.Factory getTextUriResourceLoaderFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectRegistry<DefaultProjectDescriptor> getProjectRegistry() {
        return this.getProjectDescriptorRegistry();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.baseClassLoaderScope, this.getTextUriResourceLoaderFactory(), this);
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public File getBuildSrcDir() {
        return new File(this.getSettingsDir(), "buildSrc");
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PluginManagerInternal getPluginManager() {
        throw new UnsupportedOperationException();
    }

    public void includeBuild(Object rootProject) {
        this.includeBuild(rootProject, (Action<ConfigurableIncludedBuild>)Actions.doNothing());
    }

    public void includeBuild(Object rootProject, Action<ConfigurableIncludedBuild> configuration) {
        File projectDir = this.getFileResolver().resolve(rootProject);
        this.includedBuildSpecs.add(IncludedBuildSpec.includedBuild(projectDir, configuration));
    }

    public void buildCache(Action<? super BuildCacheConfiguration> action) {
        action.execute((Object)this.getBuildCache());
    }

    @Override
    @Inject
    public BuildCacheConfigurationInternal getBuildCache() {
        throw new UnsupportedOperationException();
    }

    public void pluginManagement(Action<? super PluginManagementSpec> rule) {
        rule.execute((Object)this.getPluginManagement());
        this.includedBuildSpecs.addAll(((PluginManagementSpecInternal)this.getPluginManagement()).getIncludedBuilds());
    }

    @Inject
    public PluginManagementSpec getPluginManagement() {
        throw new UnsupportedOperationException();
    }

    public void sourceControl(Action<? super SourceControl> configuration) {
        configuration.execute((Object)this.getSourceControl());
    }

    @Inject
    public SourceControl getSourceControl() {
        throw new UnsupportedOperationException();
    }

    public void enableFeaturePreview(String name) {
        FeaturePreviews.Feature feature = FeaturePreviews.Feature.withName(name);
        if (feature.isActive()) {
            ((FeaturePreviews)this.services.get(FeaturePreviews.class)).enableFeature(feature);
        } else {
            DeprecationLogger.deprecate((String)("enableFeaturePreview('" + feature.name() + "')")).withAdvice("The feature flag is no longer relevant, please remove it from your settings file.").willBeRemovedInGradle8().withUserManual("feature_lifecycle", "feature_preview").nagUser();
        }
    }

    public void dependencyResolutionManagement(Action<? super DependencyResolutionManagement> dependencyResolutionConfiguration) {
        dependencyResolutionConfiguration.execute((Object)this.dependencyResolutionManagement);
    }

    @Override
    public void preventFromFurtherMutation() {
        this.dependencyResolutionManagement.preventFromFurtherMutation();
    }

    @Override
    public DependencyResolutionManagementInternal getDependencyResolutionManagement() {
        return this.dependencyResolutionManagement;
    }
}

