/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskpath;

import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.internal.NameMatcher;

public class ProjectFinderByTaskPath {
    public ProjectInternal findProject(String projectPath, ProjectInternal startFrom) {
        if (projectPath.equals(":")) {
            return startFrom.getRootProject();
        }
        ProjectInternal current = startFrom;
        if (projectPath.startsWith(":")) {
            current = current.getRootProject();
            projectPath = projectPath.substring(1);
        }
        String[] stringArray = projectPath.split(":");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            NameMatcher matcher = new NameMatcher();
            String pattern = stringArray[i];
            Map children = current.getChildProjects();
            Project child = (Project)matcher.find(pattern, children);
            if (child == null) {
                throw new ProjectLookupException(matcher.formatErrorMessage("project", current));
            }
            current = child;
        }
        return current;
    }

    public static class ProjectLookupException
    extends InvalidUserDataException {
        public ProjectLookupException(String message) {
            super(message);
        }
    }
}

