/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultIncludedBuild
extends AbstractCompositeParticipantBuildState
implements IncludedBuildState,
IncludedBuild,
Stoppable {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;
    private final BuildState owner;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildLifecycleController buildLifecycleController;

    public DefaultIncludedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner, BuildTreeState buildTree, WorkerLeaseRegistry.WorkerLease parentLease, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ProjectStateRegistry projectStateRegistry) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
        this.owner = owner;
        this.parentLease = parentLease;
        this.projectStateRegistry = projectStateRegistry;
        BuildScopeServices buildScopeServices = new BuildScopeServices(buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition.newInstance(), (BuildState)this, owner.getMutableModel(), buildScopeServices);
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return this.projectStateRegistry;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public File getRootDirectory() {
        return this.buildDefinition.getBuildRootDir();
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    public IncludedBuild getModel() {
        return this;
    }

    public boolean isPluginBuild() {
        return this.buildDefinition.isPluginBuild();
    }

    public File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
        return new IncludedBuildTaskReference(this, path);
    }

    public String getName() {
        return this.identityPath.getName();
    }

    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        if (this.isImplicit) {
            super.assertCanAdd(includedBuildSpec);
        }
    }

    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildIdentifier.getName());
    }

    public Path getIdentityPathForProject(Path projectPath) {
        return this.getIdentityPath().append(projectPath);
    }

    public Action<? super DependencySubstitutions> getRegisteredDependencySubstitutions() {
        return this.buildDefinition.getDependencySubstitutions();
    }

    public boolean hasInjectedSettingsPlugins() {
        return !this.buildDefinition.getInjectedPluginRequests().isEmpty();
    }

    public SettingsInternal loadSettings() {
        return this.buildLifecycleController.getLoadedSettings();
    }

    public SettingsInternal getLoadedSettings() {
        return this.getGradle().getSettings();
    }

    public GradleInternal getConfiguredBuild() {
        return this.buildLifecycleController.getConfiguredBuild();
    }

    public GradleInternal getBuild() {
        return this.getConfiguredBuild();
    }

    public <T> T withState(Transformer<T, ? super GradleInternal> action) {
        return (T)action.transform((Object)this.getGradle());
    }

    public void finishBuild(Consumer<? super Throwable> collector) {
        this.buildLifecycleController.finishBuild(null, collector);
    }

    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.scheduleTasks(taskPaths);
    }

    public synchronized void execute(Iterable<String> tasks, Object listener) {
        this.buildLifecycleController.addListener(listener);
        this.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = this.gradleService(WorkerLeaseService.class);
        workerLeaseService.withSharedLease(this.parentLease, () -> ((BuildLifecycleController)this.buildLifecycleController).executeTasks());
    }

    public void stop() {
        this.buildLifecycleController.stop();
    }

    protected void scheduleTasks(Iterable<String> tasks) {
        this.buildLifecycleController.scheduleTasks(tasks);
    }

    protected GradleInternal getGradle() {
        return this.buildLifecycleController.getGradle();
    }

    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }

    private <T> T gradleService(Class<T> serviceType) {
        return (T)this.getGradle().getServices().get(serviceType);
    }
}

