/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Optional;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.work.InputChanges;

public class ExecuteStep<C extends InputChangesContext>
implements Step<C, Result> {
    private final BuildOperationExecutor buildOperationExecutor;

    public ExecuteStep(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Result execute(final UnitOfWork work, final C context) {
        return (Result)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Result>(){

            public Result call(BuildOperationContext operationContext) {
                Result result = ExecuteStep.executeInternal(work, context);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE);
            }
        });
    }

    private static Result executeInternal(UnitOfWork work, final InputChangesContext context) {
        try {
            UnitOfWork.ExecutionRequest executionRequest = new UnitOfWork.ExecutionRequest(){

                @Override
                public File getWorkspace() {
                    return context.getWorkspace();
                }

                @Override
                public Optional<InputChangesInternal> getInputChanges() {
                    return context.getInputChanges();
                }

                @Override
                public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs() {
                    return context.getAfterPreviousExecutionState().map(AfterPreviousExecutionState::getOutputFilesProducedByWork);
                }
            };
            final UnitOfWork.WorkOutput workOutput = work.execute(executionRequest);
            final ExecutionOutcome outcome = ExecuteStep.determineOutcome(context, workOutput);
            ExecutionResult executionResult = new ExecutionResult(){

                @Override
                public ExecutionOutcome getOutcome() {
                    return outcome;
                }

                @Override
                public Object getOutput() {
                    return workOutput.getOutput();
                }
            };
            return () -> Try.successful((Object)executionResult);
        }
        catch (Throwable t) {
            return () -> Try.failure((Throwable)t);
        }
    }

    private static ExecutionOutcome determineOutcome(InputChangesContext context, UnitOfWork.WorkOutput workOutput) {
        ExecutionOutcome outcome;
        switch (workOutput.getDidWork()) {
            case DID_NO_WORK: {
                outcome = ExecutionOutcome.UP_TO_DATE;
                break;
            }
            case DID_WORK: {
                boolean incremental = context.getInputChanges().map(InputChanges::isIncremental).orElse(false);
                outcome = incremental ? ExecutionOutcome.EXECUTED_INCREMENTALLY : ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return outcome;
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

