/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.FirSourceChildrenKt;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.ControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.LocalPropertyCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extended.UnusedChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "()V", "identifierSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getIdentifierSource", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Lorg/jetbrains/kotlin/fir/FirSourceElement;", "isLoopIterator", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkerContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "CfaVisitor", "ValueWritesWithoutReading", "VariableStatus", "VariableStatusInfo", "checkers"})
public final class UnusedChecker
extends FirControlFlowChecker {
    @NotNull
    public static final UnusedChecker INSTANCE = new UnusedChecker();

    private UnusedChecker() {
    }

    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext checkerContext) {
        FirClassLikeDeclaration<Object> firClassLikeDeclaration;
        FirSymbolOwner firSymbolOwner;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)checkerContext, (String)"checkerContext");
        FirClassLikeDeclaration<?> firClassLikeDeclaration2 = graph2.getDeclaration();
        FirSymbolOwner firSymbolOwner2 = firSymbolOwner = firClassLikeDeclaration2 instanceof FirSymbolOwner ? (FirSymbolOwner)firClassLikeDeclaration2 : null;
        if (firSymbolOwner == null) {
            firClassLikeDeclaration = null;
        } else {
            firClassLikeDeclaration2 = FirHelpersKt.getContainingClass(firSymbolOwner, checkerContext);
            if (firClassLikeDeclaration2 == null) {
                firClassLikeDeclaration = null;
            } else {
                FirClassLikeDeclaration<?> firClassLikeDeclaration3 = firClassLikeDeclaration2;
                boolean bl = false;
                boolean bl2 = false;
                FirClassLikeDeclaration<?> it = firClassLikeDeclaration3;
                boolean bl3 = false;
                firClassLikeDeclaration = !it.getSymbol().getClassId().isLocal() ? firClassLikeDeclaration3 : null;
            }
        }
        if (firClassLikeDeclaration != null) {
            return;
        }
        Set<FirPropertySymbol> properties2 = LocalPropertyCollector.Companion.collect(graph2);
        if (properties2.isEmpty()) {
            return;
        }
        Map<CFGNode<?>, VariableStatusInfo> data = new ValueWritesWithoutReading(properties2).getData(graph2);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Backward, new CfaVisitor(data, reporter));
    }

    private final boolean isLoopIterator(FirPropertySymbol $this$isLoopIterator) {
        FirSourceElement firSourceElement;
        FirExpression firExpression2 = ((FirProperty)$this$isLoopIterator.getFir()).getInitializer();
        return Intrinsics.areEqual(firExpression2 == null ? null : ((firSourceElement = firExpression2.getSource()) == null ? null : firSourceElement.getKind()), (Object)FirFakeSourceElementKind.DesugaredForLoop.INSTANCE);
    }

    private final FirSourceElement getIdentifierSource(FirPropertySymbol $this$identifierSource) {
        FirSourceElement firSourceElement;
        FirSourceElement firSourceElement2 = ((FirProperty)$this$identifierSource.getFir()).getSource();
        if (firSourceElement2 == null) {
            firSourceElement = null;
        } else {
            KtToken ktToken = KtTokens.IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"IDENTIFIER");
            firSourceElement = FirSourceChildrenKt.getChild(firSourceElement2, ktToken, 0, 1);
        }
        return firSourceElement;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$CfaVisitor;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;)V", "getData", "()Ljava/util/Map;", "getReporter", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    public static final class CfaVisitor
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, VariableStatusInfo> data;
        @NotNull
        private final DiagnosticReporter reporter;

        public CfaVisitor(@NotNull Map<CFGNode<?>, VariableStatusInfo> data, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.data = data;
            this.reporter = reporter;
        }

        @NotNull
        public final Map<CFGNode<?>, VariableStatusInfo> getData() {
            return this.data;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Object object;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object2 = node.getFir().getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = object2 instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object2 : null;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol2 = abstractFirBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
            if (abstractFirBasedSymbol == null) {
                return;
            }
            AbstractFirBasedSymbol<?> variableSymbol = abstractFirBasedSymbol;
            object2 = this.data.get(node);
            if (object2 == null) {
                object = null;
            } else {
                Map map = (Map)object2;
                boolean bl = false;
                object = firResolvedNamedReference = (VariableStatus)((Object)map.get(variableSymbol));
            }
            if (firResolvedNamedReference == null) {
                return;
            }
            FirResolvedNamedReference data = firResolvedNamedReference;
            if (data == VariableStatus.ONLY_WRITTEN_NEVER_READ) {
                FirSourceElement source = node.getFir().getLValue().getSource();
                object2 = this.reporter;
                FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ();
                boolean $i$f$report = false;
                FirSourceElement firSourceElement = source;
                if (firSourceElement != null) {
                    void $this$report$iv;
                    FirSourceElement firSourceElement2 = firSourceElement;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirSourceElement it$iv = firSourceElement2;
                    boolean bl3 = false;
                    $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
                }
            }
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Object $this$report$iv;
            FirSourceElement source;
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol variableSymbol = node.getFir().getSymbol();
            if (INSTANCE.isLoopIterator(variableSymbol)) {
                return;
            }
            Object object2 = this.data.get(node);
            VariableStatus variableStatus = object = object2 == null ? null : (VariableStatus)((Object)((ControlFlowInfo)object2).get(variableSymbol));
            if (object == null) {
                return;
            }
            VariableStatus data = object;
            if (data == VariableStatus.UNUSED) {
                object2 = node.getFir().getInitializer();
                object = object2 instanceof FirFunctionCall ? (FirFunctionCall)object2 : null;
                if (!Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(FirHelpersKt.isIterator((FirFunctionCall)object))), (Object)true)) {
                    source = INSTANCE.getIdentifierSource(variableSymbol);
                    object2 = this.reporter;
                    FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getUNUSED_VARIABLE();
                    boolean $i$f$report = false;
                    FirSourceElement firSourceElement = source;
                    if (firSourceElement != null) {
                        FirSourceElement firSourceElement2 = firSourceElement;
                        boolean bl = false;
                        boolean bl2 = false;
                        FirSourceElement it$iv = firSourceElement2;
                        boolean bl3 = false;
                        ((DiagnosticReporter)$this$report$iv).report((FirDiagnostic)factory$iv.on(it$iv));
                    }
                }
            } else if (data.isRedundantInit()) {
                $this$report$iv = ((FirProperty)variableSymbol.getFir()).getInitializer();
                source = $this$report$iv == null ? null : ((FirExpression)$this$report$iv).getSource();
                $this$report$iv = this.reporter;
                FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT();
                boolean $i$f$report = false;
                FirSourceElement firSourceElement = source;
                if (firSourceElement != null) {
                    FirSourceElement firSourceElement3 = firSourceElement;
                    boolean bl = false;
                    boolean bl4 = false;
                    FirSourceElement it$iv = firSourceElement3;
                    boolean bl5 = false;
                    ((DiagnosticReporter)$this$report$iv).report((FirDiagnostic)factory$iv.on(it$iv));
                }
            } else if (data == VariableStatus.ONLY_WRITTEN_NEVER_READ) {
                source = INSTANCE.getIdentifierSource(variableSymbol);
                $this$report$iv = this.reporter;
                FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getVARIABLE_NEVER_READ();
                boolean $i$f$report = false;
                FirSourceElement firSourceElement = source;
                if (firSourceElement != null) {
                    FirSourceElement firSourceElement4 = firSourceElement;
                    boolean bl = false;
                    boolean bl6 = false;
                    FirSourceElement it$iv = firSourceElement4;
                    boolean bl7 = false;
                    ((DiagnosticReporter)$this$report$iv).report((FirDiagnostic)factory$iv.on(it$iv));
                }
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "", "priority", "", "(Ljava/lang/String;II)V", "isRead", "", "()Z", "setRead", "(Z)V", "isRedundantInit", "setRedundantInit", "merge", "variableUseState", "READ", "WRITTEN_AFTER_READ", "ONLY_WRITTEN_NEVER_READ", "UNUSED", "checkers"})
    public static final class VariableStatus
    extends Enum<VariableStatus> {
        private final int priority;
        private boolean isRead;
        private boolean isRedundantInit;
        public static final /* enum */ VariableStatus READ = new VariableStatus(3);
        public static final /* enum */ VariableStatus WRITTEN_AFTER_READ = new VariableStatus(2);
        public static final /* enum */ VariableStatus ONLY_WRITTEN_NEVER_READ = new VariableStatus(1);
        public static final /* enum */ VariableStatus UNUSED = new VariableStatus(0);
        private static final /* synthetic */ VariableStatus[] $VALUES;

        private VariableStatus(int priority) {
            this.priority = priority;
        }

        public final boolean isRead() {
            return this.isRead;
        }

        public final void setRead(boolean bl) {
            this.isRead = bl;
        }

        public final boolean isRedundantInit() {
            return this.isRedundantInit;
        }

        public final void setRedundantInit(boolean bl) {
            this.isRedundantInit = bl;
        }

        @NotNull
        public final VariableStatus merge(@Nullable VariableStatus variableUseState) {
            VariableStatus variableStatus;
            VariableStatus base;
            VariableStatus variableStatus2 = base = variableUseState == null || this.priority > variableUseState.priority ? this : variableUseState;
            boolean bl = false;
            boolean bl2 = false;
            VariableStatus it = variableStatus2;
            boolean bl3 = false;
            it.setRead(this.isRead() || Intrinsics.areEqual((Object)((variableStatus = variableUseState) == null ? null : Boolean.valueOf(variableStatus.isRead())), (Object)true));
            it.setRedundantInit(this.isRedundantInit() && Intrinsics.areEqual((Object)((variableStatus = variableUseState) == null ? null : Boolean.valueOf(variableStatus.isRedundantInit())), (Object)true));
            return variableStatus2;
        }

        public static VariableStatus[] values() {
            VariableStatus[] variableStatusArray = $VALUES;
            VariableStatus[] variableStatusArray2 = new VariableStatus[variableStatusArray.length];
            System.arraycopy(variableStatusArray, 0, variableStatusArray2, 0, variableStatusArray.length);
            return variableStatusArray2;
        }

        public static VariableStatus valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(VariableStatus.class, value2);
        }

        static {
            VariableStatus[] variableStatusArray = new VariableStatus[]{READ, WRITTEN_AFTER_READ, ONLY_WRITTEN_NEVER_READ, UNUSED};
            $VALUES = variableStatusArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0016R,\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "map", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentMap;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "merge", "other", "Companion", "checkers"})
    public static final class VariableStatusInfo
    extends ControlFlowInfo<VariableStatusInfo, FirPropertySymbol, VariableStatus> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<FirPropertySymbol, ? extends VariableStatus>, VariableStatusInfo> constructor;
        @NotNull
        private final Function0<VariableStatusInfo> empty;
        @NotNull
        private static final VariableStatusInfo EMPTY = new VariableStatusInfo(null, 1, null);

        public VariableStatusInfo(@NotNull PersistentMap<FirPropertySymbol, ? extends VariableStatus> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ VariableStatusInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<FirPropertySymbol, ? extends VariableStatus>, VariableStatusInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<VariableStatusInfo> getEmpty() {
            return this.empty;
        }

        @Override
        @NotNull
        public VariableStatusInfo merge(@NotNull VariableStatusInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            VariableStatusInfo result2 = this;
            for (FirPropertySymbol symbol2 : CollectionsKt.union((Iterable)this.keySet(), (Iterable)other.keySet())) {
                VariableStatus variableStatus = (VariableStatus)((Object)this.get(symbol2));
                VariableStatus kind1 = variableStatus == null ? VariableStatus.UNUSED : variableStatus;
                VariableStatus variableStatus2 = (VariableStatus)((Object)other.get(symbol2));
                VariableStatus kind2 = variableStatus2 == null ? VariableStatus.UNUSED : variableStatus2;
                VariableStatus variableStatus3 = kind1.merge(kind2);
                result2 = (VariableStatusInfo)result2.put(symbol2, (Object)variableStatus3);
            }
            return result2;
        }

        public VariableStatusInfo() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final VariableStatusInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u001e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u001e\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$ValueWritesWithoutReading;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Ljava/util/Set;)V", "getData", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "visitNode", "node", "data", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class ValueWritesWithoutReading
    extends ControlFlowGraphVisitor<VariableStatusInfo, Collection<? extends VariableStatusInfo>> {
        @NotNull
        private final Set<FirPropertySymbol> localProperties;

        public ValueWritesWithoutReading(@NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            this.localProperties = localProperties;
        }

        @NotNull
        public final Map<CFGNode<?>, VariableStatusInfo> getData(@NotNull ControlFlowGraph graph2) {
            Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
            return CfgTraverserKt.collectDataForNode(graph2, TraverseDirection.Backward, (ControlFlowInfo)VariableStatusInfo.Companion.getEMPTY(), this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VariableStatusInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<VariableStatusInfo> data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (data.isEmpty()) {
                return VariableStatusInfo.Companion.getEMPTY();
            }
            Iterable $this$reduce$iv = data;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                VariableStatusInfo variableStatusInfo = (VariableStatusInfo)iterator$iv.next();
                VariableStatusInfo p0 = (VariableStatusInfo)accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.merge((VariableStatusInfo)p1);
            }
            return (VariableStatusInfo)accumulator$iv;
        }

        @Override
        @NotNull
        public VariableStatusInfo visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull Collection<VariableStatusInfo> data) {
            VariableStatusInfo variableStatusInfo;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            VariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirSourceElement firSourceElement = node.getFir().getSource();
            if ((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind) {
                return dataForNode;
            }
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            VariableStatus variableStatus = (VariableStatus)((Object)dataForNode.get(symbol2));
            int n = variableStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[variableStatus.ordinal()];
            switch (n) {
                case -1: {
                    variableStatusInfo = (VariableStatusInfo)dataForNode.put(symbol2, (Object)VariableStatus.UNUSED);
                    break;
                }
                case 1: 
                case 2: {
                    VariableStatus variableStatus2;
                    if (node.getFir().getInitializer() != null && Intrinsics.areEqual((Object)((variableStatus2 = (VariableStatus)((Object)dataForNode.get(symbol2))) == null ? null : Boolean.valueOf(variableStatus2.isRead())), (Object)true)) {
                        VariableStatus variableStatus3 = (VariableStatus)((Object)dataForNode.get(symbol2));
                        VariableStatus newData = variableStatus3 == null ? VariableStatus.UNUSED : variableStatus3;
                        newData.setRedundantInit(true);
                        variableStatusInfo = (VariableStatusInfo)dataForNode.put(symbol2, (Object)newData);
                        break;
                    }
                    if (node.getFir().getInitializer() != null) {
                        variableStatusInfo = (VariableStatusInfo)dataForNode.put(symbol2, (Object)VariableStatus.ONLY_WRITTEN_NEVER_READ);
                        break;
                    }
                    variableStatusInfo = dataForNode;
                    break;
                }
                case 3: {
                    variableStatusInfo = (VariableStatusInfo)dataForNode.put(symbol2, (Object)VariableStatus.READ);
                    break;
                }
                default: {
                    variableStatusInfo = dataForNode;
                }
            }
            return variableStatusInfo;
        }

        @Override
        @NotNull
        public VariableStatusInfo visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull Collection<VariableStatusInfo> data) {
            FirResolvedNamedReference firResolvedNamedReference;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            VariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            Object object = node.getFir().getLValue();
            FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            if (firResolvedNamedReference == null) {
                return dataForNode;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            Object object2 = reference.getResolvedSymbol();
            Object object3 = object = object2 instanceof FirPropertySymbol ? (FirPropertySymbol)object2 : null;
            if (object == null) {
                return dataForNode;
            }
            Object symbol2 = object;
            VariableStatus toPut = !this.localProperties.contains(symbol2) ? (VariableStatus)null : (dataForNode.get(symbol2) == VariableStatus.READ ? VariableStatus.WRITTEN_AFTER_READ : (dataForNode.get(symbol2) == VariableStatus.WRITTEN_AFTER_READ ? VariableStatus.ONLY_WRITTEN_NEVER_READ : VariableStatus.ONLY_WRITTEN_NEVER_READ.merge((VariableStatus)((Object)((object2 = (VariableStatus)((Object)dataForNode.get(symbol2))) == null ? VariableStatus.UNUSED : object2)))));
            object2 = toPut;
            if (object2 == null) {
                return dataForNode;
            }
            object2 = (VariableStatus)((Object)dataForNode.get(symbol2));
            toPut.setRead(object2 == null ? false : ((VariableStatus)((Object)object2)).isRead());
            return (VariableStatusInfo)dataForNode.put(symbol2, (Object)toPut);
        }

        @Override
        @NotNull
        public VariableStatusInfo visitQualifiedAccessNode(@NotNull QualifiedAccessNode node, @NotNull Collection<VariableStatusInfo> data) {
            FirResolvedNamedReference firResolvedNamedReference;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            VariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirSourceElement firSourceElement = node.getFir().getSource();
            if ((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind) {
                return dataForNode;
            }
            Object object = node.getFir().getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            if (firResolvedNamedReference == null) {
                return dataForNode;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = reference.getResolvedSymbol();
            Object object2 = object = abstractFirBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)abstractFirBasedSymbol : null;
            if (object == null) {
                return dataForNode;
            }
            Object symbol2 = object;
            if (!this.localProperties.contains(symbol2)) {
                return dataForNode;
            }
            VariableStatus status2 = VariableStatus.READ;
            status2.setRead(true);
            return (VariableStatusInfo)dataForNode.put(symbol2, (Object)status2);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VariableStatus.values().length];
                nArray[VariableStatus.ONLY_WRITTEN_NEVER_READ.ordinal()] = 1;
                nArray[VariableStatus.WRITTEN_AFTER_READ.ordinal()] = 2;
                nArray[VariableStatus.READ.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

