/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

public final class JarUtil {
    private static final Logger LOG = Logger.getInstance(JarUtil.class);

    @Nullable
    public static String getJarAttribute(@NotNull File file2, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(3);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(4);
        }
        return JarUtil.getJarAttributeImpl(file2, null, attribute);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarAttributeImpl(@NotNull File file2, @Nullable String entryName, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(8);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(9);
        }
        if (!file2.canRead()) return null;
        try (JarFile jarFile = new JarFile(file2);){
            Manifest manifest2 = jarFile.getManifest();
            if (manifest2 == null) return null;
            Attributes attributes = entryName != null ? manifest2.getAttributes(entryName) : manifest2.getMainAttributes();
            String string2 = attributes.getValue(attribute);
            return string2;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/JarUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarAttribute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarAttributeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "loadProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

