/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.model.internal.type.ModelType;

public enum ValidationActions implements ValidationAction
{
    NO_OP("file collection"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
        }
    }
    ,
    INPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            File file = ValidationActions.toFile(context, value);
            if (!file.exists()) {
                ValidationActions.reportMissingInput(context, "File", propertyName, file);
            } else if (!file.isFile()) {
                ValidationActions.reportUnexpectedInputKind(context, "File", propertyName, file);
            }
        }
    }
    ,
    INPUT_DIRECTORY_VALIDATOR("directory"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            File directory = ValidationActions.toDirectory(context, value);
            if (!directory.exists()) {
                ValidationActions.reportMissingInput(context, "Directory", propertyName, directory);
            } else if (!directory.isDirectory()) {
                ValidationActions.reportUnexpectedInputKind(context, "Directory", propertyName, directory);
            }
        }
    }
    ,
    OUTPUT_DIRECTORY_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            File directory = ValidationActions.toFile(context, value);
            ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, directory);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, directory, "'" + directory + "' is not a directory");
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, candidate, "'" + directory + "' ancestor '" + candidate + "' is not a directory");
                    return;
                }
            }
        }
    }
    ,
    OUTPUT_DIRECTORIES_VALIDATOR("file collection"){

        @Override
        public void doValidate(String propertyName, Object values, TaskValidationContext context) {
            for (File directory : ValidationActions.toFiles(context, values)) {
                OUTPUT_DIRECTORY_VALIDATOR.validate(propertyName, directory, context);
            }
        }
    }
    ,
    OUTPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            block2: {
                File file;
                block1: {
                    file = ValidationActions.toFile(context, value);
                    ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, file);
                    if (!file.exists()) break block1;
                    if (!file.isDirectory()) break block2;
                    ValidationActions.reportCannotWriteToFile(propertyName, context, "'" + file + "' is not a file");
                    break block2;
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotWriteToFile(propertyName, context, "'" + file + "' ancestor '" + candidate + "' is not a directory");
                    break;
                }
            }
        }
    }
    ,
    OUTPUT_FILES_VALIDATOR("file collection"){

        @Override
        public void doValidate(String propertyName, Object values, TaskValidationContext context) {
            for (File file : ValidationActions.toFiles(context, values)) {
                OUTPUT_FILE_VALIDATOR.validate(propertyName, file, context);
            }
        }
    };

    private final String targetType;

    private static void reportMissingInput(TaskValidationContext context, String kind, String propertyName, File input) {
        context.visitPropertyProblem(problem -> {
            String lowerKind = kind.toLowerCase();
            ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.INPUT_FILE_DOES_NOT_EXIST)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> "specifies " + lowerKind + " '" + input + "' which doesn't exist")).happensBecause("An input file was expected to be present but it doesn't exist")).addPossibleSolution(() -> "Make sure the " + lowerKind + " exists before the task is called")).addPossibleSolution(() -> "Make sure that the task which produces the " + lowerKind + " is declared as an input")).documentedAt("validation_problems", "input_file_does_not_exist");
        });
    }

    private static void reportUnexpectedInputKind(TaskValidationContext context, String kind, String propertyName, File input) {
        context.visitPropertyProblem(problem -> {
            String lowerKind = kind.toLowerCase();
            ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.UNEXPECTED_INPUT_FILE_TYPE)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> lowerKind + " '" + input + "' is not a " + lowerKind)).happensBecause(() -> "Expected an input to be a " + lowerKind + " but it was a " + ValidationActions.actualKindOf(input))).addPossibleSolution(() -> "Use a " + lowerKind + " as an input")).addPossibleSolution(() -> "Declare the input as a " + ValidationActions.actualKindOf(input) + " instead")).documentedAt("validation_problems", "unexpected_input_file_type");
        });
    }

    private static void reportCannotWriteToDirectory(String propertyName, TaskValidationContext context, File directory, String cause) {
        context.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.CANNOT_WRITE_OUTPUT)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription(() -> "is not writable because " + cause)).happensBecause(() -> "Expected '" + directory + "' to be a directory but it's a " + ValidationActions.actualKindOf(directory))).addPossibleSolution("Make sure that the '" + propertyName + "' is configured to a directory")).documentedAt("validation_problems", "cannot_write_output"));
    }

    private static void reportCannotWriteToFile(String propertyName, TaskValidationContext context, String cause) {
        context.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.CANNOT_WRITE_OUTPUT)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription(() -> "is not writable because " + cause)).happensBecause(() -> "Cannot write a file to a location pointing at a directory")).addPossibleSolution(() -> "Configure '" + propertyName + "' to point to a file, not a directory")).documentedAt("validation_problems", "cannot_write_output"));
    }

    private static String actualKindOf(File input) {
        if (input.isFile()) {
            return "file";
        }
        if (input.isDirectory()) {
            return "directory";
        }
        return "unexpected file type";
    }

    private static void validateNotInReservedFileSystemLocation(String propertyName, TaskValidationContext context, File location) {
        if (context.isInReservedFileSystemLocation(location)) {
            context.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.CANNOT_WRITE_TO_RESERVED_LOCATION)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> "points to '" + location + "' which is managed by Gradle")).happensBecause("Trying to write an output to a read-only location which is for Gradle internal use only")).addPossibleSolution("Select a different output location")).documentedAt("validation_problems", "cannot_write_to_reserved_location"));
        }
    }

    private ValidationActions(String targetType) {
        this.targetType = targetType;
    }

    protected abstract void doValidate(String var1, Object var2, TaskValidationContext var3);

    @Override
    public void validate(String propertyName, Object value, TaskValidationContext context) {
        try {
            this.doValidate(propertyName, value, context);
        }
        catch (UnsupportedNotationException ignored) {
            context.visitPropertyProblem(problem -> {
                ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.UNSUPPORTED_NOTATION)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> "has unsupported value '" + value + "'")).happensBecause(() -> "Type '" + ValidationActions.typeOf(value) + "' cannot be converted to a " + this.targetType);
                Collection candidates = ignored.getCandidates();
                if (candidates.isEmpty()) {
                    problem.addPossibleSolution(() -> "Use a value of type '" + this.targetType + "'");
                } else {
                    candidates.forEach(candidate -> problem.addPossibleSolution(() -> ValidationActions.toCandidateSolution(candidate)));
                }
                problem.documentedAt("validation_problems", "unsupported_notation");
            });
        }
    }

    private static String typeOf(@Nullable Object instance) {
        if (instance == null) {
            return Object.class.getSimpleName();
        }
        if (instance instanceof GeneratedSubclass) {
            return ModelType.of((Class)((GeneratedSubclass)instance).publicType()).getDisplayName();
        }
        return ModelType.typeOf((Object)instance).getDisplayName();
    }

    private static String toCandidateSolution(String conversionCandidate) {
        String result = StringUtils.uncapitalize((String)conversionCandidate);
        if (result.endsWith(".")) {
            result = result.substring(0, result.lastIndexOf("."));
        }
        return "Use " + result;
    }

    private static File toDirectory(TaskValidationContext context, Object value) {
        if (value instanceof ConfigurableFileTree) {
            return ((ConfigurableFileTree)value).getDir();
        }
        return ValidationActions.toFile(context, value);
    }

    private static File toFile(TaskValidationContext context, Object value) {
        return context.getFileOperations().file(value);
    }

    private static Iterable<? extends File> toFiles(TaskValidationContext context, Object value) {
        if (value instanceof Map) {
            return ValidationActions.toFiles(context, ((Map)value).values());
        }
        if (value instanceof FileCollection) {
            return (FileCollection)value;
        }
        return context.getFileOperations().immutableFiles(value);
    }
}

