/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.compiler.java;

import com.sun.source.util.JavacTask;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import org.gradle.internal.compiler.java.ClassNameCollector;

public class IncrementalCompileTask
implements JavaCompiler.CompilationTask {
    private final Function<File, Optional<String>> relativize;
    private final Consumer<Map<String, Collection<String>>> onComplete;
    private final JavacTask delegate;

    public IncrementalCompileTask(JavaCompiler.CompilationTask delegate, Function<File, Optional<String>> relativize, Consumer<Map<String, Collection<String>>> onComplete) {
        this.relativize = relativize;
        this.onComplete = onComplete;
        if (!(delegate instanceof JavacTask)) {
            throw new UnsupportedOperationException("Unexpected Java compile task : " + delegate.getClass().getName());
        }
        this.delegate = (JavacTask)delegate;
    }

    @Override
    public void addModules(Iterable<String> moduleNames) {
        this.delegate.addModules(moduleNames);
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        this.delegate.setProcessors(processors);
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    @Override
    public Boolean call() {
        ClassNameCollector collector = new ClassNameCollector(this.relativize, this.delegate.getElements());
        this.delegate.addTaskListener(collector);
        try {
            Boolean bl = this.delegate.call();
            return bl;
        }
        finally {
            this.onComplete.accept(collector.getMapping());
        }
    }
}

