/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ValidatingArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;

public class FailOnVersionConflictArtifactsVisitor
implements ValidatingArtifactsVisitor {
    private final Set<Pair<List<? extends ModuleVersionIdentifier>, String>> allConflicts = Sets.newLinkedHashSet();
    private final String projectPath;
    private final String configurationName;

    public FailOnVersionConflictArtifactsVisitor(String projectPath, String configurationName) {
        this.projectPath = projectPath;
        this.configurationName = configurationName;
    }

    @Override
    public void startArtifacts(RootGraphNode root) {
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent owner = node.getOwner();
        ComponentSelectionReason selectionReason = owner.getSelectionReason();
        if (selectionReason.isConflictResolution()) {
            this.allConflicts.add(this.buildConflict(owner, selectionReason));
        }
    }

    private Pair<List<? extends ModuleVersionIdentifier>, String> buildConflict(DependencyGraphComponent owner, ComponentSelectionReason selectionReason) {
        ModuleIdentifier module = owner.getModuleVersion().getModule();
        return Pair.of((Object)ImmutableList.copyOf(owner.getAllVersions()), (Object)this.buildConflictMessage(module, selectionReason));
    }

    private String buildConflictMessage(ModuleIdentifier owner, ComponentSelectionReason selectionReason) {
        String conflictDescription = null;
        for (ComponentSelectionDescriptor description : selectionReason.getDescriptions()) {
            if (!description.getCause().equals((Object)ComponentSelectionCause.CONFLICT_RESOLUTION)) continue;
            conflictDescription = description.getDescription();
        }
        assert (conflictDescription != null);
        return owner.getGroup() + ":" + owner.getName() + " " + conflictDescription;
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
    }

    @Override
    public void finishArtifacts() {
    }

    @Override
    public void complete() {
        if (!this.allConflicts.isEmpty()) {
            throw new VersionConflictException(this.projectPath, this.configurationName, this.allConflicts);
        }
    }
}

