/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.gradle.cache.Cache;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredExecutionAwareStep;
import org.gradle.internal.execution.DeferredExecutionHandler;
import org.gradle.internal.execution.ExecutionRequestContext;
import org.gradle.internal.execution.IdentityContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.InputUtil;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class IdentifyStep<C extends ExecutionRequestContext, R extends Result>
implements DeferredExecutionAwareStep<C, R> {
    private final DeferredExecutionAwareStep<? super IdentityContext, R> delegate;
    private final ValueSnapshotter valueSnapshotter;

    public IdentifyStep(ValueSnapshotter valueSnapshotter, DeferredExecutionAwareStep<? super IdentityContext, R> delegate) {
        this.valueSnapshotter = valueSnapshotter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, this.createIdentityContext(work, context));
    }

    @Override
    public <T, O> T executeDeferred(UnitOfWork work, C context, Cache<UnitOfWork.Identity, Try<O>> cache, DeferredExecutionHandler<O, T> handler) {
        return this.delegate.executeDeferred(work, this.createIdentityContext(work, context), cache, handler);
    }

    @Nonnull
    private IdentityContext createIdentityContext(UnitOfWork work, C context) {
        InputUtil.Result inputs = InputUtil.fingerprintInputProperties(work, (ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), this.valueSnapshotter, (ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)ImmutableSortedMap.of(), (propertyName, type, identity) -> identity == UnitOfWork.IdentityKind.IDENTITY);
        ImmutableSortedMap<String, ValueSnapshot> identityInputProperties = inputs.getValueSnapshots();
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> identityInputFileProperties = inputs.getFileFingerprints();
        UnitOfWork.Identity identity2 = work.identify((Map<String, ValueSnapshot>)identityInputProperties, (Map<String, CurrentFileCollectionFingerprint>)identityInputFileProperties);
        return new IdentityContext((ExecutionRequestContext)context, (ImmutableSortedMap)identityInputProperties, (ImmutableSortedMap)identityInputFileProperties, identity2){
            final /* synthetic */ ExecutionRequestContext val$context;
            final /* synthetic */ ImmutableSortedMap val$identityInputProperties;
            final /* synthetic */ ImmutableSortedMap val$identityInputFileProperties;
            final /* synthetic */ UnitOfWork.Identity val$identity;
            {
                this.val$context = executionRequestContext;
                this.val$identityInputProperties = immutableSortedMap;
                this.val$identityInputFileProperties = immutableSortedMap2;
                this.val$identity = identity;
            }

            @Override
            public Optional<String> getRebuildReason() {
                return this.val$context.getRebuildReason();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$identityInputProperties;
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$identityInputFileProperties;
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$identity;
            }
        };
    }
}

