/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.NamespaceBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public abstract class CppProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final TemplateOperationFactory templateOperationFactory;
    private final DocumentationRegistry documentationRegistry;

    public CppProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, DocumentationRegistry documentationRegistry) {
        this.templateOperationFactory = templateOperationFactory;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public Language getLanguage() {
        return Language.CPP;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.fileComment("This generated file contains a sample C++ project to get you started.").fileComment("For more details take a look at the Building C++ applications and libraries chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("building_cpp_projects"));
        this.configureBuildScript(settings, buildScriptBuilder);
    }

    @Override
    public void generateConventionPluginBuildScript(String conventionPluginName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public void generateSources(InitSettings settings, TemplateFactory templateFactory) {
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(settings);
        TemplateOperation headerTemplate = this.headerTemplateOperation(settings);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(settings);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, headerTemplate, testSourceTemplate).generate();
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Sets.newHashSet();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return null;
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getSampleFor("building_cpp_" + this.getComponentType().pluralName()));
    }

    protected abstract TemplateOperation sourceTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation headerTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation testTemplateOperation(InitSettings var1);

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    protected String getHostTargetMachineDefinition() {
        DefaultNativePlatform host = DefaultNativePlatform.host();
        String definition = "machines.";
        definition = host.getOperatingSystem().isWindows() ? definition + "windows" : (host.getOperatingSystem().isMacOsX() ? definition + "macOS" : (host.getOperatingSystem().isLinux() ? definition + "linux" : definition + "os('" + host.getOperatingSystem().toFamilyName() + "')"));
        definition = definition + ".";
        definition = host.getArchitecture().isI386() ? definition + "x86" : (host.getArchitecture().isAmd64() ? definition + "x86_64" : definition + "architecture('" + host.getArchitecture().getName() + "')");
        return definition;
    }

    TemplateOperation fromCppTemplate(String template, InitSettings settings, String sourceSetName, String sourceDir) {
        String targetFileName = template.substring(template.lastIndexOf("/") + 1).replace(".template", "");
        return this.fromCppTemplate(template, targetFileName, settings, sourceSetName, sourceDir);
    }

    TemplateOperation fromCppTemplate(String template, String targetFileName, InitSettings settings, String sourceSetName, String sourceDir) {
        if (settings == null || settings.getProjectName().isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be empty for a C++ project");
        }
        String namespace = NamespaceBuilder.toNamespace(settings.getProjectName());
        return this.templateOperationFactory.newTemplateOperation().withTemplate(template).withTarget(settings.getTarget().file(settings.getSubprojects().get(0) + "/src/" + sourceSetName + "/" + sourceDir + "/" + targetFileName).getAsFile()).withBinding("projectName", settings.getProjectName()).withBinding("namespace", namespace).create();
    }
}

