/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemUtilContext;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.MutableVariableWithConstraints$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.model.OnlyInputTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.model.DefinitelyNotNullTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tB+\b\u0002\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ*\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\f2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0 H\u0002J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0002J!\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e0(H\u0000\u00a2\u0006\u0002\b)J!\u0010*\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e0(H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020-H\u0016J\f\u0010.\u001a\u00020\u001e*\u00020\fH\u0002J\u0014\u0010/\u001a\u00020\u001e*\u00020\f2\u0006\u0010\b\u001a\u00020\fH\u0002J\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u0011*\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u0011*\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\u0018\u00102\u001a\b\u0012\u0004\u0012\u00020\f0\u0011*\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\f0\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/model/MutableVariableWithConstraints;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Context;", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;)V", "other", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;)V", "constraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "(Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;Ljava/util/List;)V", "getConstraints", "()Ljava/util/List;", "mutableConstraints", "Lorg/jetbrains/kotlin/utils/SmartList;", "kotlin.jvm.PlatformType", "simplifiedConstraints", "getTypeVariable", "()Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "addConstraint", "constraint", "getProjectedInputCallTypes", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "utilContext", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemUtilContext;", "isUsefulConstraint", "", "equalityConstraints", "", "", "newConstraintIsUseless", "old", "new", "removeConstrains", "", "shouldRemove", "Lkotlin/Function1;", "removeConstrains$resolution_common", "removeLastConstraints", "removeLastConstraints$resolution_common", "toString", "", "isLowerAndFlexibleTypeWithDefNotNullLowerBound", "isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound", "simplifyConstraints", "simplifyEqualityConstraints", "simplifyLowerConstraints", "resolution.common"})
public final class MutableVariableWithConstraints
implements VariableWithConstraints {
    private final SmartList<Constraint> mutableConstraints;
    private SmartList<Constraint> simplifiedConstraints;
    private final TypeSystemInferenceExtensionContext context;
    private final TypeVariableMarker typeVariable;

    @Override
    @NotNull
    public List<Constraint> getConstraints() {
        if (this.simplifiedConstraints == null) {
            this.simplifiedConstraints = this.simplifyConstraints(this.mutableConstraints);
        }
        SmartList<Constraint> smartList = this.simplifiedConstraints;
        Intrinsics.checkNotNull(smartList);
        return smartList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<KotlinTypeMarker> getProjectedInputCallTypes(@NotNull ConstraintSystemUtilContext utilContext) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)utilContext, (String)"utilContext");
        boolean bl = false;
        boolean bl2 = false;
        ConstraintSystemUtilContext $this$with = utilContext;
        boolean bl3 = false;
        Iterable iterable = this.mutableConstraints;
        Collection destination$iv = new SmartList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTypeMarker kotlinTypeMarker;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            Constraint it = (Constraint)element$iv;
            boolean bl5 = false;
            if ((it.getPosition().getFrom() instanceof OnlyInputTypeConstraintPosition || it.getInputTypePositionBeforeIncorporation() != null ? $this$with.unCapture(it.getType()) : null) == null) continue;
            kotlinTypeMarker = kotlinTypeMarker;
            boolean bl6 = false;
            boolean bl7 = false;
            KotlinTypeMarker it$iv = kotlinTypeMarker;
            boolean bl8 = false;
            destination$iv.add(it$iv);
        }
        return (SmartList)destination$iv;
    }

    @Nullable
    public final Constraint addConstraint(@NotNull Constraint constraint) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        boolean isLowerAndFlexibleTypeWithDefNotNullLowerBound = this.isLowerAndFlexibleTypeWithDefNotNullLowerBound(constraint);
        for (Constraint previousConstraint : this.getConstraints()) {
            if (previousConstraint.getTypeHashCode() == constraint.getTypeHashCode() && Intrinsics.areEqual((Object)previousConstraint.getType(), (Object)constraint.getType()) && previousConstraint.isNullabilityConstraint() == constraint.isNullabilityConstraint()) {
                boolean bl;
                if (this.newConstraintIsUseless(previousConstraint, constraint)) {
                    return null;
                }
                switch (MutableVariableWithConstraints$WhenMappings.$EnumSwitchMapping$0[previousConstraint.getKind().ordinal()]) {
                    case 1: {
                        bl = constraint.getKind().isUpper();
                        break;
                    }
                    case 2: {
                        bl = constraint.getKind().isLower();
                        break;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean isMatchingForSimplification = bl;
                if (isMatchingForSimplification) {
                    Constraint actualConstraint = new Constraint(ConstraintKind.EQUALITY, constraint.getType(), constraint.getPosition(), constraint.getTypeHashCode(), constraint.getDerivedFrom(), false, null, 64, null);
                    this.mutableConstraints.add(actualConstraint);
                    this.simplifiedConstraints = null;
                    return actualConstraint;
                }
            }
            if (!isLowerAndFlexibleTypeWithDefNotNullLowerBound || !this.isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound(previousConstraint, constraint)) continue;
            return null;
        }
        this.mutableConstraints.add(constraint);
        if (this.simplifiedConstraints != null && this.simplifiedConstraints != this.mutableConstraints) {
            SmartList<Constraint> smartList = this.simplifiedConstraints;
            Intrinsics.checkNotNull(smartList);
            smartList.add(constraint);
        }
        if (this.simplifiedConstraints != null && isLowerAndFlexibleTypeWithDefNotNullLowerBound) {
            this.simplifiedConstraints = null;
        }
        return constraint;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLastConstraints$resolution_common(@NotNull Function1<? super Constraint, Boolean> shouldRemove2) {
        int n;
        List list2;
        block2: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter(shouldRemove2, (String)"shouldRemove");
            List list3 = this.mutableConstraints;
            list2 = this.mutableConstraints;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Constraint it = (Constraint)iterator$iv.previous();
                boolean bl = false;
                Constraint constraint = it;
                Intrinsics.checkNotNullExpressionValue((Object)constraint, (String)"it");
                if (!((Boolean)shouldRemove2.invoke((Object)constraint) == false)) continue;
                n = iterator$iv.nextIndex();
                break block2;
            }
            n = -1;
        }
        int n2 = n;
        AddToStdlibKt.trimToSize(list2, n2 + 1);
        if (this.simplifiedConstraints != this.mutableConstraints) {
            this.simplifiedConstraints = null;
        }
    }

    public final void removeConstrains$resolution_common(@NotNull Function1<? super Constraint, Boolean> shouldRemove2) {
        Intrinsics.checkNotNullParameter(shouldRemove2, (String)"shouldRemove");
        CollectionsKt.removeAll((List)this.mutableConstraints, shouldRemove2);
        if (this.simplifiedConstraints != this.mutableConstraints) {
            this.simplifiedConstraints = null;
        }
    }

    private final boolean newConstraintIsUseless(Constraint old, Constraint constraint) {
        boolean bl;
        if (old.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition && !(constraint.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition)) {
            return false;
        }
        switch (MutableVariableWithConstraints$WhenMappings.$EnumSwitchMapping$1[old.getKind().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = constraint.getKind().isLower();
                break;
            }
            case 3: {
                bl = constraint.getKind().isUpper();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final SmartList<Constraint> simplifyConstraints(SmartList<Constraint> $this$simplifyConstraints) {
        return this.simplifyEqualityConstraints(this.simplifyLowerConstraints($this$simplifyConstraints));
    }

    private final SmartList<Constraint> simplifyLowerConstraints(SmartList<Constraint> $this$simplifyLowerConstraints) {
        SmartList<Constraint> usefulConstraints = new SmartList<Constraint>();
        Iterator<Constraint> iterator2 = $this$simplifyLowerConstraints.iterator();
        while (iterator2.hasNext()) {
            boolean thereIsStrongerConstraint;
            boolean bl;
            Constraint constraint;
            block5: {
                Constraint constraint2 = constraint = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)constraint2, (String)"constraint");
                if (!this.isLowerAndFlexibleTypeWithDefNotNullLowerBound(constraint2)) {
                    usefulConstraints.add(constraint);
                    continue;
                }
                Iterable $this$any$iv = $this$simplifyLowerConstraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl2 = false;
                        Constraint constraint3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)constraint3, (String)"it");
                        if (!this.isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound(constraint3, constraint)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (thereIsStrongerConstraint = bl) continue;
            usefulConstraints.add(constraint);
        }
        return usefulConstraints;
    }

    private final boolean isLowerAndFlexibleTypeWithDefNotNullLowerBound(Constraint $this$isLowerAndFlexibleTypeWithDefNotNullLowerBound) {
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = this.context;
        boolean bl = false;
        boolean bl2 = false;
        TypeSystemInferenceExtensionContext $this$with = typeSystemInferenceExtensionContext;
        boolean bl3 = false;
        return $this$isLowerAndFlexibleTypeWithDefNotNullLowerBound.getKind() == ConstraintKind.LOWER && $this$with.isFlexible($this$isLowerAndFlexibleTypeWithDefNotNullLowerBound.getType()) && $this$with.isDefinitelyNotNullType($this$with.lowerBoundIfFlexible($this$isLowerAndFlexibleTypeWithDefNotNullLowerBound.getType()));
    }

    private final boolean isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound(Constraint $this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound, Constraint other) {
        if ($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound == other) {
            return false;
        }
        if ($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getTypeHashCode() != other.getTypeHashCode() || $this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getKind() == ConstraintKind.UPPER) {
            return false;
        }
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = this.context;
        boolean bl = false;
        boolean bl2 = false;
        TypeSystemInferenceExtensionContext $this$with = typeSystemInferenceExtensionContext;
        boolean bl3 = false;
        if (!$this$with.isFlexible($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getType()) || !$this$with.isFlexible(other.getType())) {
            return false;
        }
        SimpleTypeMarker otherLowerBound = $this$with.lowerBoundIfFlexible(other.getType());
        if (!$this$with.isDefinitelyNotNullType(otherLowerBound)) {
            return false;
        }
        boolean bl4 = otherLowerBound instanceof DefinitelyNotNullTypeMarker;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        SimpleTypeMarker thisLowerBound = $this$with.lowerBoundIfFlexible($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getType());
        SimpleTypeMarker thisUpperBound = $this$with.upperBoundIfFlexible($this$isStrongerThanLowerAndFlexibleTypeWithDefNotNullLowerBound.getType());
        SimpleTypeMarker otherUpperBound = $this$with.upperBoundIfFlexible(other.getType());
        return Intrinsics.areEqual((Object)thisLowerBound, (Object)$this$with.original((DefinitelyNotNullTypeMarker)otherLowerBound)) && Intrinsics.areEqual((Object)thisUpperBound, (Object)otherUpperBound);
    }

    /*
     * WARNING - void declaration
     */
    private final SmartList<Constraint> simplifyEqualityConstraints(SmartList<Constraint> $this$simplifyEqualityConstraints) {
        SmartList smartList;
        void $this$groupByTo$iv$iv;
        Constraint it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$simplifyEqualityConstraints;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ConstraintKind.EQUALITY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Constraint)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getTypeHashCode();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object equalityConstraints = destination$iv$iv;
        if (equalityConstraints.isEmpty()) {
            smartList = $this$simplifyEqualityConstraints;
        } else {
            void $this$filterTo$iv;
            $this$groupBy$iv = $this$simplifyEqualityConstraints;
            Collection destination$iv = new SmartList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv : $this$filterTo$iv) {
                Constraint it2 = (Constraint)element$iv;
                boolean bl = false;
                Constraint constraint = it2;
                Intrinsics.checkNotNullExpressionValue((Object)constraint, (String)"it");
                if (!this.isUsefulConstraint(constraint, (Map<Integer, ? extends List<Constraint>>)equalityConstraints)) continue;
                destination$iv.add(element$iv);
            }
            smartList = (SmartList)destination$iv;
        }
        return smartList;
    }

    private final boolean isUsefulConstraint(Constraint constraint, Map<Integer, ? extends List<Constraint>> equalityConstraints) {
        boolean bl;
        block6: {
            if (constraint.getKind() == ConstraintKind.EQUALITY) {
                return true;
            }
            List<Constraint> list2 = equalityConstraints.get(constraint.getTypeHashCode());
            if (list2 != null) {
                Iterable $this$none$iv = list2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)constraint.getType())) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "Constraints for " + this.getTypeVariable();
    }

    @Override
    @NotNull
    public TypeVariableMarker getTypeVariable() {
        return this.typeVariable;
    }

    private MutableVariableWithConstraints(TypeSystemInferenceExtensionContext context2, TypeVariableMarker typeVariable2, List<Constraint> constraints) {
        this.context = context2;
        this.typeVariable = typeVariable2;
        this.mutableConstraints = constraints == null ? new SmartList() : new SmartList(constraints);
        this.simplifiedConstraints = this.mutableConstraints;
    }

    public MutableVariableWithConstraints(@NotNull TypeSystemInferenceExtensionContext context2, @NotNull TypeVariableMarker typeVariable2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)typeVariable2, (String)"typeVariable");
        this(context2, typeVariable2, null);
    }

    public MutableVariableWithConstraints(@NotNull TypeSystemInferenceExtensionContext context2, @NotNull VariableWithConstraints other) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this(context2, other.getTypeVariable(), other.getConstraints());
    }
}

