/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.DefaultTaskSelector;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelector;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.util.Path;

public class CompositeAwareTaskSelector
extends TaskSelector {
    private final GradleInternal gradle;
    private final BuildStateRegistry buildStateRegistry;
    private final ProjectConfigurer projectConfigurer;
    private final TaskNameResolver taskNameResolver;

    public CompositeAwareTaskSelector(GradleInternal gradle, BuildStateRegistry buildStateRegistry, ProjectConfigurer projectConfigurer, TaskNameResolver taskNameResolver) {
        this.gradle = gradle;
        this.buildStateRegistry = buildStateRegistry;
        this.projectConfigurer = projectConfigurer;
        this.taskNameResolver = taskNameResolver;
    }

    @Override
    public Spec<Task> getFilter(String path) {
        BuildState build;
        Path taskPath = Path.path((String)path);
        if (taskPath.isAbsolute() && (build = this.findIncludedBuild(taskPath)) != null) {
            return this.getSelector(build).getFilter(taskPath.removeFirstSegments(1).toString());
        }
        if (this.gradle.isRootBuild()) {
            return this.getUnqualifiedBuildSelector().getFilter(path);
        }
        return Specs.satisfyAll();
    }

    @Override
    public TaskSelection getSelection(String path) {
        BuildState build;
        Path taskPath;
        if (this.gradle.isRootBuild() && (taskPath = Path.path((String)path)).isAbsolute() && (build = this.findIncludedBuild(taskPath)) != null) {
            return this.getSelector(build).getSelection(taskPath.removeFirstSegments(1).toString());
        }
        return this.getUnqualifiedBuildSelector().getSelection(path);
    }

    @Override
    public TaskSelection getSelection(String projectPath, File root, String path) {
        Path taskPath;
        if (this.gradle.isRootBuild() && (taskPath = Path.path((String)path)).isAbsolute()) {
            BuildState build = this.findIncludedBuild(taskPath);
            if (build != null) {
                return this.getSelector(build).getSelection(projectPath, root, taskPath.removeFirstSegments(1).toString());
            }
            build = this.findIncludedBuild(root);
            if (build != null) {
                return this.getSelector(build).getSelection(projectPath, root, path);
            }
        }
        return this.getUnqualifiedBuildSelector().getSelection(projectPath, root, path);
    }

    private BuildState findIncludedBuild(Path taskPath) {
        if (this.buildStateRegistry.getIncludedBuilds().isEmpty() || taskPath.segmentCount() <= 1) {
            return null;
        }
        String buildName = taskPath.segment(0);
        for (IncludedBuildState includedBuildState : this.buildStateRegistry.getIncludedBuilds()) {
            if (!includedBuildState.getName().equals(buildName)) continue;
            return includedBuildState;
        }
        return null;
    }

    private BuildState findIncludedBuild(File root) {
        if (root == null) {
            return null;
        }
        for (IncludedBuildState includedBuildState : this.buildStateRegistry.getIncludedBuilds()) {
            if (!includedBuildState.getRootDirectory().equals(root)) continue;
            return includedBuildState;
        }
        return null;
    }

    private TaskSelector getSelector(BuildState buildState) {
        return new DefaultTaskSelector(buildState.getBuild(), this.taskNameResolver, this.projectConfigurer);
    }

    private TaskSelector getUnqualifiedBuildSelector() {
        return this.getSelector(this.gradle.getOwner());
    }
}

