/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimageundo_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimageundo
 * @title: gimpimageundo
 * @short_description: Control of image undo/redo.
 *
 * Control of image undo/redo.
 **/


/**
 * gimp_image_undo_group_start:
 * @image: The ID of the image in which to open an undo group.
 *
 * Starts a group undo.
 *
 * This function is used to start a group undo--necessary for logically
 * combining two or more undo operations into a single operation. This
 * call must be used in conjunction with a gimp_image_undo_group_end()
 * call.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_undo_group_start (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-group-start",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_undo_group_end:
 * @image: The ID of the image in which to close an undo group.
 *
 * Finish a group undo.
 *
 * This function must be called once for each
 * gimp_image_undo_group_start() call that is made.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_undo_group_end (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-group-end",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_undo_is_enabled:
 * @image: The image.
 *
 * Check if the image's undo stack is enabled.
 *
 * This procedure checks if the image's undo stack is currently enabled
 * or disabled. This is useful when several plug-ins or scripts call
 * each other and want to check if their caller has already used
 * gimp_image_undo_disable() or gimp_image_undo_freeze().
 *
 * Returns: TRUE if undo is enabled for this image.
 **/
gboolean
gimp_image_undo_is_enabled (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean enabled = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-is-enabled",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    enabled = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return enabled;
}

/**
 * gimp_image_undo_disable:
 * @image: The image.
 *
 * Disable the image's undo stack.
 *
 * This procedure disables the image's undo stack, allowing subsequent
 * operations to ignore their undo steps. This is generally called in
 * conjunction with gimp_image_undo_enable() to temporarily disable an
 * image undo stack. This is advantageous because saving undo steps can
 * be time and memory intensive.
 *
 * Returns: TRUE if the image undo has been disabled.
 **/
gboolean
gimp_image_undo_disable (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean disabled = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-disable",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    disabled = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return disabled;
}

/**
 * gimp_image_undo_enable:
 * @image: The image.
 *
 * Enable the image's undo stack.
 *
 * This procedure enables the image's undo stack, allowing subsequent
 * operations to store their undo steps. This is generally called in
 * conjunction with gimp_image_undo_disable() to temporarily disable an
 * image undo stack.
 *
 * Returns: TRUE if the image undo has been enabled.
 **/
gboolean
gimp_image_undo_enable (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean enabled = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-enable",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    enabled = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return enabled;
}

/**
 * gimp_image_undo_freeze:
 * @image: The image.
 *
 * Freeze the image's undo stack.
 *
 * This procedure freezes the image's undo stack, allowing subsequent
 * operations to ignore their undo steps. This is generally called in
 * conjunction with gimp_image_undo_thaw() to temporarily disable an
 * image undo stack. This is advantageous because saving undo steps can
 * be time and memory intensive. gimp_image_undo_freeze() /
 * gimp_image_undo_thaw() and gimp_image_undo_disable() /
 * gimp_image_undo_enable() differ in that the former does not free up
 * all undo steps when undo is thawed, so is more suited to interactive
 * in-situ previews. It is important in this case that the image is
 * back to the same state it was frozen in before thawing, else 'undo'
 * behaviour is undefined.
 *
 * Returns: TRUE if the image undo has been frozen.
 **/
gboolean
gimp_image_undo_freeze (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean frozen = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-freeze",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    frozen = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return frozen;
}

/**
 * gimp_image_undo_thaw:
 * @image: The image.
 *
 * Thaw the image's undo stack.
 *
 * This procedure thaws the image's undo stack, allowing subsequent
 * operations to store their undo steps. This is generally called in
 * conjunction with gimp_image_undo_freeze() to temporarily freeze an
 * image undo stack. gimp_image_undo_thaw() does NOT free the undo
 * stack as gimp_image_undo_enable() does, so is suited for situations
 * where one wishes to leave the undo stack in the same state in which
 * one found it despite non-destructively playing with the image in the
 * meantime. An example would be in-situ plug-in previews. Balancing
 * freezes and thaws and ensuring image consistency is the
 * responsibility of the caller.
 *
 * Returns: TRUE if the image undo has been thawed.
 **/
gboolean
gimp_image_undo_thaw (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean thawed = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-undo-thaw",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    thawed = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return thawed;
}
