/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.util.ViewUtils;
import io.flutter.view.TextureRegistry;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=23)
class PlatformViewWrapper
extends FrameLayout {
    private static final String TAG = "PlatformViewWrapper";
    private int prevLeft;
    private int prevTop;
    private int left;
    private int top;
    private int bufferWidth;
    private int bufferHeight;
    private SurfaceTexture tx;
    private Surface surface;
    private AndroidTouchProcessor touchProcessor;
    @Nullable
    @VisibleForTesting
    ViewTreeObserver.OnGlobalFocusChangeListener activeFocusListener;
    private final AtomicLong pendingFramesCount = new AtomicLong(0L);
    private final TextureRegistry.OnFrameConsumedListener listener = new TextureRegistry.OnFrameConsumedListener(){

        @Override
        public void onFrameConsumed() {
            if (Build.VERSION.SDK_INT == 29) {
                PlatformViewWrapper.this.pendingFramesCount.decrementAndGet();
            }
        }
    };

    private void onFrameProduced() {
        if (Build.VERSION.SDK_INT == 29) {
            this.pendingFramesCount.incrementAndGet();
        }
    }

    private boolean shouldDrawToSurfaceNow() {
        if (Build.VERSION.SDK_INT == 29) {
            return this.pendingFramesCount.get() <= 0L;
        }
        return true;
    }

    public PlatformViewWrapper(@NonNull Context context) {
        super(context);
        this.setWillNotDraw(false);
    }

    public PlatformViewWrapper(@NonNull Context context, @NonNull TextureRegistry.SurfaceTextureEntry textureEntry) {
        this(context);
        textureEntry.setOnFrameConsumedListener(this.listener);
        this.setTexture(textureEntry.surfaceTexture());
    }

    public void setTouchProcessor(@Nullable AndroidTouchProcessor newTouchProcessor) {
        this.touchProcessor = newTouchProcessor;
    }

    @SuppressLint(value={"NewApi"})
    public void setTexture(@Nullable SurfaceTexture newTx) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.e(TAG, "Platform views cannot be displayed below API level 23. You can prevent this issue by setting `minSdkVersion: 23` in build.gradle.");
            return;
        }
        this.tx = newTx;
        if (this.bufferWidth > 0 && this.bufferHeight > 0) {
            this.tx.setDefaultBufferSize(this.bufferWidth, this.bufferHeight);
        }
        if (this.surface != null) {
            this.surface.release();
        }
        this.surface = this.createSurface(newTx);
        Canvas canvas = this.surface.lockHardwareCanvas();
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                canvas.drawColor(0, BlendMode.CLEAR);
            } else {
                canvas.drawColor(0);
            }
            this.onFrameProduced();
        }
        finally {
            this.surface.unlockCanvasAndPost(canvas);
        }
    }

    @NonNull
    @VisibleForTesting
    protected Surface createSurface(@NonNull SurfaceTexture tx) {
        return new Surface(tx);
    }

    @Nullable
    public SurfaceTexture getTexture() {
        return this.tx;
    }

    public void setLayoutParams(@NonNull FrameLayout.LayoutParams params) {
        super.setLayoutParams((ViewGroup.LayoutParams)params);
        this.left = params.leftMargin;
        this.top = params.topMargin;
    }

    public void setBufferSize(int width, int height) {
        this.bufferWidth = width;
        this.bufferHeight = height;
        if (this.tx != null) {
            this.tx.setDefaultBufferSize(width, height);
        }
    }

    public int getBufferWidth() {
        return this.bufferWidth;
    }

    public int getBufferHeight() {
        return this.bufferHeight;
    }

    public void release() {
        this.tx = null;
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public void onDescendantInvalidated(@NonNull View child, @NonNull View target) {
        super.onDescendantInvalidated(child, target);
        this.invalidate();
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        this.invalidate();
        return super.invalidateChildInParent(location, dirty);
    }

    @SuppressLint(value={"NewApi"})
    public void draw(Canvas canvas) {
        if (this.surface == null) {
            super.draw(canvas);
            Log.e(TAG, "Platform view cannot be composed without a surface.");
            return;
        }
        if (!this.surface.isValid()) {
            Log.e(TAG, "Invalid surface. The platform view cannot be displayed.");
            return;
        }
        if (this.tx == null || this.tx.isReleased()) {
            Log.e(TAG, "Invalid texture. The platform view cannot be displayed.");
            return;
        }
        if (!this.shouldDrawToSurfaceNow()) {
            this.invalidate();
        } else {
            Canvas surfaceCanvas = this.surface.lockHardwareCanvas();
            try {
                if (Build.VERSION.SDK_INT >= 29) {
                    surfaceCanvas.drawColor(0, BlendMode.CLEAR);
                } else {
                    surfaceCanvas.drawColor(0);
                }
                super.draw(surfaceCanvas);
                this.onFrameProduced();
            }
            finally {
                this.surface.unlockCanvasAndPost(surfaceCanvas);
            }
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.touchProcessor == null) {
            return super.onTouchEvent(event);
        }
        Matrix screenMatrix = new Matrix();
        switch (event.getAction()) {
            case 0: {
                this.prevLeft = this.left;
                this.prevTop = this.top;
                screenMatrix.postTranslate((float)this.left, (float)this.top);
                break;
            }
            case 2: {
                screenMatrix.postTranslate((float)this.prevLeft, (float)this.prevTop);
                this.prevLeft = this.left;
                this.prevTop = this.top;
                break;
            }
            default: {
                screenMatrix.postTranslate((float)this.left, (float)this.top);
            }
        }
        return this.touchProcessor.onTouchEvent(event, screenMatrix);
    }

    public void setOnDescendantFocusChangeListener(final @NonNull View.OnFocusChangeListener userFocusListener) {
        this.unsetOnDescendantFocusChangeListener();
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer.isAlive() && this.activeFocusListener == null) {
            this.activeFocusListener = new ViewTreeObserver.OnGlobalFocusChangeListener(){

                public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                    userFocusListener.onFocusChange((View)PlatformViewWrapper.this, ViewUtils.childHasFocus((View)PlatformViewWrapper.this));
                }
            };
            observer.addOnGlobalFocusChangeListener(this.activeFocusListener);
        }
    }

    public void unsetOnDescendantFocusChangeListener() {
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer.isAlive() && this.activeFocusListener != null) {
            ViewTreeObserver.OnGlobalFocusChangeListener currFocusListener = this.activeFocusListener;
            this.activeFocusListener = null;
            observer.removeOnGlobalFocusChangeListener(currFocusListener);
        }
    }
}

