/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.Lifecycle;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.android.ExclusiveAppComponent;
import io.flutter.embedding.android.FlutterEngineConfigurator;
import io.flutter.embedding.android.FlutterEngineProvider;
import io.flutter.embedding.android.FlutterSplashView;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.RenderMode;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.android.SplashScreenProvider;
import io.flutter.embedding.android.TransparencyMode;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterEngineCache;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.util.ViewUtils;
import java.util.Arrays;
import java.util.List;

class FlutterActivityAndFragmentDelegate
implements ExclusiveAppComponent<Activity> {
    private static final String TAG = "FlutterActivityAndFragmentDelegate";
    private static final String FRAMEWORK_RESTORATION_BUNDLE_KEY = "framework";
    private static final String PLUGINS_RESTORATION_BUNDLE_KEY = "plugins";
    private static final int FLUTTER_SPLASH_VIEW_FALLBACK_ID = 486947586;
    @NonNull
    private Host host;
    @Nullable
    private FlutterEngine flutterEngine;
    @VisibleForTesting
    @Nullable
    FlutterView flutterView;
    @Nullable
    private PlatformPlugin platformPlugin;
    @VisibleForTesting
    @Nullable
    ViewTreeObserver.OnPreDrawListener activePreDrawListener;
    private boolean isFlutterEngineFromHost;
    private boolean isFlutterUiDisplayed;
    private boolean isFirstFrameRendered;
    private boolean isAttached;
    @NonNull
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterActivityAndFragmentDelegate.this.host.onFlutterUiDisplayed();
            FlutterActivityAndFragmentDelegate.this.isFlutterUiDisplayed = true;
            FlutterActivityAndFragmentDelegate.this.isFirstFrameRendered = true;
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterActivityAndFragmentDelegate.this.host.onFlutterUiNoLongerDisplayed();
            FlutterActivityAndFragmentDelegate.this.isFlutterUiDisplayed = false;
        }
    };

    FlutterActivityAndFragmentDelegate(@NonNull Host host) {
        this.host = host;
        this.isFirstFrameRendered = false;
    }

    void release() {
        this.host = null;
        this.flutterEngine = null;
        this.flutterView = null;
        this.platformPlugin = null;
    }

    @Nullable
    FlutterEngine getFlutterEngine() {
        return this.flutterEngine;
    }

    boolean isFlutterEngineFromHost() {
        return this.isFlutterEngineFromHost;
    }

    boolean isAttached() {
        return this.isAttached;
    }

    void onAttach(@NonNull Context context) {
        this.ensureAlive();
        if (this.flutterEngine == null) {
            this.setupFlutterEngine();
        }
        if (this.host.shouldAttachEngineToActivity()) {
            Log.v(TAG, "Attaching FlutterEngine to the Activity that owns this delegate.");
            this.flutterEngine.getActivityControlSurface().attachToActivity(this, this.host.getLifecycle());
        }
        this.platformPlugin = this.host.providePlatformPlugin(this.host.getActivity(), this.flutterEngine);
        this.host.configureFlutterEngine(this.flutterEngine);
        this.isAttached = true;
    }

    @Override
    @NonNull
    public Activity getAppComponent() {
        Activity activity = this.host.getActivity();
        if (activity == null) {
            throw new AssertionError((Object)"FlutterActivityAndFragmentDelegate's getAppComponent should only be queried after onAttach, when the host's activity should always be non-null");
        }
        return activity;
    }

    @VisibleForTesting
    void setupFlutterEngine() {
        Log.v(TAG, "Setting up FlutterEngine.");
        String cachedEngineId = this.host.getCachedEngineId();
        if (cachedEngineId != null) {
            this.flutterEngine = FlutterEngineCache.getInstance().get(cachedEngineId);
            this.isFlutterEngineFromHost = true;
            if (this.flutterEngine == null) {
                throw new IllegalStateException("The requested cached FlutterEngine did not exist in the FlutterEngineCache: '" + cachedEngineId + "'");
            }
            return;
        }
        this.flutterEngine = this.host.provideFlutterEngine(this.host.getContext());
        if (this.flutterEngine != null) {
            this.isFlutterEngineFromHost = true;
            return;
        }
        Log.v(TAG, "No preferred FlutterEngine was provided. Creating a new FlutterEngine for this FlutterFragment.");
        this.flutterEngine = new FlutterEngine(this.host.getContext(), this.host.getFlutterShellArgs().toArray(), false, this.host.shouldRestoreAndSaveState());
        this.isFlutterEngineFromHost = false;
    }

    @NonNull
    View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState, int flutterViewId, boolean shouldDelayFirstAndroidViewDraw) {
        Log.v(TAG, "Creating FlutterView.");
        this.ensureAlive();
        if (this.host.getRenderMode() == RenderMode.surface) {
            FlutterSurfaceView flutterSurfaceView = new FlutterSurfaceView(this.host.getContext(), this.host.getTransparencyMode() == TransparencyMode.transparent);
            this.host.onFlutterSurfaceViewCreated(flutterSurfaceView);
            this.flutterView = new FlutterView(this.host.getContext(), flutterSurfaceView);
        } else {
            FlutterTextureView flutterTextureView = new FlutterTextureView(this.host.getContext());
            flutterTextureView.setOpaque(this.host.getTransparencyMode() == TransparencyMode.opaque);
            this.host.onFlutterTextureViewCreated(flutterTextureView);
            this.flutterView = new FlutterView(this.host.getContext(), flutterTextureView);
        }
        this.flutterView.addOnFirstFrameRenderedListener(this.flutterUiDisplayListener);
        Log.v(TAG, "Attaching FlutterEngine to FlutterView.");
        this.flutterView.attachToFlutterEngine(this.flutterEngine);
        this.flutterView.setId(flutterViewId);
        SplashScreen splashScreen = this.host.provideSplashScreen();
        if (splashScreen != null) {
            Log.w(TAG, "A splash screen was provided to Flutter, but this is deprecated. See flutter.dev/go/android-splash-migration for migration steps.");
            FlutterSplashView flutterSplashView = new FlutterSplashView(this.host.getContext());
            flutterSplashView.setId(ViewUtils.generateViewId(486947586));
            flutterSplashView.displayFlutterViewWithSplash(this.flutterView, splashScreen);
            return flutterSplashView;
        }
        if (shouldDelayFirstAndroidViewDraw) {
            this.delayFirstAndroidViewDraw(this.flutterView);
        }
        return this.flutterView;
    }

    void onRestoreInstanceState(@Nullable Bundle bundle) {
        Log.v(TAG, "onRestoreInstanceState. Giving framework and plugins an opportunity to restore state.");
        this.ensureAlive();
        Bundle pluginState = null;
        byte[] frameworkState = null;
        if (bundle != null) {
            pluginState = bundle.getBundle(PLUGINS_RESTORATION_BUNDLE_KEY);
            frameworkState = bundle.getByteArray(FRAMEWORK_RESTORATION_BUNDLE_KEY);
        }
        if (this.host.shouldRestoreAndSaveState()) {
            this.flutterEngine.getRestorationChannel().setRestorationData(frameworkState);
        }
        if (this.host.shouldAttachEngineToActivity()) {
            this.flutterEngine.getActivityControlSurface().onRestoreInstanceState(pluginState);
        }
    }

    void onStart() {
        Log.v(TAG, "onStart()");
        this.ensureAlive();
        this.doInitialFlutterViewRun();
        this.flutterView.setVisibility(0);
    }

    private void doInitialFlutterViewRun() {
        if (this.host.getCachedEngineId() != null) {
            return;
        }
        if (this.flutterEngine.getDartExecutor().isExecutingDart()) {
            return;
        }
        String initialRoute = this.host.getInitialRoute();
        if (initialRoute == null && (initialRoute = this.maybeGetInitialRouteFromIntent(this.host.getActivity().getIntent())) == null) {
            initialRoute = "/";
        }
        String libraryUri = this.host.getDartEntrypointLibraryUri();
        Log.v(TAG, "Executing Dart entrypoint: " + this.host.getDartEntrypointFunctionName() + ", library uri: " + libraryUri == null ? "\"\"" : libraryUri + ", and sending initial route: " + initialRoute);
        this.flutterEngine.getNavigationChannel().setInitialRoute(initialRoute);
        String appBundlePathOverride = this.host.getAppBundlePath();
        if (appBundlePathOverride == null || appBundlePathOverride.isEmpty()) {
            appBundlePathOverride = FlutterInjector.instance().flutterLoader().findAppBundlePath();
        }
        DartExecutor.DartEntrypoint entrypoint = libraryUri == null ? new DartExecutor.DartEntrypoint(appBundlePathOverride, this.host.getDartEntrypointFunctionName()) : new DartExecutor.DartEntrypoint(appBundlePathOverride, libraryUri, this.host.getDartEntrypointFunctionName());
        this.flutterEngine.getDartExecutor().executeDartEntrypoint(entrypoint, this.host.getDartEntrypointArgs());
    }

    private String maybeGetInitialRouteFromIntent(Intent intent) {
        String fullRoute;
        Uri data;
        if (this.host.shouldHandleDeeplinking() && (data = intent.getData()) != null && (fullRoute = data.getPath()) != null && !fullRoute.isEmpty()) {
            if (data.getQuery() != null && !data.getQuery().isEmpty()) {
                fullRoute = fullRoute + "?" + data.getQuery();
            }
            if (data.getFragment() != null && !data.getFragment().isEmpty()) {
                fullRoute = fullRoute + "#" + data.getFragment();
            }
            return fullRoute;
        }
        return null;
    }

    private void delayFirstAndroidViewDraw(final FlutterView flutterView) {
        if (this.host.getRenderMode() != RenderMode.surface) {
            throw new IllegalArgumentException("Cannot delay the first Android view draw when the render mode is not set to `RenderMode.surface`.");
        }
        if (this.activePreDrawListener != null) {
            flutterView.getViewTreeObserver().removeOnPreDrawListener(this.activePreDrawListener);
        }
        this.activePreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (FlutterActivityAndFragmentDelegate.this.isFlutterUiDisplayed && FlutterActivityAndFragmentDelegate.this.activePreDrawListener != null) {
                    flutterView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    FlutterActivityAndFragmentDelegate.this.activePreDrawListener = null;
                }
                return FlutterActivityAndFragmentDelegate.this.isFlutterUiDisplayed;
            }
        };
        flutterView.getViewTreeObserver().addOnPreDrawListener(this.activePreDrawListener);
    }

    void onResume() {
        Log.v(TAG, "onResume()");
        this.ensureAlive();
        if (this.host.shouldDispatchAppLifecycleState()) {
            this.flutterEngine.getLifecycleChannel().appIsResumed();
        }
    }

    void onPostResume() {
        Log.v(TAG, "onPostResume()");
        this.ensureAlive();
        if (this.flutterEngine != null) {
            this.updateSystemUiOverlays();
        } else {
            Log.w(TAG, "onPostResume() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void updateSystemUiOverlays() {
        if (this.platformPlugin != null) {
            this.platformPlugin.updateSystemUiOverlays();
        }
    }

    void onPause() {
        Log.v(TAG, "onPause()");
        this.ensureAlive();
        if (this.host.shouldDispatchAppLifecycleState()) {
            this.flutterEngine.getLifecycleChannel().appIsInactive();
        }
    }

    void onStop() {
        Log.v(TAG, "onStop()");
        this.ensureAlive();
        if (this.host.shouldDispatchAppLifecycleState()) {
            this.flutterEngine.getLifecycleChannel().appIsPaused();
        }
        this.flutterView.setVisibility(8);
    }

    void onDestroyView() {
        Log.v(TAG, "onDestroyView()");
        this.ensureAlive();
        if (this.activePreDrawListener != null) {
            this.flutterView.getViewTreeObserver().removeOnPreDrawListener(this.activePreDrawListener);
            this.activePreDrawListener = null;
        }
        this.flutterView.detachFromFlutterEngine();
        this.flutterView.removeOnFirstFrameRenderedListener(this.flutterUiDisplayListener);
    }

    void onSaveInstanceState(@Nullable Bundle bundle) {
        Log.v(TAG, "onSaveInstanceState. Giving framework and plugins an opportunity to save state.");
        this.ensureAlive();
        if (this.host.shouldRestoreAndSaveState()) {
            bundle.putByteArray(FRAMEWORK_RESTORATION_BUNDLE_KEY, this.flutterEngine.getRestorationChannel().getRestorationData());
        }
        if (this.host.shouldAttachEngineToActivity()) {
            Bundle plugins = new Bundle();
            this.flutterEngine.getActivityControlSurface().onSaveInstanceState(plugins);
            bundle.putBundle(PLUGINS_RESTORATION_BUNDLE_KEY, plugins);
        }
    }

    @Override
    public void detachFromFlutterEngine() {
        if (this.host.shouldDestroyEngineWithHost()) {
            throw new AssertionError((Object)("The internal FlutterEngine created by " + this.host + " has been attached to by another activity. To persist a FlutterEngine beyond the ownership of this activity, explicitly create a FlutterEngine"));
        }
        this.host.detachFromFlutterEngine();
    }

    void onDetach() {
        Log.v(TAG, "onDetach()");
        this.ensureAlive();
        this.host.cleanUpFlutterEngine(this.flutterEngine);
        if (this.host.shouldAttachEngineToActivity()) {
            Log.v(TAG, "Detaching FlutterEngine from the Activity that owns this Fragment.");
            if (this.host.getActivity().isChangingConfigurations()) {
                this.flutterEngine.getActivityControlSurface().detachFromActivityForConfigChanges();
            } else {
                this.flutterEngine.getActivityControlSurface().detachFromActivity();
            }
        }
        if (this.platformPlugin != null) {
            this.platformPlugin.destroy();
            this.platformPlugin = null;
        }
        if (this.host.shouldDispatchAppLifecycleState()) {
            this.flutterEngine.getLifecycleChannel().appIsDetached();
        }
        if (this.host.shouldDestroyEngineWithHost()) {
            this.flutterEngine.destroy();
            if (this.host.getCachedEngineId() != null) {
                FlutterEngineCache.getInstance().remove(this.host.getCachedEngineId());
            }
            this.flutterEngine = null;
        }
        this.isAttached = false;
    }

    void onBackPressed() {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onBackPressed() to FlutterEngine.");
            this.flutterEngine.getNavigationChannel().popRoute();
        } else {
            Log.w(TAG, "Invoked onBackPressed() before FlutterFragment was attached to an Activity.");
        }
    }

    void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onRequestPermissionsResult() to FlutterEngine:\nrequestCode: " + requestCode + "\npermissions: " + Arrays.toString(permissions) + "\ngrantResults: " + Arrays.toString(grantResults));
            this.flutterEngine.getActivityControlSurface().onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else {
            Log.w(TAG, "onRequestPermissionResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onNewIntent(@NonNull Intent intent) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onNewIntent() to FlutterEngine and sending pushRoute message.");
            this.flutterEngine.getActivityControlSurface().onNewIntent(intent);
            String initialRoute = this.maybeGetInitialRouteFromIntent(intent);
            if (initialRoute != null && !initialRoute.isEmpty()) {
                this.flutterEngine.getNavigationChannel().pushRoute(initialRoute);
            }
        } else {
            Log.w(TAG, "onNewIntent() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onActivityResult() to FlutterEngine:\nrequestCode: " + requestCode + "\nresultCode: " + resultCode + "\ndata: " + data);
            this.flutterEngine.getActivityControlSurface().onActivityResult(requestCode, resultCode, data);
        } else {
            Log.w(TAG, "onActivityResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onUserLeaveHint() {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onUserLeaveHint() to FlutterEngine.");
            this.flutterEngine.getActivityControlSurface().onUserLeaveHint();
        } else {
            Log.w(TAG, "onUserLeaveHint() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onTrimMemory(int level) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            boolean trim;
            boolean bl = trim = this.isFirstFrameRendered && level >= 10;
            if (trim) {
                this.flutterEngine.getDartExecutor().notifyLowMemoryWarning();
                this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
            }
        }
    }

    void onLowMemory() {
        Log.v(TAG, "Forwarding onLowMemory() to FlutterEngine.");
        this.ensureAlive();
        this.flutterEngine.getDartExecutor().notifyLowMemoryWarning();
        this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
    }

    private void ensureAlive() {
        if (this.host == null) {
            throw new IllegalStateException("Cannot execute method on a destroyed FlutterActivityAndFragmentDelegate.");
        }
    }

    static interface Host
    extends SplashScreenProvider,
    FlutterEngineProvider,
    FlutterEngineConfigurator,
    PlatformPlugin.PlatformPluginDelegate {
        @NonNull
        public Context getContext();

        @Nullable
        public boolean shouldHandleDeeplinking();

        @Nullable
        public Activity getActivity();

        @NonNull
        public Lifecycle getLifecycle();

        @NonNull
        public FlutterShellArgs getFlutterShellArgs();

        @Nullable
        public String getCachedEngineId();

        public boolean shouldDestroyEngineWithHost();

        public void detachFromFlutterEngine();

        @NonNull
        public String getDartEntrypointFunctionName();

        @Nullable
        public String getDartEntrypointLibraryUri();

        @Nullable
        public List<String> getDartEntrypointArgs();

        @NonNull
        public String getAppBundlePath();

        @Nullable
        public String getInitialRoute();

        @NonNull
        public RenderMode getRenderMode();

        @NonNull
        public TransparencyMode getTransparencyMode();

        public ExclusiveAppComponent<Activity> getExclusiveAppComponent();

        @Override
        @Nullable
        public SplashScreen provideSplashScreen();

        @Override
        @Nullable
        public FlutterEngine provideFlutterEngine(@NonNull Context var1);

        @Nullable
        public PlatformPlugin providePlatformPlugin(@Nullable Activity var1, @NonNull FlutterEngine var2);

        @Override
        public void configureFlutterEngine(@NonNull FlutterEngine var1);

        @Override
        public void cleanUpFlutterEngine(@NonNull FlutterEngine var1);

        public boolean shouldAttachEngineToActivity();

        public void onFlutterSurfaceViewCreated(@NonNull FlutterSurfaceView var1);

        public void onFlutterTextureViewCreated(@NonNull FlutterTextureView var1);

        public void onFlutterUiDisplayed();

        public void onFlutterUiNoLongerDisplayed();

        public boolean shouldRestoreAndSaveState();

        public void updateSystemUiOverlays();

        public boolean shouldDispatchAppLifecycleState();
    }
}

