/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import io.flutter.Log;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.view.TextureRegistry;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=26)
public class SurfaceTexturePlatformViewRenderTarget
implements PlatformViewRenderTarget {
    private static final String TAG = "SurfaceTexturePlatformViewRenderTarget";
    private final AtomicLong pendingFramesCount = new AtomicLong(0L);
    private final TextureRegistry.SurfaceTextureEntry surfaceTextureEntry;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int bufferWidth = 0;
    private int bufferHeight = 0;
    private final TextureRegistry.OnFrameConsumedListener frameConsumedListener = new TextureRegistry.OnFrameConsumedListener(){

        @Override
        public void onFrameConsumed() {
            if (Build.VERSION.SDK_INT == 29) {
                SurfaceTexturePlatformViewRenderTarget.this.pendingFramesCount.decrementAndGet();
            }
        }
    };
    private boolean shouldRecreateSurfaceForLowMemory = false;
    private final TextureRegistry.OnTrimMemoryListener trimMemoryListener = new TextureRegistry.OnTrimMemoryListener(){

        @Override
        public void onTrimMemory(int level) {
            if (level == 80 && Build.VERSION.SDK_INT >= 29) {
                SurfaceTexturePlatformViewRenderTarget.this.shouldRecreateSurfaceForLowMemory = true;
            }
        }
    };

    private void onFrameProduced() {
        if (Build.VERSION.SDK_INT == 29) {
            this.pendingFramesCount.incrementAndGet();
        }
    }

    private void recreateSurfaceIfNeeded() {
        if (!this.shouldRecreateSurfaceForLowMemory) {
            return;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        this.surface = this.createSurface();
        this.shouldRecreateSurfaceForLowMemory = false;
    }

    protected Surface createSurface() {
        return new Surface(this.surfaceTexture);
    }

    private void init() {
        if (this.bufferWidth > 0 && this.bufferHeight > 0) {
            this.surfaceTexture.setDefaultBufferSize(this.bufferWidth, this.bufferHeight);
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        this.surface = this.createSurface();
        Canvas canvas = this.lockHardwareCanvas();
        try {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        finally {
            this.unlockCanvasAndPost(canvas);
        }
    }

    public SurfaceTexturePlatformViewRenderTarget(TextureRegistry.SurfaceTextureEntry surfaceTextureEntry) {
        if (Build.VERSION.SDK_INT < 23) {
            throw new UnsupportedOperationException("Platform views cannot be displayed below API level 23You can prevent this issue by setting `minSdkVersion: 23` in build.gradle.");
        }
        this.surfaceTextureEntry = surfaceTextureEntry;
        this.surfaceTexture = surfaceTextureEntry.surfaceTexture();
        surfaceTextureEntry.setOnFrameConsumedListener(this.frameConsumedListener);
        surfaceTextureEntry.setOnTrimMemoryListener(this.trimMemoryListener);
        this.init();
    }

    @Override
    public Canvas lockHardwareCanvas() {
        this.recreateSurfaceIfNeeded();
        if (Build.VERSION.SDK_INT == 29 && this.pendingFramesCount.get() > 0L) {
            return null;
        }
        if (this.surfaceTexture == null || this.surfaceTexture.isReleased()) {
            Log.e(TAG, "Invalid RenderTarget: null or already released SurfaceTexture");
            return null;
        }
        this.onFrameProduced();
        return this.surface.lockHardwareCanvas();
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        this.surface.unlockCanvasAndPost(canvas);
    }

    @Override
    public void resize(int width, int height) {
        this.bufferWidth = width;
        this.bufferHeight = height;
        if (this.surfaceTexture != null) {
            this.surfaceTexture.setDefaultBufferSize(this.bufferWidth, this.bufferHeight);
        }
    }

    @Override
    public int getWidth() {
        return this.bufferWidth;
    }

    @Override
    public int getHeight() {
        return this.bufferHeight;
    }

    @Override
    public long getId() {
        return this.surfaceTextureEntry.id();
    }

    @Override
    public boolean isReleased() {
        return this.surfaceTexture == null;
    }

    @Override
    public void release() {
        this.surfaceTexture = null;
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
    }

    @Override
    public Surface getSurface() {
        this.recreateSurfaceIfNeeded();
        return this.surface;
    }
}

