/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.hardware.HardwareBuffer;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.RenderSurface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;

public class FlutterImageView
extends View
implements RenderSurface {
    private static final String TAG = "FlutterImageView";
    @NonNull
    private ImageReader imageReader;
    @Nullable
    private Image currentImage;
    @Nullable
    private Bitmap currentBitmap;
    @Nullable
    private FlutterRenderer flutterRenderer;
    private SurfaceKind kind;
    private boolean isAttachedToFlutterRenderer = false;

    public ImageReader getImageReader() {
        return this.imageReader;
    }

    public FlutterImageView(@NonNull Context context, int width, int height, SurfaceKind kind) {
        this(context, FlutterImageView.createImageReader(width, height), kind);
    }

    public FlutterImageView(@NonNull Context context) {
        this(context, 1, 1, SurfaceKind.background);
    }

    public FlutterImageView(@NonNull Context context, @NonNull AttributeSet attrs) {
        this(context, 1, 1, SurfaceKind.background);
    }

    @VisibleForTesting
    FlutterImageView(@NonNull Context context, @NonNull ImageReader imageReader, SurfaceKind kind) {
        super(context, null);
        this.imageReader = imageReader;
        this.kind = kind;
        this.init();
    }

    private void init() {
        this.setAlpha(0.0f);
    }

    private static void logW(String format, Object ... args) {
        Log.w(TAG, String.format(Locale.US, format, args));
    }

    @SuppressLint(value={"WrongConstant"})
    @NonNull
    private static ImageReader createImageReader(int width, int height) {
        if (width <= 0) {
            FlutterImageView.logW("ImageReader width must be greater than 0, but given width=%d, set width=1", width);
            width = 1;
        }
        if (height <= 0) {
            FlutterImageView.logW("ImageReader height must be greater than 0, but given height=%d, set height=1", height);
            height = 1;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return ImageReader.newInstance((int)width, (int)height, (int)1, (int)3, (long)768L);
        }
        return ImageReader.newInstance((int)width, (int)height, (int)1, (int)3);
    }

    @NonNull
    public Surface getSurface() {
        return this.imageReader.getSurface();
    }

    @Override
    @Nullable
    public FlutterRenderer getAttachedRenderer() {
        return this.flutterRenderer;
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        switch (this.kind.ordinal()) {
            case 0: {
                flutterRenderer.swapSurface(this.imageReader.getSurface());
                break;
            }
        }
        this.setAlpha(1.0f);
        this.flutterRenderer = flutterRenderer;
        this.isAttachedToFlutterRenderer = true;
    }

    @Override
    public void detachFromRenderer() {
        if (!this.isAttachedToFlutterRenderer) {
            return;
        }
        this.setAlpha(0.0f);
        this.acquireLatestImage();
        this.currentBitmap = null;
        this.closeCurrentImage();
        this.invalidate();
        this.isAttachedToFlutterRenderer = false;
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    public boolean acquireLatestImage() {
        if (!this.isAttachedToFlutterRenderer) {
            return false;
        }
        Image newImage = this.imageReader.acquireLatestImage();
        if (newImage != null) {
            this.closeCurrentImage();
            this.currentImage = newImage;
            this.invalidate();
        }
        return newImage != null;
    }

    public void resizeIfNeeded(int width, int height) {
        if (this.flutterRenderer == null) {
            return;
        }
        if (width == this.imageReader.getWidth() && height == this.imageReader.getHeight()) {
            return;
        }
        this.closeCurrentImage();
        this.closeImageReader();
        this.imageReader = FlutterImageView.createImageReader(width, height);
    }

    public void closeImageReader() {
        this.imageReader.close();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.currentImage != null) {
            this.updateCurrentBitmap();
        }
        if (this.currentBitmap != null) {
            canvas.drawBitmap(this.currentBitmap, 0.0f, 0.0f, null);
        }
    }

    private void closeCurrentImage() {
        if (this.currentImage != null) {
            this.currentImage.close();
            this.currentImage = null;
        }
    }

    private void updateCurrentBitmap() {
        if (Build.VERSION.SDK_INT >= 29) {
            HardwareBuffer buffer = this.currentImage.getHardwareBuffer();
            this.currentBitmap = Bitmap.wrapHardwareBuffer((HardwareBuffer)buffer, (ColorSpace)ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB));
            buffer.close();
        } else {
            Image.Plane[] imagePlanes = this.currentImage.getPlanes();
            if (imagePlanes.length != 1) {
                return;
            }
            Image.Plane imagePlane = imagePlanes[0];
            int desiredWidth = imagePlane.getRowStride() / imagePlane.getPixelStride();
            int desiredHeight = this.currentImage.getHeight();
            if (this.currentBitmap == null || this.currentBitmap.getWidth() != desiredWidth || this.currentBitmap.getHeight() != desiredHeight) {
                this.currentBitmap = Bitmap.createBitmap((int)desiredWidth, (int)desiredHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            ByteBuffer buffer = imagePlane.getBuffer();
            buffer.rewind();
            this.currentBitmap.copyPixelsFromBuffer((Buffer)buffer);
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        if (width == this.imageReader.getWidth() && height == this.imageReader.getHeight()) {
            return;
        }
        if (this.kind == SurfaceKind.background && this.isAttachedToFlutterRenderer) {
            this.resizeIfNeeded(width, height);
            this.flutterRenderer.swapSurface(this.imageReader.getSurface());
        }
    }

    public static enum SurfaceKind {
        background,
        overlay;

    }
}

