/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.loader.FlutterLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class FlutterInjector {
    private static FlutterInjector instance;
    private static boolean accessed;
    private FlutterLoader flutterLoader;
    private DeferredComponentManager deferredComponentManager;
    private FlutterJNI.Factory flutterJniFactory;
    private ExecutorService executorService;

    public static void setInstance(@NonNull FlutterInjector injector) {
        if (accessed) {
            throw new IllegalStateException("Cannot change the FlutterInjector instance once it's been read. If you're trying to dependency inject, be sure to do so at the beginning of the program");
        }
        instance = injector;
    }

    public static FlutterInjector instance() {
        accessed = true;
        if (instance == null) {
            instance = new Builder().build();
        }
        return instance;
    }

    @VisibleForTesting
    public static void reset() {
        accessed = false;
        instance = null;
    }

    private FlutterInjector(@NonNull FlutterLoader flutterLoader, @Nullable DeferredComponentManager deferredComponentManager, @NonNull FlutterJNI.Factory flutterJniFactory, @NonNull ExecutorService executorService) {
        this.flutterLoader = flutterLoader;
        this.deferredComponentManager = deferredComponentManager;
        this.flutterJniFactory = flutterJniFactory;
        this.executorService = executorService;
    }

    @NonNull
    public FlutterLoader flutterLoader() {
        return this.flutterLoader;
    }

    @Nullable
    public DeferredComponentManager deferredComponentManager() {
        return this.deferredComponentManager;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    @NonNull
    public FlutterJNI.Factory getFlutterJNIFactory() {
        return this.flutterJniFactory;
    }

    public static final class Builder {
        private FlutterLoader flutterLoader;
        private DeferredComponentManager deferredComponentManager;
        private FlutterJNI.Factory flutterJniFactory;
        private ExecutorService executorService;

        public Builder setFlutterLoader(@NonNull FlutterLoader flutterLoader) {
            this.flutterLoader = flutterLoader;
            return this;
        }

        public Builder setDeferredComponentManager(@Nullable DeferredComponentManager deferredComponentManager) {
            this.deferredComponentManager = deferredComponentManager;
            return this;
        }

        public Builder setFlutterJNIFactory(@NonNull FlutterJNI.Factory factory) {
            this.flutterJniFactory = factory;
            return this;
        }

        public Builder setExecutorService(@NonNull ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        private void fillDefaults() {
            if (this.flutterJniFactory == null) {
                this.flutterJniFactory = new FlutterJNI.Factory();
            }
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool(new NamedThreadFactory());
            }
            if (this.flutterLoader == null) {
                this.flutterLoader = new FlutterLoader(this.flutterJniFactory.provideFlutterJNI(), this.executorService);
            }
        }

        public FlutterInjector build() {
            this.fillDefaults();
            return new FlutterInjector(this.flutterLoader, this.deferredComponentManager, this.flutterJniFactory, this.executorService);
        }

        private class NamedThreadFactory
        implements ThreadFactory {
            private int threadId = 0;

            private NamedThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable command) {
                Thread thread = new Thread(command);
                thread.setName("flutter-worker-" + this.threadId++);
                return thread;
            }
        }
    }
}

