/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import io.flutter.Log;
import io.flutter.embedding.android.FlutterActivityLaunchConfigs;
import io.flutter.embedding.android.FlutterEngineConfigurator;
import io.flutter.embedding.android.FlutterEngineProvider;
import io.flutter.embedding.android.FlutterFragment;
import io.flutter.embedding.android.RenderMode;
import io.flutter.embedding.android.TransparencyMode;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.plugins.util.GeneratedPluginRegister;
import java.util.ArrayList;
import java.util.List;

public class FlutterFragmentActivity
extends FragmentActivity
implements FlutterEngineProvider,
FlutterEngineConfigurator {
    private static final String TAG = "FlutterFragmentActivity";
    private static final String TAG_FLUTTER_FRAGMENT = "flutter_fragment";
    public static final int FRAGMENT_CONTAINER_ID = View.generateViewId();
    @Nullable
    private FlutterFragment flutterFragment;

    @NonNull
    public static Intent createDefaultIntent(@NonNull Context launchContext) {
        return FlutterFragmentActivity.withNewEngine().build(launchContext);
    }

    @NonNull
    public static NewEngineIntentBuilder withNewEngine() {
        return new NewEngineIntentBuilder(FlutterFragmentActivity.class);
    }

    @NonNull
    public static CachedEngineIntentBuilder withCachedEngine(@NonNull String cachedEngineId) {
        return new CachedEngineIntentBuilder(FlutterFragmentActivity.class, cachedEngineId);
    }

    public static NewEngineInGroupIntentBuilder withNewEngineInGroup(@NonNull String engineGroupId) {
        return new NewEngineInGroupIntentBuilder(FlutterFragmentActivity.class, engineGroupId);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.switchLaunchThemeForNormalTheme();
        this.flutterFragment = this.retrieveExistingFlutterFragmentIfPossible();
        super.onCreate(savedInstanceState);
        this.configureWindowForTransparency();
        this.setContentView(this.createFragmentContainer());
        this.configureStatusBarForFullscreenFlutterExperience();
        this.ensureFlutterFragmentCreated();
    }

    private void switchLaunchThemeForNormalTheme() {
        try {
            Bundle metaData = this.getMetaData();
            if (metaData != null) {
                int normalThemeRID = metaData.getInt("io.flutter.embedding.android.NormalTheme", -1);
                if (normalThemeRID != -1) {
                    this.setTheme(normalThemeRID);
                }
            } else {
                Log.v(TAG, "Using the launch theme as normal theme.");
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e(TAG, "Could not read meta-data for FlutterFragmentActivity. Using the launch theme as normal theme.");
        }
    }

    private void configureWindowForTransparency() {
        FlutterActivityLaunchConfigs.BackgroundMode backgroundMode = this.getBackgroundMode();
        if (backgroundMode == FlutterActivityLaunchConfigs.BackgroundMode.transparent) {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    @NonNull
    private View createFragmentContainer() {
        FrameLayout container = this.provideRootLayout((Context)this);
        container.setId(FRAGMENT_CONTAINER_ID);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return container;
    }

    @VisibleForTesting
    FlutterFragment retrieveExistingFlutterFragmentIfPossible() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        return (FlutterFragment)fragmentManager.findFragmentByTag(TAG_FLUTTER_FRAGMENT);
    }

    private void ensureFlutterFragmentCreated() {
        if (this.flutterFragment == null) {
            this.flutterFragment = this.retrieveExistingFlutterFragmentIfPossible();
        }
        if (this.flutterFragment == null) {
            this.flutterFragment = this.createFlutterFragment();
            FragmentManager fragmentManager = this.getSupportFragmentManager();
            fragmentManager.beginTransaction().add(FRAGMENT_CONTAINER_ID, (Fragment)this.flutterFragment, TAG_FLUTTER_FRAGMENT).commit();
        }
    }

    @NonNull
    protected FlutterFragment createFlutterFragment() {
        FlutterActivityLaunchConfigs.BackgroundMode backgroundMode = this.getBackgroundMode();
        RenderMode renderMode = this.getRenderMode();
        TransparencyMode transparencyMode = backgroundMode == FlutterActivityLaunchConfigs.BackgroundMode.opaque ? TransparencyMode.opaque : TransparencyMode.transparent;
        boolean shouldDelayFirstAndroidViewDraw = renderMode == RenderMode.surface;
        boolean shouldAutomaticallyHandleOnBackPressed = true;
        if (this.getCachedEngineId() != null) {
            Log.v(TAG, "Creating FlutterFragment with cached engine:\nCached engine ID: " + this.getCachedEngineId() + "\nWill destroy engine when Activity is destroyed: " + this.shouldDestroyEngineWithHost() + "\nBackground transparency mode: " + (Object)((Object)backgroundMode) + "\nWill attach FlutterEngine to Activity: " + this.shouldAttachEngineToActivity());
            return FlutterFragment.withCachedEngine(this.getCachedEngineId()).renderMode(renderMode).transparencyMode(transparencyMode).handleDeeplinking(this.shouldHandleDeeplinking()).shouldAttachEngineToActivity(this.shouldAttachEngineToActivity()).destroyEngineWithFragment(this.shouldDestroyEngineWithHost()).shouldDelayFirstAndroidViewDraw(shouldDelayFirstAndroidViewDraw).shouldAutomaticallyHandleOnBackPressed(true).build();
        }
        Log.v(TAG, "Creating FlutterFragment with new engine:\nCached engine group ID: " + this.getCachedEngineGroupId() + "\nBackground transparency mode: " + (Object)((Object)backgroundMode) + "\nDart entrypoint: " + this.getDartEntrypointFunctionName() + "\nDart entrypoint library uri: " + (this.getDartEntrypointLibraryUri() != null ? this.getDartEntrypointLibraryUri() : "\"\"") + "\nInitial route: " + this.getInitialRoute() + "\nApp bundle path: " + this.getAppBundlePath() + "\nWill attach FlutterEngine to Activity: " + this.shouldAttachEngineToActivity());
        if (this.getCachedEngineGroupId() != null) {
            return FlutterFragment.withNewEngineInGroup(this.getCachedEngineGroupId()).dartEntrypoint(this.getDartEntrypointFunctionName()).initialRoute(this.getInitialRoute()).handleDeeplinking(this.shouldHandleDeeplinking()).renderMode(renderMode).transparencyMode(transparencyMode).shouldAttachEngineToActivity(this.shouldAttachEngineToActivity()).shouldDelayFirstAndroidViewDraw(shouldDelayFirstAndroidViewDraw).shouldAutomaticallyHandleOnBackPressed(true).build();
        }
        return FlutterFragment.withNewEngine().dartEntrypoint(this.getDartEntrypointFunctionName()).dartLibraryUri(this.getDartEntrypointLibraryUri()).dartEntrypointArgs(this.getDartEntrypointArgs()).initialRoute(this.getInitialRoute()).appBundlePath(this.getAppBundlePath()).flutterShellArgs(FlutterShellArgs.fromIntent(this.getIntent())).handleDeeplinking(this.shouldHandleDeeplinking()).renderMode(renderMode).transparencyMode(transparencyMode).shouldAttachEngineToActivity(this.shouldAttachEngineToActivity()).shouldDelayFirstAndroidViewDraw(shouldDelayFirstAndroidViewDraw).shouldAutomaticallyHandleOnBackPressed(true).build();
    }

    private void configureStatusBarForFullscreenFlutterExperience() {
        Window window = this.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0x40000000);
        window.getDecorView().setSystemUiVisibility(1280);
    }

    public void onPostResume() {
        super.onPostResume();
        this.flutterFragment.onPostResume();
    }

    protected void onNewIntent(@NonNull Intent intent) {
        this.flutterFragment.onNewIntent(intent);
        super.onNewIntent(intent);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.flutterFragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onUserLeaveHint() {
        this.flutterFragment.onUserLeaveHint();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.flutterFragment.onTrimMemory(level);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.flutterFragment.onActivityResult(requestCode, resultCode, data);
    }

    @Nullable
    protected FlutterEngine getFlutterEngine() {
        return this.flutterFragment.getFlutterEngine();
    }

    public boolean shouldDestroyEngineWithHost() {
        return this.getIntent().getBooleanExtra("destroy_engine_with_activity", false);
    }

    protected boolean shouldAttachEngineToActivity() {
        return true;
    }

    @VisibleForTesting
    protected boolean shouldHandleDeeplinking() {
        try {
            Bundle metaData = this.getMetaData();
            return FlutterActivityLaunchConfigs.deepLinkEnabled(metaData);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public FlutterEngine provideFlutterEngine(@NonNull Context context) {
        return null;
    }

    @Override
    public void configureFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        if (this.flutterFragment != null && this.flutterFragment.isFlutterEngineInjected()) {
            return;
        }
        GeneratedPluginRegister.registerGeneratedPlugins(flutterEngine);
    }

    @Override
    public void cleanUpFlutterEngine(@NonNull FlutterEngine flutterEngine) {
    }

    @NonNull
    protected String getAppBundlePath() {
        String appBundlePath;
        if (this.isDebuggable() && "android.intent.action.RUN".equals(this.getIntent().getAction()) && (appBundlePath = this.getIntent().getDataString()) != null) {
            return appBundlePath;
        }
        return null;
    }

    @Nullable
    protected Bundle getMetaData() throws PackageManager.NameNotFoundException {
        ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
        return activityInfo.metaData;
    }

    @NonNull
    public String getDartEntrypointFunctionName() {
        try {
            Bundle metaData = this.getMetaData();
            String desiredDartEntrypoint = metaData != null ? metaData.getString("io.flutter.Entrypoint") : null;
            return desiredDartEntrypoint != null ? desiredDartEntrypoint : "main";
        }
        catch (PackageManager.NameNotFoundException e) {
            return "main";
        }
    }

    @Nullable
    public List<String> getDartEntrypointArgs() {
        return (List)((Object)this.getIntent().getSerializableExtra("dart_entrypoint_args"));
    }

    @Nullable
    public String getDartEntrypointLibraryUri() {
        try {
            Bundle metaData = this.getMetaData();
            String desiredDartLibraryUri = metaData != null ? metaData.getString("io.flutter.EntrypointUri") : null;
            return desiredDartLibraryUri;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    protected String getInitialRoute() {
        if (this.getIntent().hasExtra("route")) {
            return this.getIntent().getStringExtra("route");
        }
        try {
            Bundle metaData = this.getMetaData();
            String desiredInitialRoute = metaData != null ? metaData.getString("io.flutter.InitialRoute") : null;
            return desiredInitialRoute;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    @Nullable
    protected String getCachedEngineId() {
        return this.getIntent().getStringExtra("cached_engine_id");
    }

    @Nullable
    protected String getCachedEngineGroupId() {
        return this.getIntent().getStringExtra("cached_engine_group_id");
    }

    @NonNull
    protected FlutterActivityLaunchConfigs.BackgroundMode getBackgroundMode() {
        if (this.getIntent().hasExtra("background_mode")) {
            return FlutterActivityLaunchConfigs.BackgroundMode.valueOf(this.getIntent().getStringExtra("background_mode"));
        }
        return FlutterActivityLaunchConfigs.BackgroundMode.opaque;
    }

    @NonNull
    protected RenderMode getRenderMode() {
        FlutterActivityLaunchConfigs.BackgroundMode backgroundMode = this.getBackgroundMode();
        return backgroundMode == FlutterActivityLaunchConfigs.BackgroundMode.opaque ? RenderMode.surface : RenderMode.texture;
    }

    private boolean isDebuggable() {
        return (this.getApplicationInfo().flags & 2) != 0;
    }

    @NonNull
    protected FrameLayout provideRootLayout(Context context) {
        return new FrameLayout(context);
    }

    public static class NewEngineIntentBuilder {
        private final Class<? extends FlutterFragmentActivity> activityClass;
        private String initialRoute = "/";
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;
        @Nullable
        private List<String> dartEntrypointArgs;

        public NewEngineIntentBuilder(@NonNull Class<? extends FlutterFragmentActivity> activityClass) {
            this.activityClass = activityClass;
        }

        @NonNull
        public NewEngineIntentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public NewEngineIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public NewEngineIntentBuilder dartEntrypointArgs(@Nullable List<String> dartEntrypointArgs) {
            this.dartEntrypointArgs = dartEntrypointArgs;
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            Intent intent = new Intent(context, this.activityClass).putExtra("route", this.initialRoute).putExtra("background_mode", this.backgroundMode).putExtra("destroy_engine_with_activity", true);
            if (this.dartEntrypointArgs != null) {
                intent.putExtra("dart_entrypoint_args", new ArrayList<String>(this.dartEntrypointArgs));
            }
            return intent;
        }
    }

    public static class CachedEngineIntentBuilder {
        private final Class<? extends FlutterFragmentActivity> activityClass;
        private final String cachedEngineId;
        private boolean destroyEngineWithActivity = false;
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;

        public CachedEngineIntentBuilder(@NonNull Class<? extends FlutterFragmentActivity> activityClass, @NonNull String engineId) {
            this.activityClass = activityClass;
            this.cachedEngineId = engineId;
        }

        public CachedEngineIntentBuilder destroyEngineWithActivity(boolean destroyEngineWithActivity) {
            this.destroyEngineWithActivity = destroyEngineWithActivity;
            return this;
        }

        @NonNull
        public CachedEngineIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra("cached_engine_id", this.cachedEngineId).putExtra("destroy_engine_with_activity", this.destroyEngineWithActivity).putExtra("background_mode", this.backgroundMode);
        }
    }

    public static class NewEngineInGroupIntentBuilder {
        private final Class<? extends FlutterFragmentActivity> activityClass;
        private final String cachedEngineGroupId;
        private String dartEntrypoint = "main";
        private String initialRoute = "/";
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;

        public NewEngineInGroupIntentBuilder(@NonNull Class<? extends FlutterFragmentActivity> activityClass, @NonNull String engineGroupId) {
            this.activityClass = activityClass;
            this.cachedEngineGroupId = engineGroupId;
        }

        @NonNull
        public NewEngineInGroupIntentBuilder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public NewEngineInGroupIntentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public NewEngineInGroupIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra("dart_entrypoint", this.dartEntrypoint).putExtra("route", this.initialRoute).putExtra("cached_engine_group_id", this.cachedEngineGroupId).putExtra("background_mode", this.backgroundMode).putExtra("destroy_engine_with_activity", true);
        }
    }
}

