/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngineConnectionRegistry;
import io.flutter.embedding.engine.FlutterEngineGroup;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.embedding.engine.plugins.PluginRegistry;
import io.flutter.embedding.engine.plugins.activity.ActivityControlSurface;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverControlSurface;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderControlSurface;
import io.flutter.embedding.engine.plugins.service.ServiceControlSurface;
import io.flutter.embedding.engine.plugins.util.GeneratedPluginRegister;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.embedding.engine.systemchannels.BackGestureChannel;
import io.flutter.embedding.engine.systemchannels.DeferredComponentChannel;
import io.flutter.embedding.engine.systemchannels.LifecycleChannel;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import io.flutter.embedding.engine.systemchannels.MouseCursorChannel;
import io.flutter.embedding.engine.systemchannels.NavigationChannel;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.embedding.engine.systemchannels.ProcessTextChannel;
import io.flutter.embedding.engine.systemchannels.RestorationChannel;
import io.flutter.embedding.engine.systemchannels.ScribeChannel;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.embedding.engine.systemchannels.SpellCheckChannel;
import io.flutter.embedding.engine.systemchannels.SystemChannel;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.localization.LocalizationPlugin;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.plugin.text.ProcessTextPlugin;
import io.flutter.util.ViewUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FlutterEngine
implements ViewUtils.DisplayUpdater {
    private static final String TAG = "FlutterEngine";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final FlutterRenderer renderer;
    @NonNull
    private final DartExecutor dartExecutor;
    @NonNull
    private final FlutterEngineConnectionRegistry pluginRegistry;
    @NonNull
    private final LocalizationPlugin localizationPlugin;
    @NonNull
    private final AccessibilityChannel accessibilityChannel;
    @NonNull
    private final DeferredComponentChannel deferredComponentChannel;
    @NonNull
    private final LifecycleChannel lifecycleChannel;
    @NonNull
    private final LocalizationChannel localizationChannel;
    @NonNull
    private final MouseCursorChannel mouseCursorChannel;
    @NonNull
    private final NavigationChannel navigationChannel;
    @NonNull
    private final BackGestureChannel backGestureChannel;
    @NonNull
    private final RestorationChannel restorationChannel;
    @NonNull
    private final PlatformChannel platformChannel;
    @NonNull
    private final ProcessTextChannel processTextChannel;
    @NonNull
    private final ScribeChannel scribeChannel;
    @NonNull
    private final SettingsChannel settingsChannel;
    @NonNull
    private final SpellCheckChannel spellCheckChannel;
    @NonNull
    private final SystemChannel systemChannel;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private final PlatformViewsController platformViewsController;
    @NonNull
    private final Set<EngineLifecycleListener> engineLifecycleListeners = new HashSet<EngineLifecycleListener>();
    @NonNull
    private final EngineLifecycleListener engineLifecycleListener = new EngineLifecycleListener(){

        @Override
        public void onPreEngineRestart() {
            Log.v(FlutterEngine.TAG, "onPreEngineRestart()");
            for (EngineLifecycleListener lifecycleListener : FlutterEngine.this.engineLifecycleListeners) {
                lifecycleListener.onPreEngineRestart();
            }
            FlutterEngine.this.platformViewsController.onPreEngineRestart();
            FlutterEngine.this.restorationChannel.clearData();
        }

        @Override
        public void onEngineWillDestroy() {
        }
    };

    public FlutterEngine(@NonNull Context context) {
        this(context, null);
    }

    public FlutterEngine(@NonNull Context context, @Nullable String[] dartVmArgs) {
        this(context, null, null, dartVmArgs, true);
    }

    public FlutterEngine(@NonNull Context context, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        this(context, null, null, dartVmArgs, automaticallyRegisterPlugins);
    }

    public FlutterEngine(@NonNull Context context, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins, boolean waitForRestorationData) {
        this(context, null, null, new PlatformViewsController(), dartVmArgs, automaticallyRegisterPlugins, waitForRestorationData);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI) {
        this(context, flutterLoader, flutterJNI, null, true);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        this(context, flutterLoader, flutterJNI, new PlatformViewsController(), dartVmArgs, automaticallyRegisterPlugins);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @NonNull PlatformViewsController platformViewsController, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        this(context, flutterLoader, flutterJNI, platformViewsController, dartVmArgs, automaticallyRegisterPlugins, false);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @NonNull PlatformViewsController platformViewsController, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins, boolean waitForRestorationData) {
        this(context, flutterLoader, flutterJNI, platformViewsController, dartVmArgs, automaticallyRegisterPlugins, waitForRestorationData, null);
    }

    @VisibleForTesting(otherwise=3)
    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @NonNull PlatformViewsController platformViewsController, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins, boolean waitForRestorationData, @Nullable FlutterEngineGroup group) {
        AssetManager assetManager;
        try {
            assetManager = context.createPackageContext(context.getPackageName(), 0).getAssets();
        }
        catch (PackageManager.NameNotFoundException e) {
            assetManager = context.getAssets();
        }
        FlutterInjector injector = FlutterInjector.instance();
        if (flutterJNI == null) {
            flutterJNI = injector.getFlutterJNIFactory().provideFlutterJNI();
        }
        this.flutterJNI = flutterJNI;
        this.dartExecutor = new DartExecutor(flutterJNI, assetManager);
        this.dartExecutor.onAttachedToJNI();
        DeferredComponentManager deferredComponentManager = FlutterInjector.instance().deferredComponentManager();
        this.accessibilityChannel = new AccessibilityChannel(this.dartExecutor, flutterJNI);
        this.deferredComponentChannel = new DeferredComponentChannel(this.dartExecutor);
        this.lifecycleChannel = new LifecycleChannel(this.dartExecutor);
        this.localizationChannel = new LocalizationChannel(this.dartExecutor);
        this.mouseCursorChannel = new MouseCursorChannel(this.dartExecutor);
        this.navigationChannel = new NavigationChannel(this.dartExecutor);
        this.backGestureChannel = new BackGestureChannel(this.dartExecutor);
        this.platformChannel = new PlatformChannel(this.dartExecutor);
        this.processTextChannel = new ProcessTextChannel(this.dartExecutor, context.getPackageManager());
        this.restorationChannel = new RestorationChannel(this.dartExecutor, waitForRestorationData);
        this.scribeChannel = new ScribeChannel(this.dartExecutor);
        this.settingsChannel = new SettingsChannel(this.dartExecutor);
        this.spellCheckChannel = new SpellCheckChannel(this.dartExecutor);
        this.systemChannel = new SystemChannel(this.dartExecutor);
        this.textInputChannel = new TextInputChannel(this.dartExecutor);
        if (deferredComponentManager != null) {
            deferredComponentManager.setDeferredComponentChannel(this.deferredComponentChannel);
        }
        this.localizationPlugin = new LocalizationPlugin(context, this.localizationChannel);
        if (flutterLoader == null) {
            flutterLoader = injector.flutterLoader();
        }
        if (!flutterJNI.isAttached()) {
            flutterLoader.startInitialization(context.getApplicationContext());
            flutterLoader.ensureInitializationComplete(context, dartVmArgs);
        }
        flutterJNI.addEngineLifecycleListener(this.engineLifecycleListener);
        flutterJNI.setPlatformViewsController(platformViewsController);
        flutterJNI.setLocalizationPlugin(this.localizationPlugin);
        flutterJNI.setDeferredComponentManager(injector.deferredComponentManager());
        if (!flutterJNI.isAttached()) {
            this.attachToJni();
        }
        this.renderer = new FlutterRenderer(flutterJNI);
        this.platformViewsController = platformViewsController;
        this.platformViewsController.onAttachedToJNI();
        this.pluginRegistry = new FlutterEngineConnectionRegistry(context.getApplicationContext(), this, flutterLoader, group);
        this.localizationPlugin.sendLocalesToFlutter(context.getResources().getConfiguration());
        if (automaticallyRegisterPlugins && flutterLoader.automaticallyRegisterPlugins()) {
            GeneratedPluginRegister.registerGeneratedPlugins(this);
        }
        ViewUtils.calculateMaximumDisplayMetrics(context, this);
        ProcessTextPlugin processTextPlugin = new ProcessTextPlugin(this.getProcessTextChannel());
        this.pluginRegistry.add(processTextPlugin);
    }

    private void attachToJni() {
        Log.v(TAG, "Attaching to JNI.");
        this.flutterJNI.attachToNative();
        if (!this.isAttachedToJni()) {
            throw new RuntimeException("FlutterEngine failed to attach to its native Object reference.");
        }
    }

    private boolean isAttachedToJni() {
        return this.flutterJNI.isAttached();
    }

    @NonNull
    FlutterEngine spawn(@NonNull Context context, @NonNull DartExecutor.DartEntrypoint dartEntrypoint, @Nullable String initialRoute, @Nullable List<String> dartEntrypointArgs, @Nullable PlatformViewsController platformViewsController, boolean automaticallyRegisterPlugins, boolean waitForRestorationData) {
        if (!this.isAttachedToJni()) {
            throw new IllegalStateException("Spawn can only be called on a fully constructed FlutterEngine");
        }
        FlutterJNI newFlutterJNI = this.flutterJNI.spawn(dartEntrypoint.dartEntrypointFunctionName, dartEntrypoint.dartEntrypointLibrary, initialRoute, dartEntrypointArgs);
        return new FlutterEngine(context, null, newFlutterJNI, platformViewsController, null, automaticallyRegisterPlugins, waitForRestorationData);
    }

    public void destroy() {
        Log.v(TAG, "Destroying.");
        for (EngineLifecycleListener listener : this.engineLifecycleListeners) {
            listener.onEngineWillDestroy();
        }
        this.pluginRegistry.destroy();
        this.platformViewsController.onDetachedFromJNI();
        this.dartExecutor.onDetachedFromJNI();
        this.flutterJNI.removeEngineLifecycleListener(this.engineLifecycleListener);
        this.flutterJNI.setDeferredComponentManager(null);
        this.flutterJNI.detachFromNativeAndReleaseResources();
        if (FlutterInjector.instance().deferredComponentManager() != null) {
            FlutterInjector.instance().deferredComponentManager().destroy();
            this.deferredComponentChannel.setDeferredComponentManager(null);
        }
    }

    public void addEngineLifecycleListener(@NonNull EngineLifecycleListener listener) {
        this.engineLifecycleListeners.add(listener);
    }

    public void removeEngineLifecycleListener(@NonNull EngineLifecycleListener listener) {
        this.engineLifecycleListeners.remove(listener);
    }

    @NonNull
    public DartExecutor getDartExecutor() {
        return this.dartExecutor;
    }

    @NonNull
    public FlutterRenderer getRenderer() {
        return this.renderer;
    }

    @NonNull
    public AccessibilityChannel getAccessibilityChannel() {
        return this.accessibilityChannel;
    }

    @NonNull
    public LifecycleChannel getLifecycleChannel() {
        return this.lifecycleChannel;
    }

    @NonNull
    public LocalizationChannel getLocalizationChannel() {
        return this.localizationChannel;
    }

    @NonNull
    public NavigationChannel getNavigationChannel() {
        return this.navigationChannel;
    }

    @NonNull
    public BackGestureChannel getBackGestureChannel() {
        return this.backGestureChannel;
    }

    @NonNull
    public PlatformChannel getPlatformChannel() {
        return this.platformChannel;
    }

    @NonNull
    public ProcessTextChannel getProcessTextChannel() {
        return this.processTextChannel;
    }

    @NonNull
    public RestorationChannel getRestorationChannel() {
        return this.restorationChannel;
    }

    @NonNull
    public SettingsChannel getSettingsChannel() {
        return this.settingsChannel;
    }

    @NonNull
    public DeferredComponentChannel getDeferredComponentChannel() {
        return this.deferredComponentChannel;
    }

    @NonNull
    public SystemChannel getSystemChannel() {
        return this.systemChannel;
    }

    @NonNull
    public MouseCursorChannel getMouseCursorChannel() {
        return this.mouseCursorChannel;
    }

    @NonNull
    public TextInputChannel getTextInputChannel() {
        return this.textInputChannel;
    }

    @NonNull
    public ScribeChannel getScribeChannel() {
        return this.scribeChannel;
    }

    @NonNull
    public SpellCheckChannel getSpellCheckChannel() {
        return this.spellCheckChannel;
    }

    @NonNull
    public PluginRegistry getPlugins() {
        return this.pluginRegistry;
    }

    @NonNull
    public LocalizationPlugin getLocalizationPlugin() {
        return this.localizationPlugin;
    }

    @NonNull
    public PlatformViewsController getPlatformViewsController() {
        return this.platformViewsController;
    }

    @NonNull
    public ActivityControlSurface getActivityControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public ServiceControlSurface getServiceControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public BroadcastReceiverControlSurface getBroadcastReceiverControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public ContentProviderControlSurface getContentProviderControlSurface() {
        return this.pluginRegistry;
    }

    @Override
    public void updateDisplayMetrics(float width, float height, float density) {
        this.flutterJNI.updateDisplayMetrics(0, width, height, density);
    }

    public static interface EngineLifecycleListener {
        public void onPreEngineRestart();

        public void onEngineWillDestroy();
    }
}

