/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.FlutterException;
import io.flutter.plugin.common.JSONMessageCodec;
import io.flutter.plugin.common.JSONUtil;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodCodec;
import java.nio.ByteBuffer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONMethodCodec
implements MethodCodec {
    public static final JSONMethodCodec INSTANCE = new JSONMethodCodec();

    private JSONMethodCodec() {
    }

    @Override
    @NonNull
    public ByteBuffer encodeMethodCall(@NonNull MethodCall methodCall) {
        try {
            JSONObject map = new JSONObject();
            map.put("method", (Object)methodCall.method);
            map.put("args", JSONUtil.wrap(methodCall.arguments));
            return JSONMessageCodec.INSTANCE.encodeMessage(map);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
    }

    @Override
    @NonNull
    public MethodCall decodeMethodCall(@NonNull ByteBuffer message) {
        try {
            Object json = JSONMessageCodec.INSTANCE.decodeMessage(message);
            if (json instanceof JSONObject) {
                JSONObject map = (JSONObject)json;
                Object method = map.get("method");
                Object arguments = this.unwrapNull(map.opt("args"));
                if (method instanceof String) {
                    return new MethodCall((String)method, arguments);
                }
            }
            throw new IllegalArgumentException("Invalid method call: " + json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
    }

    @Override
    @NonNull
    public ByteBuffer encodeSuccessEnvelope(@Nullable Object result) {
        return JSONMessageCodec.INSTANCE.encodeMessage(new JSONArray().put(JSONUtil.wrap(result)));
    }

    @Override
    @NonNull
    public ByteBuffer encodeErrorEnvelope(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
        return JSONMessageCodec.INSTANCE.encodeMessage(new JSONArray().put((Object)errorCode).put(JSONUtil.wrap(errorMessage)).put(JSONUtil.wrap(errorDetails)));
    }

    @Override
    @NonNull
    public ByteBuffer encodeErrorEnvelopeWithStacktrace(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails, @Nullable String errorStacktrace) {
        return JSONMessageCodec.INSTANCE.encodeMessage(new JSONArray().put((Object)errorCode).put(JSONUtil.wrap(errorMessage)).put(JSONUtil.wrap(errorDetails)).put(JSONUtil.wrap(errorStacktrace)));
    }

    @Override
    @NonNull
    public Object decodeEnvelope(@NonNull ByteBuffer envelope) {
        try {
            Object json = JSONMessageCodec.INSTANCE.decodeMessage(envelope);
            if (json instanceof JSONArray) {
                JSONArray array = (JSONArray)json;
                if (array.length() == 1) {
                    return this.unwrapNull(array.opt(0));
                }
                if (array.length() == 3) {
                    Object code = array.get(0);
                    Object message = this.unwrapNull(array.opt(1));
                    Object details = this.unwrapNull(array.opt(2));
                    if (code instanceof String && (message == null || message instanceof String)) {
                        throw new FlutterException((String)code, (String)message, details);
                    }
                }
            }
            throw new IllegalArgumentException("Invalid envelope: " + json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
    }

    Object unwrapNull(Object value) {
        return value == JSONObject.NULL ? null : value;
    }
}

