/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.os.Build;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.embedding.engine.systemchannels.ScribeChannel;

public class ScribePlugin
implements ScribeChannel.ScribeMethodHandler {
    @NonNull
    private final ScribeChannel mScribeChannel;
    @NonNull
    private final InputMethodManager mInputMethodManager;
    @NonNull
    private View mView;

    public ScribePlugin(@NonNull View view, @NonNull InputMethodManager imm, @NonNull ScribeChannel scribeChannel) {
        if (Build.VERSION.SDK_INT >= 33) {
            view.setAutoHandwritingEnabled(false);
        }
        this.mView = view;
        this.mInputMethodManager = imm;
        this.mScribeChannel = scribeChannel;
        this.mScribeChannel.setScribeMethodHandler(this);
    }

    public void setView(@NonNull View view) {
        if (view == this.mView) {
            return;
        }
        this.mView = view;
    }

    public void destroy() {
        this.mScribeChannel.setScribeMethodHandler(null);
    }

    @Override
    @RequiresApi(value=34)
    public boolean isStylusHandwritingAvailable() {
        return this.mInputMethodManager.isStylusHandwritingAvailable();
    }

    @Override
    @RequiresApi(value=33)
    public void startStylusHandwriting() {
        this.mInputMethodManager.startStylusHandwriting(this.mView);
    }

    @Override
    public boolean isFeatureAvailable() {
        return Build.VERSION.SDK_INT >= 34 && this.isStylusHandwritingAvailable();
    }
}

