/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.graphics.SurfaceTexture;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

@Keep
public class SurfaceTextureWrapper {
    private SurfaceTexture surfaceTexture;
    private boolean released;
    private boolean attached;
    private Runnable onFrameConsumed;
    private boolean newFrameAvailable = false;

    public SurfaceTextureWrapper(@NonNull SurfaceTexture surfaceTexture) {
        this(surfaceTexture, null);
    }

    public SurfaceTextureWrapper(@NonNull SurfaceTexture surfaceTexture, @Nullable Runnable onFrameConsumed) {
        this.surfaceTexture = surfaceTexture;
        this.released = false;
        this.onFrameConsumed = onFrameConsumed;
    }

    @NonNull
    public SurfaceTexture surfaceTexture() {
        return this.surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            this.newFrameAvailable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldUpdate() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            return this.newFrameAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTexImage() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            this.newFrameAvailable = false;
            if (!this.released) {
                this.surfaceTexture.updateTexImage();
                if (this.onFrameConsumed != null) {
                    this.onFrameConsumed.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (!this.released) {
                this.surfaceTexture.release();
                this.released = true;
                this.attached = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToGLContext(int texName) {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (this.released) {
                return;
            }
            if (this.attached) {
                this.surfaceTexture.detachFromGLContext();
            }
            this.surfaceTexture.attachToGLContext(texName);
            this.attached = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromGLContext() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (this.attached && !this.released) {
                this.surfaceTexture.detachFromGLContext();
                this.attached = false;
            }
        }
    }

    public void getTransformMatrix(@NonNull float[] mtx) {
        this.surfaceTexture.getTransformMatrix(mtx);
    }
}

