/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.Nullable;
import io.flutter.plugin.common.MessageCodec;
import java.nio.ByteBuffer;

public final class BinaryCodec
implements MessageCodec<ByteBuffer> {
    public static final BinaryCodec INSTANCE = new BinaryCodec();
    public static final BinaryCodec INSTANCE_DIRECT = new BinaryCodec(true);
    private final boolean returnsDirectByteBufferFromDecoding;

    private BinaryCodec() {
        this.returnsDirectByteBufferFromDecoding = false;
    }

    private BinaryCodec(boolean returnsDirectByteBufferFromDecoding) {
        this.returnsDirectByteBufferFromDecoding = returnsDirectByteBufferFromDecoding;
    }

    @Override
    public ByteBuffer encodeMessage(@Nullable ByteBuffer message) {
        return message;
    }

    @Override
    public ByteBuffer decodeMessage(@Nullable ByteBuffer message) {
        if (message == null) {
            return message;
        }
        if (this.returnsDirectByteBufferFromDecoding) {
            return message;
        }
        ByteBuffer result = ByteBuffer.allocate(message.capacity());
        result.put(message);
        result.rewind();
        return result;
    }
}

