/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformViewsChannel {
    private static final String TAG = "PlatformViewsChannel";
    private final MethodChannel channel;
    private PlatformViewsHandler handler;
    private final MethodChannel.MethodCallHandler parsingHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (PlatformViewsChannel.this.handler == null) {
                return;
            }
            Log.v(PlatformViewsChannel.TAG, "Received '" + call.method + "' message.");
            switch (call.method) {
                case "create": {
                    this.create(call, result);
                    break;
                }
                case "dispose": {
                    this.dispose(call, result);
                    break;
                }
                case "resize": {
                    this.resize(call, result);
                    break;
                }
                case "offset": {
                    this.offset(call, result);
                    break;
                }
                case "touch": {
                    this.touch(call, result);
                    break;
                }
                case "setDirection": {
                    this.setDirection(call, result);
                    break;
                }
                case "clearFocus": {
                    this.clearFocus(call, result);
                    break;
                }
                case "synchronizeToNativeViewHierarchy": {
                    this.synchronizeToNativeViewHierarchy(call, result);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }

        private void create(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map createArgs = (Map)call.arguments();
            boolean usesPlatformViewLayer = createArgs.containsKey("hybrid") && (Boolean)createArgs.get("hybrid") != false;
            ByteBuffer additionalParams = createArgs.containsKey("params") ? ByteBuffer.wrap((byte[])createArgs.get("params")) : null;
            try {
                if (usesPlatformViewLayer) {
                    PlatformViewCreationRequest request = new PlatformViewCreationRequest((Integer)createArgs.get("id"), (String)createArgs.get("viewType"), 0.0, 0.0, 0.0, 0.0, (Integer)createArgs.get("direction"), PlatformViewCreationRequest.RequestedDisplayMode.HYBRID_ONLY, additionalParams);
                    PlatformViewsChannel.this.handler.createForPlatformViewLayer(request);
                    result.success(null);
                } else {
                    boolean hybridFallback = createArgs.containsKey("hybridFallback") && (Boolean)createArgs.get("hybridFallback") != false;
                    PlatformViewCreationRequest.RequestedDisplayMode displayMode = hybridFallback ? PlatformViewCreationRequest.RequestedDisplayMode.TEXTURE_WITH_HYBRID_FALLBACK : PlatformViewCreationRequest.RequestedDisplayMode.TEXTURE_WITH_VIRTUAL_FALLBACK;
                    PlatformViewCreationRequest request = new PlatformViewCreationRequest((Integer)createArgs.get("id"), (String)createArgs.get("viewType"), createArgs.containsKey("top") ? (Double)createArgs.get("top") : 0.0, createArgs.containsKey("left") ? (Double)createArgs.get("left") : 0.0, (Double)createArgs.get("width"), (Double)createArgs.get("height"), (Integer)createArgs.get("direction"), displayMode, additionalParams);
                    long textureId = PlatformViewsChannel.this.handler.createForTextureLayer(request);
                    if (textureId == -2L) {
                        if (!hybridFallback) {
                            throw new AssertionError((Object)"Platform view attempted to fall back to hybrid mode when not requested.");
                        }
                        result.success(null);
                    } else {
                        result.success(textureId);
                    }
                }
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void dispose(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map disposeArgs = (Map)call.arguments();
            int viewId = (Integer)disposeArgs.get("id");
            try {
                PlatformViewsChannel.this.handler.dispose(viewId);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void resize(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map resizeArgs = (Map)call.arguments();
            PlatformViewResizeRequest resizeRequest = new PlatformViewResizeRequest((Integer)resizeArgs.get("id"), (Double)resizeArgs.get("width"), (Double)resizeArgs.get("height"));
            try {
                PlatformViewsChannel.this.handler.resize(resizeRequest, (PlatformViewBufferSize bufferSize) -> {
                    if (bufferSize == null) {
                        result.error("error", "Failed to resize the platform view", null);
                    } else {
                        HashMap<String, Double> response = new HashMap<String, Double>();
                        response.put("width", Double.valueOf(bufferSize.width));
                        response.put("height", Double.valueOf(bufferSize.height));
                        result.success(response);
                    }
                });
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void offset(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map offsetArgs = (Map)call.arguments();
            try {
                PlatformViewsChannel.this.handler.offset((Integer)offsetArgs.get("id"), (Double)offsetArgs.get("top"), (Double)offsetArgs.get("left"));
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void touch(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            List args = (List)call.arguments();
            PlatformViewTouch touch = new PlatformViewTouch((Integer)args.get(0), (Number)args.get(1), (Number)args.get(2), (Integer)args.get(3), (Integer)args.get(4), args.get(5), args.get(6), (Integer)args.get(7), (Integer)args.get(8), (float)((Double)args.get(9)).doubleValue(), (float)((Double)args.get(10)).doubleValue(), (Integer)args.get(11), (Integer)args.get(12), (Integer)args.get(13), (Integer)args.get(14), ((Number)args.get(15)).longValue());
            try {
                PlatformViewsChannel.this.handler.onTouch(touch);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void setDirection(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map setDirectionArgs = (Map)call.arguments();
            int newDirectionViewId = (Integer)setDirectionArgs.get("id");
            int direction = (Integer)setDirectionArgs.get("direction");
            try {
                PlatformViewsChannel.this.handler.setDirection(newDirectionViewId, direction);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void clearFocus(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            int viewId = (Integer)call.arguments();
            try {
                PlatformViewsChannel.this.handler.clearFocus(viewId);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }

        private void synchronizeToNativeViewHierarchy(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            boolean yes = (Boolean)call.arguments();
            try {
                PlatformViewsChannel.this.handler.synchronizeToNativeViewHierarchy(yes);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel.detailedExceptionString(exception), null);
            }
        }
    };

    public void invokeViewFocused(int viewId) {
        if (this.channel == null) {
            return;
        }
        this.channel.invokeMethod("viewFocused", viewId);
    }

    private static String detailedExceptionString(Exception exception) {
        return Log.getStackTraceString(exception);
    }

    public PlatformViewsChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/platform_views", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingHandler);
    }

    public void setPlatformViewsHandler(@Nullable PlatformViewsHandler handler) {
        this.handler = handler;
    }

    public static class PlatformViewTouch {
        public final int viewId;
        @NonNull
        public final Number downTime;
        @NonNull
        public final Number eventTime;
        public final int action;
        public final int pointerCount;
        @NonNull
        public final Object rawPointerPropertiesList;
        @NonNull
        public final Object rawPointerCoords;
        public final int metaState;
        public final int buttonState;
        public final float xPrecision;
        public final float yPrecision;
        public final int deviceId;
        public final int edgeFlags;
        public final int source;
        public final int flags;
        public final long motionEventId;

        public PlatformViewTouch(int viewId, @NonNull Number downTime, @NonNull Number eventTime, int action, int pointerCount, @NonNull Object rawPointerPropertiesList, @NonNull Object rawPointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags, long motionEventId) {
            this.viewId = viewId;
            this.downTime = downTime;
            this.eventTime = eventTime;
            this.action = action;
            this.pointerCount = pointerCount;
            this.rawPointerPropertiesList = rawPointerPropertiesList;
            this.rawPointerCoords = rawPointerCoords;
            this.metaState = metaState;
            this.buttonState = buttonState;
            this.xPrecision = xPrecision;
            this.yPrecision = yPrecision;
            this.deviceId = deviceId;
            this.edgeFlags = edgeFlags;
            this.source = source;
            this.flags = flags;
            this.motionEventId = motionEventId;
        }
    }

    public static interface PlatformViewBufferResized {
        public void run(@Nullable PlatformViewBufferSize var1);
    }

    public static class PlatformViewBufferSize {
        public final int width;
        public final int height;

        public PlatformViewBufferSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static class PlatformViewResizeRequest {
        public final int viewId;
        public final double newLogicalWidth;
        public final double newLogicalHeight;

        public PlatformViewResizeRequest(int viewId, double newLogicalWidth, double newLogicalHeight) {
            this.viewId = viewId;
            this.newLogicalWidth = newLogicalWidth;
            this.newLogicalHeight = newLogicalHeight;
        }
    }

    public static class PlatformViewCreationRequest {
        public final int viewId;
        @NonNull
        public final String viewType;
        public final double logicalWidth;
        public final double logicalHeight;
        public final double logicalTop;
        public final double logicalLeft;
        public final int direction;
        public final RequestedDisplayMode displayMode;
        @Nullable
        public final ByteBuffer params;

        public PlatformViewCreationRequest(int viewId, @NonNull String viewType, double logicalTop, double logicalLeft, double logicalWidth, double logicalHeight, int direction, @Nullable ByteBuffer params) {
            this(viewId, viewType, logicalTop, logicalLeft, logicalWidth, logicalHeight, direction, RequestedDisplayMode.TEXTURE_WITH_VIRTUAL_FALLBACK, params);
        }

        public PlatformViewCreationRequest(int viewId, @NonNull String viewType, double logicalTop, double logicalLeft, double logicalWidth, double logicalHeight, int direction, RequestedDisplayMode displayMode, @Nullable ByteBuffer params) {
            this.viewId = viewId;
            this.viewType = viewType;
            this.logicalTop = logicalTop;
            this.logicalLeft = logicalLeft;
            this.logicalWidth = logicalWidth;
            this.logicalHeight = logicalHeight;
            this.direction = direction;
            this.displayMode = displayMode;
            this.params = params;
        }

        public static enum RequestedDisplayMode {
            TEXTURE_WITH_VIRTUAL_FALLBACK,
            TEXTURE_WITH_HYBRID_FALLBACK,
            HYBRID_ONLY;

        }
    }

    public static interface PlatformViewsHandler {
        public static final long NON_TEXTURE_FALLBACK = -2L;

        public void createForPlatformViewLayer(@NonNull PlatformViewCreationRequest var1);

        public long createForTextureLayer(@NonNull PlatformViewCreationRequest var1);

        public void dispose(int var1);

        public void resize(@NonNull PlatformViewResizeRequest var1, @NonNull PlatformViewBufferResized var2);

        public void offset(int var1, double var2, double var4);

        public void onTouch(@NonNull PlatformViewTouch var1);

        public void setDirection(int var1, int var2);

        public void clearFocus(int var1);

        public void synchronizeToNativeViewHierarchy(boolean var1);
    }
}

