/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.graphics.Insets;
import android.os.Build;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;

@VisibleForTesting
@RequiresApi(value=30)
@SuppressLint(value={"NewApi", "Override"})
@Keep
class ImeSyncDeferringInsetsCallback {
    private final int deferredInsetTypes = WindowInsets.Type.ime();
    private View view;
    private WindowInsets lastWindowInsets;
    private AnimationCallback animationCallback;
    private InsetsListener insetsListener;
    private ImeVisibilityListener imeVisibilityListener;
    private boolean animating = false;
    private boolean needsSave = false;

    ImeSyncDeferringInsetsCallback(@NonNull View view) {
        this.view = view;
        this.animationCallback = new AnimationCallback();
        this.insetsListener = new InsetsListener();
    }

    void install() {
        this.view.setWindowInsetsAnimationCallback((WindowInsetsAnimation.Callback)this.animationCallback);
        this.view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)this.insetsListener);
    }

    void remove() {
        this.view.setWindowInsetsAnimationCallback(null);
        this.view.setOnApplyWindowInsetsListener(null);
    }

    void setImeVisibilityListener(ImeVisibilityListener imeVisibilityListener) {
        this.imeVisibilityListener = imeVisibilityListener;
    }

    @VisibleForTesting
    View.OnApplyWindowInsetsListener getInsetsListener() {
        return this.insetsListener;
    }

    @VisibleForTesting
    WindowInsetsAnimation.Callback getAnimationCallback() {
        return this.animationCallback;
    }

    @VisibleForTesting
    ImeVisibilityListener getImeVisibilityListener() {
        return this.imeVisibilityListener;
    }

    public static interface ImeVisibilityListener {
        public void onImeVisibilityChanged(boolean var1);
    }

    @Keep
    private class AnimationCallback
    extends WindowInsetsAnimation.Callback {
        AnimationCallback() {
            super(1);
        }

        public void onPrepare(WindowInsetsAnimation animation) {
            ImeSyncDeferringInsetsCallback.this.needsSave = true;
            if ((animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) != 0) {
                ImeSyncDeferringInsetsCallback.this.animating = true;
            }
        }

        public WindowInsets onProgress(WindowInsets insets, List<WindowInsetsAnimation> runningAnimations) {
            if (!ImeSyncDeferringInsetsCallback.this.animating || ImeSyncDeferringInsetsCallback.this.needsSave) {
                return insets;
            }
            boolean matching = false;
            for (WindowInsetsAnimation animation : runningAnimations) {
                if ((animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) == 0) continue;
                matching = true;
            }
            if (!matching) {
                return insets;
            }
            int excludedInsets = 0;
            int systemUiFlags = ImeSyncDeferringInsetsCallback.this.view.getWindowSystemUiVisibility();
            if (Build.VERSION.SDK_INT < 35 && (systemUiFlags & 0x200) == 0 && (systemUiFlags & 2) == 0) {
                excludedInsets = insets.getInsets((int)WindowInsets.Type.navigationBars()).bottom;
            }
            WindowInsets.Builder builder = new WindowInsets.Builder(ImeSyncDeferringInsetsCallback.this.lastWindowInsets);
            Insets newImeInsets = Insets.of((int)0, (int)0, (int)0, (int)Math.max(insets.getInsets((int)((ImeSyncDeferringInsetsCallback)ImeSyncDeferringInsetsCallback.this).deferredInsetTypes).bottom - excludedInsets, 0));
            builder.setInsets(ImeSyncDeferringInsetsCallback.this.deferredInsetTypes, newImeInsets);
            ImeSyncDeferringInsetsCallback.this.view.onApplyWindowInsets(builder.build());
            return insets;
        }

        public void onEnd(WindowInsetsAnimation animation) {
            WindowInsetsCompat insets;
            if (ImeSyncDeferringInsetsCallback.this.animating && (animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) != 0) {
                ImeSyncDeferringInsetsCallback.this.animating = false;
                if (ImeSyncDeferringInsetsCallback.this.lastWindowInsets != null && ImeSyncDeferringInsetsCallback.this.view != null) {
                    ImeSyncDeferringInsetsCallback.this.view.dispatchApplyWindowInsets(ImeSyncDeferringInsetsCallback.this.lastWindowInsets);
                }
            }
            if ((insets = ViewCompat.getRootWindowInsets((View)ImeSyncDeferringInsetsCallback.this.view)) != null && ImeSyncDeferringInsetsCallback.this.imeVisibilityListener != null) {
                boolean imeVisible = insets.isVisible(WindowInsetsCompat.Type.ime());
                ImeSyncDeferringInsetsCallback.this.imeVisibilityListener.onImeVisibilityChanged(imeVisible);
            }
        }
    }

    private class InsetsListener
    implements View.OnApplyWindowInsetsListener {
        private InsetsListener() {
        }

        public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
            ImeSyncDeferringInsetsCallback.this.view = view;
            if (ImeSyncDeferringInsetsCallback.this.needsSave) {
                ImeSyncDeferringInsetsCallback.this.lastWindowInsets = windowInsets;
                ImeSyncDeferringInsetsCallback.this.needsSave = false;
            }
            if (ImeSyncDeferringInsetsCallback.this.animating) {
                return WindowInsets.CONSUMED;
            }
            return view.onApplyWindowInsets(windowInsets);
        }
    }
}

