/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.media.MediaDataSource;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.image.Metadata;
import java.io.IOException;

@RequiresApi(value=28)
class MediaMetadataReader {
    private static final String TAG = "MediaMetadataReader";

    MediaMetadataReader() {
    }

    @NonNull
    private static MediaExtractor getMediaExtractor(final byte[] bytes) throws IOException {
        MediaDataSource dataSource = new MediaDataSource(){

            public long getSize() throws IOException {
                return bytes.length;
            }

            public int readAt(long position, byte[] buffer, int offset, int size) throws IOException {
                if (position >= (long)bytes.length) {
                    return -1;
                }
                if (position + (long)size > (long)bytes.length) {
                    size = (int)((long)bytes.length - position);
                }
                System.arraycopy(bytes, (int)position, buffer, offset, size);
                return size;
            }

            public void close() throws IOException {
            }
        };
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(dataSource);
        return extractor;
    }

    static void read(byte[] bytes, @NonNull Metadata metadata) {
        try {
            MediaExtractor extractor = MediaMetadataReader.getMediaExtractor(bytes);
            MediaMetadataReader.read(bytes, metadata, extractor);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to decode HEIF image using MediaExtractor", e);
        }
    }

    @VisibleForTesting
    static void read(byte[] bytes, @NonNull Metadata metadata, MediaExtractor extractor) {
        int rotation = 0;
        try {
            int trackCount = extractor.getTrackCount();
            for (int i = 0; i < trackCount; ++i) {
                MediaFormat format = extractor.getTrackFormat(i);
                String mime = format.getString("mime");
                if (mime == null || !mime.startsWith("image/")) continue;
                if (format.containsKey("rotation-degrees")) {
                    rotation = format.getInteger("rotation-degrees");
                }
                int finalWidth = metadata.originalWidth;
                int finalHeight = metadata.originalHeight;
                if (rotation == 90 || rotation == 270) {
                    finalHeight = metadata.originalWidth;
                    finalWidth = metadata.originalHeight;
                }
                metadata.height = finalHeight;
                metadata.width = finalWidth;
                metadata.rotation = rotation;
                break;
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to decode HEIF image using MediaExtractor", e);
        }
    }
}

