/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.embedding.engine.image.ImageDecoder;
import io.flutter.embedding.engine.image.ImageDecoderDefaultImpl;
import io.flutter.embedding.engine.image.ImageDecoderHeifApi36Impl;
import io.flutter.embedding.engine.image.ImageDecoderHeifPre36Impl;
import io.flutter.embedding.engine.image.Metadata;
import java.nio.ByteBuffer;

@RequiresApi(value=28)
public class FlutterImageDecoder {
    public static Bitmap decodeImage(@NonNull ByteBuffer buffer, @NonNull HeaderListener headerListener) {
        Metadata metadata = Metadata.create(buffer, headerListener);
        ImageDecoder impl = null;
        if (metadata.isHeif()) {
            if (Build.VERSION.SDK_INT == 36) {
                impl = new ImageDecoderHeifApi36Impl();
            } else if (Build.VERSION.SDK_INT < 36) {
                impl = new ImageDecoderHeifPre36Impl();
            }
        }
        if (impl == null) {
            impl = new ImageDecoderDefaultImpl(headerListener);
        }
        return impl.decodeImage(buffer, metadata);
    }

    public static interface HeaderListener {
        public void onImageHeader(int var1, int var2);
    }
}

